/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.entity.ReportClaimStatistic;
import com.reportfrom.wapp.mapper.first.ReportClaimRedStatisticMapper;
import com.reportfrom.wapp.mapper.first.ReportClaimStatisticMapper;
import com.reportfrom.wapp.mapper.first.TXfBillDeductMapper;
import com.reportfrom.wapp.request.ReportClaimStatisticDetailsReq;
import com.reportfrom.wapp.request.ReportClaimStatisticReq;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.ReportClaimStatisticService;
import com.reportfrom.wapp.service.impl.ReportClaimStatisticServiceImpl;
import com.reportfrom.wapp.util.DateUtils;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import com.reportfrom.wapp.util.excelUtil.ExcelReturnInterface;
import com.reportfrom.wapp.util.excelUtil.XssfSheetReaderUtils;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ReportClaimStatisticServiceImpl
extends ServiceImpl<ReportClaimStatisticMapper, ReportClaimStatistic>
implements ReportClaimStatisticService {
    private static final Logger log = LoggerFactory.getLogger(ReportClaimStatisticServiceImpl.class);
    @Autowired
    private ReportClaimStatisticMapper reportClaimStatisticMapper;
    @Autowired
    private ReportClaimRedStatisticMapper reportClaimRedStatisticMapper;
    @Autowired
    private TXfBillDeductMapper tXfBillDeductMapper;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;
    private ThreadPoolExecutor taskPool = new ThreadPoolExecutor(5, 10, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));

    public void uploadMain(MultipartFile file, HttpServletResponse response, String token) {
        1 excelReturnInterface = new /* Unavailable Anonymous Inner Class!! */;
        try {
            XssfSheetReaderUtils.startReadExcel((InputStream)file.getInputStream(), (ExcelReturnInterface)excelReturnInterface, (Integer)1000, (Integer)1);
            this.startSelectZeroTaxRateForInsert();
            String condition = JSON.toJSONString((Object)"params");
            String path = "upload";
            String fileName = file.getOriginalFilename();
            this.baseReportExportService.exportExcel(token, condition, path, fileName);
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6excel\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }

    public void uploadChange(MultipartFile file, HttpServletResponse response, String token) {
        2 excelReturnInterface = new /* Unavailable Anonymous Inner Class!! */;
        try {
            XssfSheetReaderUtils.startReadExcel((InputStream)file.getInputStream(), (ExcelReturnInterface)excelReturnInterface, (Integer)1000, (Integer)1);
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6excel\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        String condition = JSON.toJSONString((Object)"params");
        String path = "upload";
        String fileName = file.getOriginalFilename();
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public void startSelectZeroTaxRateForInsert() {
        log.info("\u5f00\u59cb\u67e5\u8be2\u4e0a\u67080\u7a0e\u7387\u5df2\u5339\u914d\u7ea2\u5b57\u5355\u636e\u7684\u7d22\u8d54\u5355...");
        String lastMonth = DateUtils.getLastMonth();
        Map queryDeductMap = DateUtils.getFistAndLastByString((String)lastMonth, (String)"yyyyMM", (String)"String", (String)"yyyy-MM-dd");
        List zeroDemo = this.tXfBillDeductMapper.selecetZeroSumByParams(queryDeductMap);
        for (ReportClaimStatistic report : zeroDemo) {
            report.setSubject("2226020");
            report.setSupplierDInvoice(report.getSupplierNo() + report.getBlueInvoiceNo());
            report.setDateMonth(lastMonth);
            QueryWrapper wrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"date_month", (Object)lastMonth)).eq((Object)"blue_invoice_no", (Object)report.getBlueInvoiceNo())).eq((Object)"supplier_no", (Object)report.getSupplierNo());
            ReportClaimStatistic insertOrUpdateEn = (ReportClaimStatistic)this.reportClaimStatisticMapper.selectOne((Wrapper)wrapper);
            if (insertOrUpdateEn == null) {
                this.reportClaimStatisticMapper.insert((Object)report);
                continue;
            }
            report.setId(insertOrUpdateEn.getId());
            this.reportClaimStatisticMapper.updateById((Object)report);
        }
    }

    public PageUtils queryList(ReportClaimStatisticReq params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        if (!StringUtils.isEmpty((String)params.getDateMonth())) {
            List<String> dataMonnnthList = Arrays.asList(params.getDateMonth().split(","));
            map.put("startDateMonth", dataMonnnthList.get(0));
            map.put("endDateMonth", dataMonnnthList.get(1));
        }
        List list = this.reportClaimStatisticMapper.selectListByParams(map);
        Integer count = this.reportClaimStatisticMapper.selectCountByParams(map);
        for (ReportClaimStatistic statistic : list) {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("blueInvoiceNo", statistic.getBlueInvoiceNo());
            queryMap.put("supplierNo", statistic.getSupplierNo());
            queryMap.put("dateMonth", statistic.getDateMonth());
            List redStatistic = this.reportClaimRedStatisticMapper.selectDetailsList(queryMap);
            statistic.setRedStatisticsList(redStatistic);
        }
        PageUtils rpage = new PageUtils();
        rpage.setList(list);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public PageUtils queryDetailsList(ReportClaimStatisticDetailsReq params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        List RedStatistics = this.reportClaimRedStatisticMapper.selectDetailsList(map);
        Integer count = 0;
        if (!CollectionUtils.isEmpty((Collection)RedStatistics)) {
            count = RedStatistics.size();
        }
        PageUtils rpage = new PageUtils();
        rpage.setList(RedStatistics);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void export(ReportClaimStatisticReq params, String token) {
        String fileName = "\u7d22\u8d54\u7a0e\u52a1\u62a5\u8868.xlsx";
        List<String> dataMonnnthList = Arrays.asList(params.getDateMonth().split(","));
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("startDateMonth", dataMonnnthList.get(0));
        map.put("endDateMonth", dataMonnnthList.get(1));
        List voList = this.reportClaimStatisticMapper.selectListByParams(map);
        String path = this.ftpConfig.getServerSavePath();
        for (ReportClaimStatistic statistic : voList) {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("blueInvoiceNo", statistic.getBlueInvoiceNo());
            queryMap.put("supplierNo", statistic.getSupplierNo());
            queryMap.put("dateMonth", statistic.getDateMonth());
            List redStatistic = this.reportClaimRedStatisticMapper.selectDetailsList(queryMap);
            statistic.setRedStatisticsList(redStatistic);
        }
        ExcelUtils.createExcel((List)voList, (String)ExcelTypeConfig.CLAIM_TAX_STATEMENT, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    private List<ReportClaimStatistic> excelToList(List<List<String>> rowList) {
        ArrayList<ReportClaimStatistic> list = new ArrayList<ReportClaimStatistic>();
        try {
            for (int i = 0; i < rowList.size(); ++i) {
                List<String> cellList = rowList.get(i);
                String cell = cellList.get(26);
                if (StringUtils.isEmpty((String)cell)) continue;
                ReportClaimStatistic reportClaimStatistic = new ReportClaimStatistic();
                reportClaimStatistic.setCompanyCode(cellList.get(0));
                reportClaimStatistic.setSubject(cellList.get(1));
                reportClaimStatistic.setAllocation(cellList.get(2));
                reportClaimStatistic.setCertificateNo(cellList.get(3));
                reportClaimStatistic.setBusinessScope(cellList.get(4));
                reportClaimStatistic.setCertificateType(cellList.get(5));
                reportClaimStatistic.setPostingDate(cellList.get(6));
                reportClaimStatistic.setCertificateDate(cellList.get(7));
                reportClaimStatistic.setAccountingCode(cellList.get(8));
                if (!StringUtils.isEmpty((String)cellList.get(9))) {
                    BigDecimal bigDecimal = new BigDecimal(cellList.get(9));
                    reportClaimStatistic.setStandardCurrencyAmount(bigDecimal);
                }
                reportClaimStatistic.setStandardCurrency(cellList.get(10));
                reportClaimStatistic.setTaxCode(cellList.get(11));
                reportClaimStatistic.setClearCertificate(cellList.get(12));
                reportClaimStatistic.setProfitCenter(cellList.get(13));
                reportClaimStatistic.setDuan(cellList.get(14));
                reportClaimStatistic.setTextContent(cellList.get(15));
                reportClaimStatistic.setReverseSubjectType(cellList.get(16));
                reportClaimStatistic.setReverseSubjectAccount(cellList.get(17));
                reportClaimStatistic.setPartner(cellList.get(18));
                reportClaimStatistic.setCertificateTitle(cellList.get(19));
                reportClaimStatistic.setReferenceCodeBt1(cellList.get(20));
                reportClaimStatistic.setReferenceCodeTt1(cellList.get(21));
                reportClaimStatistic.setReferenceCode1(cellList.get(22));
                reportClaimStatistic.setReferenceCode2(cellList.get(23));
                reportClaimStatistic.setReference(cellList.get(24));
                reportClaimStatistic.setInvoiceReference(cellList.get(25));
                reportClaimStatistic.setDateMonth(cellList.get(26));
                reportClaimStatistic.setBlueInvoiceNo(cellList.get(28));
                reportClaimStatistic.setSupplierNo(cellList.get(29));
                reportClaimStatistic.setSupplierName(cellList.get(30));
                reportClaimStatistic.setSupplierDInvoice(cellList.get(31));
                list.add(reportClaimStatistic);
            }
        }
        catch (Exception e) {
            log.error("parse excel file error :", (Throwable)e);
        }
        return list;
    }

    private List<ReportClaimStatistic> excelChangeToList(List<List<String>> rowList) {
        ArrayList<ReportClaimStatistic> list = new ArrayList<ReportClaimStatistic>();
        try {
            for (int i = 0; i < rowList.size(); ++i) {
                List<String> cellList = rowList.get(i);
                String cell = cellList.get(0);
                if (StringUtils.isEmpty((String)cell)) continue;
                ReportClaimStatistic reportClaimStatistic = new ReportClaimStatistic();
                reportClaimStatistic.setDateMonth(cellList.get(0));
                reportClaimStatistic.setBlueInvoiceNo(cellList.get(1));
                reportClaimStatistic.setSupplierNo(cellList.get(2));
                if (!StringUtils.isEmpty((String)cellList.get(3))) {
                    reportClaimStatistic.setCheckBalanceAmount(new BigDecimal(cellList.get(3)).setScale(2, 4));
                }
                if (!StringUtils.isEmpty((String)cellList.get(4))) {
                    reportClaimStatistic.setApplyAmount(new BigDecimal(cellList.get(4)).setScale(2, 4));
                }
                reportClaimStatistic.setDealTime(cellList.get(5));
                list.add(reportClaimStatistic);
            }
        }
        catch (Exception e) {
            log.error("parse excel file error :", (Throwable)e);
        }
        return list;
    }

    static /* synthetic */ List access$000(ReportClaimStatisticServiceImpl x0, List x1) {
        return x0.excelToList(x1);
    }

    static /* synthetic */ ReportClaimStatisticMapper access$100(ReportClaimStatisticServiceImpl x0) {
        return x0.reportClaimStatisticMapper;
    }

    static /* synthetic */ ThreadPoolExecutor access$200(ReportClaimStatisticServiceImpl x0) {
        return x0.taskPool;
    }

    static /* synthetic */ List access$300(ReportClaimStatisticServiceImpl x0, List x1) {
        return x0.excelChangeToList(x1);
    }

    static /* synthetic */ TXfBillDeductMapper access$400(ReportClaimStatisticServiceImpl x0) {
        return x0.tXfBillDeductMapper;
    }
}

