/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.taskthread;

import com.reportfrom.wapp.config.BeanContext;
import com.reportfrom.wapp.entity.ReportClaimStatistic;
import com.reportfrom.wapp.entity.ReportClaimStatisticBeanWithTaxRate;
import com.reportfrom.wapp.mapper.first.ReportClaimStatisticMapper;
import com.reportfrom.wapp.mapper.first.TXfBillDeductMapper;
import com.reportfrom.wapp.util.DateUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class ReportClaimUploadMainExcelThread
implements Runnable {
    private TXfBillDeductMapper tXfBillDeductMapper = (TXfBillDeductMapper)BeanContext.getBean(TXfBillDeductMapper.class);
    private ReportClaimStatisticMapper reportClaimStatisticMapper = (ReportClaimStatisticMapper)BeanContext.getBean(ReportClaimStatisticMapper.class);
    private List<ReportClaimStatistic> updateList;
    private Map<String, List<ReportClaimStatistic>> collect;

    public ReportClaimUploadMainExcelThread() {
    }

    public ReportClaimUploadMainExcelThread(List<ReportClaimStatistic> updateList, Map<String, List<ReportClaimStatistic>> collect) {
        this.updateList = updateList;
        this.collect = collect;
    }

    @Override
    public void run() {
        Map<String, List<ReportClaimStatistic>> collect2 = this.updateList.stream().collect(Collectors.groupingBy(a -> a.getDateMonth() + "_" + a.getBlueInvoiceNo() + "_" + a.getSupplierNo()));
        Set entries = this.collect.entrySet();
        for (Map.Entry next : entries) {
            List<ReportClaimStatistic> updateStatisticsList;
            List value = (List)next.getValue();
            ReportClaimStatistic reportClaimStatistic = (ReportClaimStatistic)value.get(0);
            if (reportClaimStatistic.getDateMonth().length() == 6) {
                ReportClaimStatisticBeanWithTaxRate unsettledDemo;
                BigDecimal standardCurrencyAmount = reportClaimStatistic.getStandardCurrencyAmount();
                Map queryDeductMap = DateUtils.getFistAndLastByString((String)reportClaimStatistic.getDateMonth(), (String)"yyyyMM", (String)"String", null);
                queryDeductMap.put("blueInvoiceNo", reportClaimStatistic.getBlueInvoiceNo());
                queryDeductMap.put("supplierNo", reportClaimStatistic.getSupplierNo());
                ReportClaimStatisticBeanWithTaxRate demo = this.tXfBillDeductMapper.selectSumByParams(queryDeductMap);
                if (demo != null) {
                    reportClaimStatistic.setClaimAmountWithTax(demo.getClaimAmountWithTax());
                    reportClaimStatistic.setClaimTaxAmount(demo.getClaimTaxAmount());
                    if (standardCurrencyAmount == null) {
                        standardCurrencyAmount = new BigDecimal(0);
                    }
                    reportClaimStatistic.setDifferenceTaxAmount(standardCurrencyAmount.subtract(demo.getClaimTaxAmount()));
                }
                if ((unsettledDemo = this.tXfBillDeductMapper.selectUnsettledSumByParams(queryDeductMap)) != null) {
                    reportClaimStatistic.setUnsettledTaxAmount(unsettledDemo.getUnsettledTaxAmount());
                    reportClaimStatistic.setUnsettledAmountWithTax(unsettledDemo.getUnsettledAmountWithTax());
                }
            }
            if (CollectionUtils.isEmpty(updateStatisticsList = collect2.get(next.getKey()))) {
                if (reportClaimStatistic.getDateMonth().length() != 6) continue;
                this.reportClaimStatisticMapper.insert((Object)reportClaimStatistic);
                continue;
            }
            ReportClaimStatistic updateStatistics = updateStatisticsList.get(0);
            reportClaimStatistic.setId(updateStatistics.getId());
            this.reportClaimStatisticMapper.updateById((Object)reportClaimStatistic);
        }
    }
}

