/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.mq;

import com.alibaba.druid.util.StringUtils;
import java.util.Map;
import org.apache.activemq.command.ActiveMQQueue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsMessagingTemplate;
import org.springframework.stereotype.Service;

@Service
public class ActiveMqProducer {
    @Autowired
    private JmsMessagingTemplate jmsMessagingTemplate;

    public void send(String queueName, String msg) {
        if (StringUtils.isEmpty((String)queueName)) {
            throw new RuntimeException("queueName not null");
        }
        if (StringUtils.isEmpty((String)msg)) {
            throw new RuntimeException("msg not null");
        }
        this.jmsMessagingTemplate.convertAndSend((Object)new ActiveMQQueue(queueName), (Object)msg);
    }

    public void send(String queueName, String msg, Map<String, Object> headers) {
        if (StringUtils.isEmpty((String)queueName)) {
            throw new RuntimeException("queueName not null");
        }
        if (StringUtils.isEmpty((String)msg)) {
            throw new RuntimeException("msg not null");
        }
        this.jmsMessagingTemplate.convertAndSend((Object)new ActiveMQQueue(queueName), (Object)msg, headers);
    }
}

