/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.quartz;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.reportfrom.wapp.entity.InvoiceGetLogEntity;
import com.reportfrom.wapp.entity.ReportSettlement;
import com.reportfrom.wapp.entity.ReportSettlementItem;
import com.reportfrom.wapp.mapper.second.InvoiceSyncMapper;
import com.reportfrom.wapp.mapper.second.ReportSettlementItemMapper;
import com.reportfrom.wapp.mapper.second.ReportSettlementMapper;
import com.reportfrom.wapp.quartz.InvoiceSyncQuartz;
import com.reportfrom.wapp.util.HttpClientUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;

@DS(value="second")
public class InvoiceSyncQuartz {
    private static final Logger log = LoggerFactory.getLogger(InvoiceSyncQuartz.class);
    @Autowired
    private InvoiceSyncMapper invoiceSyncMapper;
    @Autowired
    private ReportSettlementMapper reportSettlementMapper;
    @Autowired
    private ReportSettlementItemMapper reportSettlementItemMapper;
    @Value(value="${client.user.invoice.list.url}")
    private String invoiceListUrl;
    @Value(value="${client.user.invoice.detail.url}")
    private String invoiceDetailUrl;
    @Value(value="${client.user.invoice.list.page}")
    private int page;
    @Value(value="${client.user.invoice.list.pageSize}")
    private int pageSize;

    @Scheduled(cron="${quartz.jv.chc.invoiceSyncQuartz.cron}")
    public void invoiceSync() {
        this.invoiceSyncService();
    }

    public void invoiceSyncService() {
        log.info("\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u5f00\u59cb");
        String startTimeStr = this.invoiceSyncMapper.getMaxSyncTime();
        LocalDateTime startTime = null;
        startTime = !StringUtils.isEmpty((String)startTimeStr) ? LocalDateTime.parse(startTimeStr, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).minusSeconds(-1L) : LocalDateTime.parse("2000-01-01 00:00:00", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDateTime endTime = LocalDateTime.now().minusMinutes(2L);
        if (endTime.compareTo(startTime) <= 0) {
            log.warn("\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u5f02\u5e38");
            return;
        }
        1 entityMap = new /* Unavailable Anonymous Inner Class!! */;
        startTimeStr = startTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String endTimeStr = endTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        entityMap.put("beginCreateTime", startTimeStr);
        entityMap.put("endCreateTime", endTimeStr);
        String resultJsonResult = HttpClientUtils.doPostJson((String)this.invoiceListUrl, (Map)entityMap);
        if (!StringUtils.isEmpty((String)resultJsonResult)) {
            JSONObject resultJsonObject = JSONObject.parseObject((String)resultJsonResult);
            InvoiceGetLogEntity logEntity = new InvoiceGetLogEntity();
            logEntity.setStartTime(startTimeStr);
            logEntity.setEndTime(endTimeStr);
            logEntity.setIsSync("1");
            logEntity.setTotal(resultJsonObject.getLong("totalNum"));
            ArrayList itemList = new ArrayList(resultJsonObject.getInteger("totalNum"));
            if (logEntity.getTotal() > 0L) {
                this.itemListAdd(itemList, resultJsonObject);
            }
            if (resultJsonObject.getInteger("totalPage") > 1) {
                for (int i = 2; i <= resultJsonObject.getInteger("totalPage"); ++i) {
                    resultJsonResult = HttpClientUtils.doPostJson((String)this.invoiceListUrl, (Map)entityMap);
                    if (StringUtils.isEmpty((String)resultJsonResult)) continue;
                    resultJsonObject = JSONObject.parseObject((String)resultJsonResult);
                    this.itemListAdd(itemList, resultJsonObject);
                }
            }
            if (itemList.size() > 0) {
                ArrayList settlements = new ArrayList();
                ArrayList settlementItems = new ArrayList();
                itemList.forEach(s -> this.getInvoiceEntity(s, settlements, settlementItems));
                this.saveBatch(logEntity, settlements, settlementItems);
            }
        }
        log.info("\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u7ed3\u675f");
    }

    public void saveBatch(InvoiceGetLogEntity logEntity, List<ReportSettlement> settlements, List<ReportSettlementItem> settlementItems) {
        this.invoiceSyncMapper.addLog(logEntity);
        settlements.forEach(t -> this.reportSettlementMapper.insert(t));
        settlementItems.forEach(t -> this.reportSettlementItemMapper.insert(t));
    }

    private void getInvoiceEntity(String statementNo, List<ReportSettlement> settlements, List<ReportSettlementItem> settlementItems) {
        String url = this.invoiceDetailUrl + "?statementNo=" + statementNo;
        String resultJsonStr = HttpClientUtils.doPostJson((String)url, null);
        if (StringUtils.isEmpty((String)resultJsonStr)) {
            return;
        }
        JSONArray jsonArray = JSONArray.parseArray((String)resultJsonStr);
        for (int i = 0; i < jsonArray.size(); ++i) {
            ReportSettlement entity = new ReportSettlement();
            JSONObject json = jsonArray.getJSONObject(i);
            entity.setId(json.getLong("id"));
            entity.setSettlementNo(json.getString("businessStatementNum"));
            entity.setInvoiceType(json.getString("invoiceType"));
            entity.setSellerNo(json.getString("pinNum"));
            entity.setPurchaserNo(json.getString("store"));
            entity.setPurchaserTaxNo(json.getString("purchaserTaxNum"));
            entity.setPurchaserName(json.getString("purchaserName"));
            entity.setPurchaserAddress(json.getString("purchaserAddress"));
            entity.setPurchaserTel(json.getString("purchaserPhone"));
            entity.setPurchaserBankName(json.getString("purchaserBankName"));
            entity.setPurchaserBankAccount(json.getString("purchaserBankNum"));
            entity.setAmountWithoutTax(new BigDecimal(json.getString("excludingTaxAmount")));
            entity.setTaxAmount(new BigDecimal(json.getString("tax")));
            entity.setAmountWithTax(new BigDecimal(json.getString("totalPriceTax")));
            entity.setDiscountWithoutTax(new BigDecimal(json.getString("taxFreeDiscountAmount")));
            entity.setDiscountTax(new BigDecimal(json.getString("discountAmount")));
            entity.setDiscountWithTax(new BigDecimal(json.getString("taxIncludedDiscountAmount")));
            entity.setRemark(json.getString("remark"));
            entity.setStatus(json.getString("invoiceStatus"));
            entity.setSystemOrig(json.getString("invoiceInformationSource"));
            entity.setContractNo(json.getString("channelText"));
            entity.setPurchaserEmail(json.getString("receiveMailbox"));
            entity.setCreateTime(json.getString("createTime"));
            entity.setExt2(json.getString("remark2"));
            entity.setExt3(json.getString("remark3"));
            entity.setCashierName(json.getString("payee"));
            entity.setCheckerName(json.getString("reviewer"));
            entity.setInvoicerName(json.getString("issuer"));
            entity.setRedReason(json.getString("cancelStatus"));
            entity.setInvoiceCode(json.getString("fapiaoCode"));
            entity.setInvoiceNo(json.getString("fapiaoNumber"));
            settlements.add(entity);
            if (StringUtils.isEmpty((String)json.getString("invoiceAmountWithoutTax")) && StringUtils.isEmpty((String)json.getString("invoiceTaxAmount")) && StringUtils.isEmpty((String)json.getString("invoiceAmountWithTax"))) {
                ReportSettlementItem item = new ReportSettlementItem();
                item.setId(Long.valueOf(json.getLong("id") * 10L));
                item.setSettlementId(json.getLong("id"));
                item.setSettlementItemNo(json.getString("businessStatementNum") + "0");
                item.setItemName(json.getString("nameOfGoodsAndServices"));
                item.setQuantity(json.getString("quantity"));
                item.setQuantityUnit(json.getString("unit"));
                item.setPriceMethod(json.getString("priceMethod"));
                item.setTaxRate(new BigDecimal(json.getString("taxRate")));
                item.setUnitPrice(new BigDecimal(json.getString("unitPrice")));
                item.setTaxConvertCode(json.getString("taxConversionCode"));
                item.setGoodsTaxNo(json.getString("taxClassificationCode"));
                item.setCreateTime(json.getString("createTime"));
                settlementItems.add(item);
                continue;
            }
            String[] invoiceAmountWithoutTaxs = json.getString("taxClassificationCode").split(",");
            String[] invoiceTaxAmounts = json.getString("invoiceTaxAmount").split(",");
            String[] invoiceAmountWithTaxs = json.getString("invoiceAmountWithTax").split(",");
            for (int j = 0; j < invoiceAmountWithoutTaxs.length; ++j) {
                ReportSettlementItem item = new ReportSettlementItem();
                item.setId(Long.valueOf(json.getLong("id") * 10L));
                item.setSettlementId(json.getLong("id"));
                item.setSettlementItemNo(json.getString("businessStatementNum") + "0");
                item.setItemName(json.getString("nameOfGoodsAndServices"));
                item.setQuantity(json.getString("quantity"));
                item.setQuantityUnit(json.getString("unit"));
                item.setPriceMethod(json.getString("priceMethod"));
                item.setTaxRate(new BigDecimal(json.getString("taxRate")));
                item.setUnitPrice(new BigDecimal(json.getString("unitPrice")));
                item.setTaxConvertCode(json.getString("taxConversionCode"));
                item.setGoodsTaxNo(json.getString("taxClassificationCode"));
                item.setCreateTime(json.getString("createTime"));
                item.setAmountWithoutTax(new BigDecimal(invoiceAmountWithoutTaxs[j]));
                item.setTaxAmount(new BigDecimal(invoiceTaxAmounts[j]));
                item.setAmountWithTax(new BigDecimal(invoiceAmountWithTaxs[j]));
                settlementItems.add(item);
            }
        }
    }

    private void itemListAdd(List<String> itemList, JSONObject jsonObject) {
        for (int i = 0; i < jsonObject.getJSONArray("items").size(); ++i) {
            itemList.add(jsonObject.getJSONArray("items").getString(i));
        }
    }

    static /* synthetic */ int access$000(InvoiceSyncQuartz x0) {
        return x0.pageSize;
    }
}

