/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.quartz;

import com.reportfrom.wapp.entity.ReportPurchaseQuart;
import com.reportfrom.wapp.mapper.first.ReportPurchaseQuartMapper;
import com.reportfrom.wapp.request.PurcherTaxReq;
import com.reportfrom.wapp.taskthread.PurchaserQuartzFalseThread;
import com.reportfrom.wapp.taskthread.PurchaserQuartzTrueThread;
import com.reportfrom.wapp.util.DateUtils;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class PurchaserQuartz {
    private static final Logger log = LoggerFactory.getLogger(PurchaserQuartz.class);
    @Autowired
    private ReportPurchaseQuartMapper quartMapper;
    private ThreadPoolExecutor threadPoolForTure = new ThreadPoolExecutor(7, 10, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
    private ThreadPoolExecutor threadPoolForFalse = new ThreadPoolExecutor(7, 10, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));

    @Scheduled(cron="${quartz.purchaser.PurchaserQuartz.cron}")
    public void rzhTaxTrueQuartZ() {
        ReportPurchaseQuart reportPurchaseQuart = new ReportPurchaseQuart();
        reportPurchaseQuart.setRzhYesorNo("1");
        this.quartMapper.insert((Object)reportPurchaseQuart);
        Long taskID = reportPurchaseQuart.getId();
        log.info("taskid->{}", (Object)taskID);
        for (int i = 1; i <= 7; ++i) {
            log.info("\u5f00\u59cb\u5904\u7406\u8fdb\u9879\u7a0e\u91d1\uff08\u5df2\u8ba4\u8bc1\uff09\u660e\u7ec6  taskid->{}flowType->{}", (Object)taskID, (Object)i);
            PurcherTaxReq query = new PurcherTaxReq();
            query.setFlowTypeNo(i + "");
            query.setRzhBelongDate(DateUtils.format((Date)new Date(), (String)"yyyyMM"));
            this.threadPoolForTure.execute((Runnable)new PurchaserQuartzTrueThread(query, taskID));
        }
    }

    @Scheduled(cron="${quartz.purchaser.PurchaserQuartz.cron}")
    public void rzhTaxFalseQuartZ() {
        ReportPurchaseQuart reportPurchaseQuart = new ReportPurchaseQuart();
        reportPurchaseQuart.setRzhYesorNo("0");
        this.quartMapper.insert((Object)reportPurchaseQuart);
        Long taskID = reportPurchaseQuart.getId();
        log.info("taskid->{}", (Object)taskID);
        for (int i = 1; i <= 7; ++i) {
            if (i == 5) continue;
            log.info("\u5f00\u59cb\u5904\u7406\u8fdb\u9879\u7a0e\u91d1\uff08\u5f85\u8ba4\u8bc1\uff09\u660e\u7ec6  taskid->{}flowType->{}", (Object)taskID, (Object)i);
            PurcherTaxReq query = new PurcherTaxReq();
            query.setFlowTypeNo(i + "");
            this.threadPoolForFalse.execute((Runnable)new PurchaserQuartzFalseThread(query, taskID));
        }
    }
}

