/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service;

import com.alibaba.fastjson.JSON;
import com.reportfrom.wapp.entity.TDxMessagecontrol;
import com.reportfrom.wapp.mq.ActiveMqProducer;
import com.reportfrom.wapp.service.TDxMessagecontrolService;
import java.util.Collections;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CommonMessageService {
    private static final Logger log = LoggerFactory.getLogger(CommonMessageService.class);
    @Autowired
    private ActiveMqProducer activeMqProducer;
    @Autowired
    private TDxMessagecontrolService messageControlService;
    @Value(value="${activemq.queue-name.export-success-queue-gfone}")
    private String gfoneQueue;

    public void sendMessage(TDxMessagecontrol messagecontrolEntity) {
        messagecontrolEntity.setOperationStatus("0");
        messagecontrolEntity.setCreateTime(new Date());
        this.messageControlService.save((Object)messagecontrolEntity);
        log.info("\u5c0f\u94c3\u94db\u6d88\u606f\u8868\u3010tdxmessageControl\u3011\u8bb0\u5f55\u6210\u529f..{}", (Object)JSON.toJSONString((Object)messagecontrolEntity));
        this.activeMqProducer.send(this.gfoneQueue, JSON.toJSONString(Collections.singletonMap("message", messagecontrolEntity)));
        log.info("\u6d88\u606f\u63a8\u9001\u961f\u5217:" + this.gfoneQueue + "\uff0c\u6210\u529f..");
    }
}

