/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.taskthread;

import com.alibaba.fastjson.JSON;
import com.reportfrom.wapp.config.BeanContext;
import com.reportfrom.wapp.entity.ReportPurchaseQuartQuery;
import com.reportfrom.wapp.entityVO.PurcherTaxVO;
import com.reportfrom.wapp.mapper.first.ReportPurchaseQuartQueryMapper;
import com.reportfrom.wapp.mapper.first.ReportTaxCodeMapper;
import com.reportfrom.wapp.mapper.first.TDxRecordInvoiceMapper;
import com.reportfrom.wapp.request.PurcherTaxReq;
import com.reportfrom.wapp.util.MathUtils;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaserQuartzFalseThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PurchaserQuartzFalseThread.class);
    private PurcherTaxReq query;
    private Long taskID;
    private ReportPurchaseQuartQueryMapper purchaseQuartQueryMapper = (ReportPurchaseQuartQueryMapper)BeanContext.getBean(ReportPurchaseQuartQueryMapper.class);
    private TDxRecordInvoiceMapper tDxRecordInvoiceMapper = (TDxRecordInvoiceMapper)BeanContext.getBean(TDxRecordInvoiceMapper.class);
    private ReportTaxCodeMapper reportTaxCodeMapper = (ReportTaxCodeMapper)BeanContext.getBean(ReportTaxCodeMapper.class);

    public PurchaserQuartzFalseThread() {
    }

    public PurchaserQuartzFalseThread(PurcherTaxReq req, Long taskID) {
        this.query = req;
        this.taskID = taskID;
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        List purcherTaxVOS = this.purcherTaxQuery2(this.query);
        long endTime = System.currentTimeMillis();
        log.info("\u8fdb\u9879\u7a0e\u91d1\uff08\u5f85\u8ba4\u8bc1\uff09\u67e5\u8be2\u7ed3\u679c  taskid->{}\uff0cflowType->{}\uff0csize->{}\uff0c\u8017\u65f6->{}", new Object[]{this.taskID, this.query.getFlowTypeNo(), purcherTaxVOS.size(), endTime - startTime});
        for (PurcherTaxVO next : purcherTaxVOS) {
            ReportPurchaseQuartQuery purchaseQuartQuery = (ReportPurchaseQuartQuery)JSON.parseObject((String)JSON.toJSONString((Object)next), ReportPurchaseQuartQuery.class);
            purchaseQuartQuery.setTaskId(this.taskID);
            this.purchaseQuartQueryMapper.insert((Object)purchaseQuartQuery);
        }
    }

    public List<PurcherTaxVO> purcherTaxQuery2(PurcherTaxReq params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        HashMap<String, String> taxCodeMap = new HashMap<String, String>();
        List voList = this.tDxRecordInvoiceMapper.selectPurcherTaxByParam2(map);
        for (PurcherTaxVO purcherTaxVO : voList) {
            String taxRate = MathUtils.formatPointInt((String)purcherTaxVO.getTaxRate());
            String invoiceType = purcherTaxVO.getInvoiceType();
            String taxCode = (String)taxCodeMap.get(taxRate + invoiceType);
            if (StringUtils.isEmpty((String)taxCode)) {
                HashMap<String, String> getCodeMap = new HashMap<String, String>();
                getCodeMap.put("taxRate", taxRate);
                getCodeMap.put("invoiceType", invoiceType);
                taxCode = this.reportTaxCodeMapper.selectCodeByRateAndType(getCodeMap);
                taxCodeMap.put(taxRate + invoiceType, taxCode);
            }
            purcherTaxVO.setTaxCode(taxCode);
            if (StringUtils.isNotEmpty((String)params.getFlowTypeNo())) {
                purcherTaxVO.setFlowTypeNo(params.getFlowTypeNo());
            }
            if (purcherTaxVO == null) continue;
            purcherTaxVO.setTaxRate(MathUtils.formatPointDouble((String)taxRate));
        }
        return voList;
    }
}

