/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.util;

import io.micrometer.core.instrument.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtils {
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static String format(Date date) {
        return DateUtils.format((Date)date, (String)"yyyy-MM-dd");
    }

    public static String format(Date date, String pattern) {
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            return df.format(date);
        }
        return null;
    }

    public static Date stringToDate(String strDate, String pattern) {
        if (StringUtils.isBlank((String)strDate)) {
            return null;
        }
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)pattern);
        return fmt.parseLocalDateTime(strDate).toDate();
    }

    public static Map getFistAndLastByString(String strDate, String pattern, String returnType, String returnPattern) {
        HashMap<String, String> map = new HashMap<String, String>();
        Date yyyyMMdd = DateUtils.stringToDate((String)strDate, (String)pattern);
        DateTime dateTime = new DateTime((Object)yyyyMMdd);
        DateTime firstDate = dateTime.dayOfMonth().withMinimumValue();
        DateTime lastDate = dateTime.plusMonths(1).dayOfMonth().withMinimumValue();
        if ("String".equals(returnType)) {
            if (StringUtils.isEmpty((String)returnPattern)) {
                returnPattern = "yyyy-MM-dd HH:mm:ss";
            }
            map.put("firstDay", DateUtils.format((Date)firstDate.toDate(), (String)returnPattern));
            map.put("lastDay", DateUtils.format((Date)lastDate.toDate(), (String)returnPattern));
        } else {
            map.put("firstDay", (String)firstDate);
            map.put("lastDay", (String)lastDate);
        }
        return map;
    }

    public static Map getDayOfThreeMonth(String dateMonth) {
        HashMap<String, String> map = new HashMap<String, String>();
        Date yyyyMMdd = DateUtils.stringToDate((String)dateMonth, (String)"yyyy-MM");
        DateTime dateTime = new DateTime((Object)yyyyMMdd);
        DateTime firstDay = dateTime.plusMonths(-2).dayOfMonth().withMinimumValue();
        DateTime lastDate = dateTime.plusMonths(1).dayOfMonth().withMinimumValue();
        map.put("firstDay", DateUtils.format((Date)firstDay.toDate(), (String)"yyyy-MM-dd"));
        map.put("lastDay", DateUtils.format((Date)lastDate.toDate(), (String)"yyyy-MM-dd"));
        return map;
    }

    public static Map getDayOfOneMonth(String dateMonth) {
        HashMap<String, String> map = new HashMap<String, String>();
        Date yyyyMMdd = DateUtils.stringToDate((String)dateMonth, (String)"yyyy-MM");
        DateTime dateTime = new DateTime((Object)yyyyMMdd);
        DateTime firstDay = dateTime.plusMonths(0).dayOfMonth().withMinimumValue();
        DateTime lastDate = dateTime.plusMonths(1).dayOfMonth().withMinimumValue();
        map.put("firstDay", DateUtils.format((Date)firstDay.toDate(), (String)"yyyy-MM-dd"));
        map.put("lastDay", DateUtils.format((Date)lastDate.toDate(), (String)"yyyy-MM-dd"));
        return map;
    }

    public static String getLastMonth() {
        DateTime dateTime = new DateTime();
        DateTime lastDate = dateTime.plusMonths(-1).dayOfMonth().withMinimumValue();
        String format = DateUtils.format((Date)lastDate.toDate(), (String)"yyyyMM");
        return format;
    }

    public static Boolean checkMouthIsNow(String strDate, String pattern) {
        Date yyyyMMdd = DateUtils.stringToDate((String)strDate, (String)pattern);
        DateTime dateTime = new DateTime((Object)yyyyMMdd);
        DateTime now = DateTime.now();
        if (dateTime.getMonthOfYear() == now.getMonthOfYear() && dateTime.getYear() == now.getYear()) {
            return true;
        }
        return false;
    }

    public static int getMonthDifferent(String dateTime1str) {
        Date yyyyMMdd = DateUtils.stringToDate((String)dateTime1str, (String)"yyyyMM");
        DateTime dateTime = new DateTime((Object)yyyyMMdd);
        DateTime now = DateTime.now();
        return Months.monthsBetween((ReadableInstant)dateTime, (ReadableInstant)now).getMonths();
    }

    public static List<String> getTwoYearFromNew(Date date) {
        DateTime datetime = new DateTime((Object)date);
        DateTime endTime = datetime.minusMonths(0);
        DateTime startTime = datetime.minusYears(2).minusMonths(-1);
        String pattern = "yyyyMM";
        ArrayList<String> result = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        try {
            min.setTime(startTime.toDate());
            min.set(min.get(1), min.get(2), 1);
            max.setTime(endTime.toDate());
            max.set(max.get(1), max.get(2), 2);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5206\u89e3\u6708\u4efd\u51fa\u9519");
        }
        Calendar curr = min;
        while (curr.before(max)) {
            result.add(sdf.format(curr.getTime()));
            curr.add(2, 1);
        }
        min = null;
        max = null;
        curr = null;
        Collections.reverse(result);
        return result;
    }
}

