/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.entityEnum.AllType;
import com.reportfrom.wapp.entityVO.ReportChcJvInvoiceVO;
import com.reportfrom.wapp.mapper.second.ReportChcJvInvoiceMapper;
import com.reportfrom.wapp.request.ReportChcJvInvoiceRequest;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.ReportChcJvInvoiceService;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DS(value="second")
public class ReportChcJvInvoiceServiceImpl
implements ReportChcJvInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(ReportChcJvInvoiceServiceImpl.class);
    @Autowired
    private ReportChcJvInvoiceMapper reportChcJvInvoiceMapper;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;

    public PageUtils queryPage(ReportChcJvInvoiceRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        if (!StringUtils.isEmpty((String)params.getBatch())) {
            map.put("batch", params.getBatch());
            map.put("invoiceBatch", "%" + params.getBatch() + "]");
        }
        Integer count = this.reportChcJvInvoiceMapper.selectAllCountByParam(map);
        List reportChcJvInvoices = null;
        reportChcJvInvoices = null != count && count > 0 ? this.reportChcJvInvoiceMapper.selectMapsByParams(map) : new ArrayList(0);
        PageUtils rpage = new PageUtils();
        rpage.setList(reportChcJvInvoices);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void produceReportChcJvInvoice(ReportChcJvInvoiceRequest params, String token) {
        String fileName = "CHC&JV\u84dd\u5b57\u53d1\u7968\u6e05\u5355_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")) + ".xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        if (!StringUtils.isEmpty((String)params.getBatch())) {
            map.put("batch", params.getBatch());
            map.put("invoiceBatch", "%" + params.getBatch() + "]");
        }
        List rList = this.reportChcJvInvoiceMapper.selectMapsByParams(map);
        ReportChcJvInvoiceVO zj = new ReportChcJvInvoiceVO();
        this.dealSum(rList, zj);
        rList.add(zj);
        ArrayList<List> list = new ArrayList<List>();
        list.add(rList);
        List cjiList = this.reportChcJvInvoiceMapper.queryInvoice(map);
        cjiList.forEach(t -> {
            t.setStatus("0".equals(t.getStatus()) ? "\u662f" : "\u5426");
            t.setInvoiceType(AllType.ChcInvoiceEnum.getMsgByCode((String)t.getInvoiceType()));
            t.setRelevancyPeriod(t.getPaperDrewDate().substring(0, 6));
        });
        list.add(cjiList);
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel(list, (String)ExcelTypeConfig.REPORT_CHC_JV_INVOICE_QUERY, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("token", token);
        parmMap.put("condition", condition);
        parmMap.put("path", path);
        parmMap.put("fileName", fileName);
        String s = JSON.toJSONString(parmMap);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    private void dealSum(List<ReportChcJvInvoiceVO> list, ReportChcJvInvoiceVO zj) {
        if (zj != null && list != null && list.size() > 0) {
            zj.setJv("\u603b\u8ba1");
            BigDecimal invoiceAmountWithoutTax = new BigDecimal("0");
            BigDecimal invoiceTaxAmount = new BigDecimal("0");
            BigDecimal billAmountWithoutTax = new BigDecimal("0");
            BigDecimal billTaxAmount = new BigDecimal("0");
            BigDecimal diffInvoiceAmountWithoutTax = new BigDecimal("0");
            BigDecimal diffInvoiceTaxAmount = new BigDecimal("0");
            BigDecimal firstPayment = new BigDecimal("0");
            BigDecimal secondPayment = new BigDecimal("0");
            BigDecimal thirdPayment = new BigDecimal("0");
            BigDecimal totalAmount = new BigDecimal("0");
            BigDecimal checkAmount = new BigDecimal("0");
            for (ReportChcJvInvoiceVO info : list) {
                if (!StringUtils.isEmpty((String)info.getInvoiceAmountWithoutTax()) && StringUtils.isNumber((String)info.getInvoiceAmountWithoutTax())) {
                    invoiceAmountWithoutTax = invoiceAmountWithoutTax.add(new BigDecimal(info.getInvoiceAmountWithoutTax()));
                }
                if (!StringUtils.isEmpty((String)info.getInvoiceTaxAmount()) && StringUtils.isNumber((String)info.getInvoiceTaxAmount())) {
                    invoiceTaxAmount = invoiceTaxAmount.add(new BigDecimal(info.getInvoiceTaxAmount()));
                }
                if (!StringUtils.isEmpty((String)info.getBillAmountWithoutTax()) && StringUtils.isNumber((String)info.getBillAmountWithoutTax())) {
                    billAmountWithoutTax = billAmountWithoutTax.add(new BigDecimal(info.getBillAmountWithoutTax()));
                }
                if (!StringUtils.isEmpty((String)info.getBillTaxAmount()) && StringUtils.isNumber((String)info.getBillTaxAmount())) {
                    billTaxAmount = billTaxAmount.add(new BigDecimal(info.getBillTaxAmount()));
                }
                if (!StringUtils.isEmpty((String)info.getDiffInvoiceAmountWithoutTax()) && StringUtils.isNumber((String)info.getDiffInvoiceAmountWithoutTax())) {
                    diffInvoiceAmountWithoutTax = diffInvoiceAmountWithoutTax.add(new BigDecimal(info.getDiffInvoiceAmountWithoutTax()));
                }
                if (!StringUtils.isEmpty((String)info.getDiffInvoiceTaxAmount()) && StringUtils.isNumber((String)info.getDiffInvoiceTaxAmount())) {
                    diffInvoiceTaxAmount = diffInvoiceTaxAmount.add(new BigDecimal(info.getDiffInvoiceTaxAmount()));
                }
                if (!StringUtils.isEmpty((String)info.getFirstPayment()) && StringUtils.isNumber((String)info.getFirstPayment())) {
                    firstPayment = firstPayment.add(new BigDecimal(info.getFirstPayment()));
                }
                if (!StringUtils.isEmpty((String)info.getSecondPayment()) && StringUtils.isNumber((String)info.getSecondPayment())) {
                    secondPayment = secondPayment.add(new BigDecimal(info.getSecondPayment()));
                }
                if (!StringUtils.isEmpty((String)info.getThirdPayment()) && StringUtils.isNumber((String)info.getThirdPayment())) {
                    thirdPayment = thirdPayment.add(new BigDecimal(info.getThirdPayment()));
                }
                if (!StringUtils.isEmpty((String)info.getTotalAmount()) && StringUtils.isNumber((String)info.getTotalAmount())) {
                    totalAmount = totalAmount.add(new BigDecimal(info.getTotalAmount()));
                }
                if (StringUtils.isEmpty((String)info.getCheckAmount()) || !StringUtils.isNumber((String)info.getCheckAmount())) continue;
                checkAmount = checkAmount.add(new BigDecimal(info.getCheckAmount()));
            }
            zj.setInvoiceAmountWithoutTax(invoiceAmountWithoutTax.toString());
            zj.setInvoiceTaxAmount(invoiceTaxAmount.toString());
            zj.setBillAmountWithoutTax(billAmountWithoutTax.toString());
            zj.setBillTaxAmount(billTaxAmount.toString());
            zj.setDiffInvoiceAmountWithoutTax(diffInvoiceAmountWithoutTax.toString());
            zj.setDiffInvoiceTaxAmount(diffInvoiceTaxAmount.toString());
            zj.setFirstPayment(firstPayment.toString());
            zj.setSecondPayment(secondPayment.toString());
            zj.setThirdPayment(thirdPayment.toString());
            zj.setTotalAmount(totalAmount.toString());
            zj.setCheckAmount(checkAmount.toString());
        }
    }
}

