/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.entity.TDxRecordInvoice;
import com.reportfrom.wapp.entityVO.InvoiceDetailVO;
import com.reportfrom.wapp.entityVO.RecordInvoiceVO;
import com.reportfrom.wapp.mapper.first.ReportPurchaseQuartQueryMapper;
import com.reportfrom.wapp.mapper.first.ReportTaxCodeMapper;
import com.reportfrom.wapp.mapper.first.TDxRecordInvoiceMapper;
import com.reportfrom.wapp.request.PurcherTaxReq;
import com.reportfrom.wapp.request.RecordInvoiceDetailsReq;
import com.reportfrom.wapp.request.RecordInvoiceReq;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.TDxRecordInvoiceService;
import com.reportfrom.wapp.util.DateUtils;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import io.micrometer.core.instrument.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TDxRecordInvoiceServiceImpl
extends ServiceImpl<TDxRecordInvoiceMapper, TDxRecordInvoice>
implements TDxRecordInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(TDxRecordInvoiceServiceImpl.class);
    @Autowired
    private TDxRecordInvoiceMapper tDxRecordInvoiceMapper;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;
    @Autowired
    private ReportTaxCodeMapper reportTaxCodeMapper;
    @Autowired
    private ReportPurchaseQuartQueryMapper purchaseQuartQueryMapper;

    public PageUtils queryPageRecordInvoice(RecordInvoiceReq params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        String storeStart = (String)map.get("storeStart");
        if (!StringUtils.isEmpty((String)storeStart)) {
            Map fistAndLastByString = DateUtils.getFistAndLastByString((String)storeStart, (String)"yyyyMM", (String)"String", (String)"yyyy-MM-dd");
            map.putAll(fistAndLastByString);
        }
        List voList = this.tDxRecordInvoiceMapper.selectRecordInvoiceByParam(map);
        for (RecordInvoiceVO vo : voList) {
            String bussinessType = vo.getBussinessType();
            String taxCodeShow = this.tDxRecordInvoiceMapper.getFeiShangTaxCode(bussinessType + "_" + this.formatPointInt(vo.getTaxRate()));
            if (StringUtils.isEmpty((String)taxCodeShow)) {
                log.info("\u5339\u914d\u5230\u975e\u5546\u4f20\u7968\u7a0e\u7801:{}", (Object)taxCodeShow);
            }
            vo.setInvoiceNoAndCode(vo.getInvoiceCode() + vo.getInvoiceNo());
            vo.setTaxCode(taxCodeShow);
            vo.setTaxRate(this.formatPointDouble(vo.getTaxRate()));
            HashMap businessInfo = this.tDxRecordInvoiceMapper.getBusinessInfo(vo.getBussinessType());
            if (businessInfo != null) {
                vo.setClassA(businessInfo.get("class_a").toString());
                vo.setFunctionGroup(businessInfo.get("function_group").toString());
            }
            if (vo.getAuthStatus() != null) continue;
            vo.setAuthStatus("0");
        }
        Integer count = this.tDxRecordInvoiceMapper.selectRecordInvoiceCountByParam(map);
        PageUtils rpage = new PageUtils();
        rpage.setList(voList);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void recordInvoiceExport(RecordInvoiceReq params, String token) {
        String fileName = "\u975e\u5546\u4f20\u7968\u6e05\u5355.xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        String storeStart = (String)map.get("storeStart");
        if (!StringUtils.isEmpty((String)storeStart)) {
            Map fistAndLastByString = DateUtils.getFistAndLastByString((String)storeStart, (String)"yyyyMM", (String)"String", (String)"yyyy-MM-dd");
            map.putAll(fistAndLastByString);
        }
        log.info("\u67e5\u8be2\u5bfc\u51fa\u6570\u636e>>>>>");
        List voList = this.tDxRecordInvoiceMapper.selectRecordInvoiceByParam(map);
        for (RecordInvoiceVO vo : voList) {
            String bussinessType = vo.getBussinessType();
            String taxCodeShow = this.tDxRecordInvoiceMapper.getFeiShangTaxCode(bussinessType + "_" + this.formatPointInt(vo.getTaxRate()));
            if (StringUtils.isEmpty((String)taxCodeShow)) {
                log.info("\u5339\u914d\u5230\u975e\u5546\u4f20\u7968\u7a0e\u7801:{}", (Object)taxCodeShow);
            }
            vo.setInvoiceNoAndCode(vo.getInvoiceCode() + vo.getInvoiceNo());
            vo.setTaxCode(taxCodeShow);
            vo.setTaxRate(this.formatPointDouble(vo.getTaxRate()));
            HashMap businessInfo = this.tDxRecordInvoiceMapper.getBusinessInfo(vo.getBussinessType());
            if (businessInfo != null) {
                vo.setClassA(businessInfo.get("class_a").toString());
                vo.setFunctionGroup(businessInfo.get("function_group").toString());
            }
            if (vo.getAuthStatus() != null) continue;
            vo.setAuthStatus("0");
        }
        log.info("\u5bfc\u51fa\u6570\u636e\u5171{}\u6761>>>>>", (Object)voList.size());
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)voList, (String)ExcelTypeConfig.FS_INVOICE, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        log.info("\u3010{}\u3011\u6587\u4ef6\u5bfc\u51fa\u8bb0\u5f55\u5f00\u59cb\u540c\u6b65\u5c0f\u94c3\u94db>>>>>", (Object)fileName);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public PageUtils queryPageRecordInvoiceDeatils(RecordInvoiceDetailsReq params) {
        List<String> strings;
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        if (StringUtils.isNotEmpty((String)params.getCreateTime())) {
            strings = Arrays.asList(params.getCreateTime().split(","));
            map.put("startTime", strings.get(0));
            map.put("endTime", strings.get(1));
        }
        if (StringUtils.isNotEmpty((String)params.getConfirmDate())) {
            strings = Arrays.asList(params.getConfirmDate().split(","));
            map.put("rzStartTime", strings.get(0));
            map.put("rzEndTime", strings.get(1));
        }
        List aVoList = this.tDxRecordInvoiceMapper.selectDetailsByParam(map);
        Set uuidSet = aVoList.stream().map(InvoiceDetailVO::getUuid).collect(Collectors.toSet());
        uuidSet.removeIf(o -> StringUtils.isEmpty((String)o));
        List bVoList = this.tDxRecordInvoiceMapper.selectDetailsByUuidSet(uuidSet);
        List voList = this.getCombineTwoSet(aVoList, bVoList);
        Integer count = voList.size();
        PageUtils rpage = new PageUtils();
        rpage.setList(voList);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    private List<InvoiceDetailVO> getCombineTwoSet(List<InvoiceDetailVO> demo1, List<InvoiceDetailVO> demo2) {
        ArrayList<InvoiceDetailVO> returnList = new ArrayList<InvoiceDetailVO>();
        HashMap<String, InvoiceDetailVO> map = new HashMap<String, InvoiceDetailVO>();
        for (InvoiceDetailVO sameOr : demo2) {
            map.put(sameOr.getUuid(), sameOr);
        }
        for (InvoiceDetailVO sameOr : demo1) {
            String uuid = sameOr.getUuid();
            InvoiceDetailVO sameOr1 = (InvoiceDetailVO)map.get(uuid);
            if (sameOr1 == null) {
                returnList.add(sameOr);
                continue;
            }
            if (sameOr.getAuthStatus() == null) {
                sameOr.setAuthStatus("0");
            }
            if (!StringUtils.isEmpty((String)sameOr.getBussinessType()) && ("4".equals(sameOr.getBussinessType()) || "2".equals(sameOr.getBussinessType()))) {
                sameOr.setPurchaserNo(sameOr.getStoreNo());
            }
            sameOr.setGoodsName(sameOr1.getGoodsName());
            sameOr.setUnit(sameOr1.getUnit());
            sameOr.setNum(sameOr1.getNum());
            sameOr.setTaxRate(this.formatPointDouble(sameOr1.getTaxRate()));
            sameOr.setUnitPrice(sameOr1.getUnitPrice());
            sameOr.setDetailAmount(sameOr1.getDetailAmount());
            sameOr.setTaxAmount(sameOr1.getTaxAmount());
            map.remove(uuid);
            returnList.add(sameOr);
        }
        return returnList;
    }

    public void recordInvoiceDeatilsExport(RecordInvoiceDetailsReq params, String token) {
        List<String> strings;
        String fileName = "\u975e\u5546\u53d1\u7968\u660e\u7ec6.xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        if (StringUtils.isNotEmpty((String)params.getCreateTime())) {
            strings = Arrays.asList(params.getCreateTime().split(","));
            map.put("startTime", strings.get(0));
            map.put("endTime", strings.get(1));
        }
        if (StringUtils.isNotEmpty((String)params.getConfirmDate())) {
            strings = Arrays.asList(params.getConfirmDate().split(","));
            map.put("rzStartTime", strings.get(0));
            map.put("rzEndTime", strings.get(1));
        }
        List aVoList = this.tDxRecordInvoiceMapper.selectDetailsByParam(map);
        Set uuidSet = aVoList.stream().map(InvoiceDetailVO::getUuid).collect(Collectors.toSet());
        uuidSet.removeIf(o -> StringUtils.isEmpty((String)o));
        List bVoList = this.tDxRecordInvoiceMapper.selectDetailsByUuidSet(uuidSet);
        List voList = this.getCombineTwoSet(aVoList, bVoList);
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)voList, (String)ExcelTypeConfig.FS_INVOICE_DETAILS, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public PageUtils purcherTaxQuery1(PurcherTaxReq params) {
        List voList = this.purchaseQuartQueryMapper.selectNewPurcherTax(params);
        int count = voList.size();
        PageUtils rpage = new PageUtils();
        rpage.setList(voList);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count);
        return rpage;
    }

    public void purcherTaxExport1(PurcherTaxReq params, String token) {
        String fileName = "\u8fdb\u9879\u7a0e\u91d1\u6c47\u603b\uff08\u5df2\u8ba4\u8bc1\uff09.xlsx";
        List voList = this.purchaseQuartQueryMapper.selectNewPurcherTax(params);
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)voList, (String)ExcelTypeConfig.JX_PURCHER_TAX, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public PageUtils purcherTaxQuery2(PurcherTaxReq params) {
        List voList = this.purchaseQuartQueryMapper.selectNewPurcherTax(params);
        int count = voList.size();
        PageUtils rpage = new PageUtils();
        rpage.setList(voList);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count);
        return rpage;
    }

    public void purcherTaxExport2(PurcherTaxReq params, String token) {
        String fileName = "\u8fdb\u9879\u7a0e\u91d1\u6c47\u603b\uff08\u672a\u8ba4\u8bc1\uff09.xlsx";
        List voList = this.purchaseQuartQueryMapper.selectNewPurcherTax(params);
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)voList, (String)ExcelTypeConfig.JX_PURCHER_TAX, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public String formatPointDouble(String stringDecimal) {
        if (StringUtils.isNotEmpty((String)stringDecimal)) {
            BigDecimal aa = new BigDecimal(stringDecimal);
            if (1 == aa.compareTo(BigDecimal.ONE)) {
                aa = aa.divide(BigDecimal.valueOf(100L)).setScale(2, 4);
            }
            String bigDecimal = aa.setScale(2, 4).toString();
            return bigDecimal;
        }
        return null;
    }

    public String formatPointInt(String stringDecimal) {
        if (StringUtils.isNotEmpty((String)stringDecimal)) {
            BigDecimal aa = new BigDecimal(stringDecimal);
            if (-1 == aa.compareTo(BigDecimal.ONE)) {
                aa = aa.multiply(BigDecimal.valueOf(100L));
            }
            String bigDecimal = aa.setScale(0).toString();
            return bigDecimal;
        }
        return null;
    }
}

