/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.quartz;

import com.alibaba.fastjson.JSON;
import com.reportfrom.wapp.entity.AggrementRedJlEntity;
import com.reportfrom.wapp.entity.ReportAggrementEpdStatistic;
import com.reportfrom.wapp.quartz.ReportAggrementEpdStatisticQuartz;
import com.reportfrom.wapp.service.ReportAggrementEpdStatisticService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ReportAggrementEpdStatisticQuartz {
    private static final Logger log = LoggerFactory.getLogger(ReportAggrementEpdStatisticQuartz.class);
    @Autowired
    private ReportAggrementEpdStatisticService reportAggrementEpdStatisticService;

    @Scheduled(cron="${quartz.AggrementStatisticQuartz.cron}")
    public void updateTask() {
        String yesterday = LocalDate.now().minusDays(1L).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        List postDateList = this.reportAggrementEpdStatisticService.getCalcPostDate(yesterday);
        if (postDateList == null || postDateList.size() == 0) {
            log.info("{} \u6ca1\u6709\u7ea2\u5b57\u4fe1\u606f\u8868\u7684\u8fc7\u8d26\u65e5\u671f", (Object)yesterday);
            return;
        }
        for (String lastMonth : postDateList) {
            log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 : {} \u8ba1\u7b97\u5f00\u59cb", (Object)lastMonth);
            this.updateAggrementEpdStatistic(lastMonth + "%");
            log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 : {} \u8ba1\u7b97\u7ed3\u675f", (Object)lastMonth);
        }
    }

    public void updateAggrementEpdStatistic(String lastMonth) {
        Long startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u91cd\u7f6e\u8ba1\u7b97\u4e3a\u7a7a \u5f00\u59cb");
        int updateLen = this.reportAggrementEpdStatisticService.updateNull(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u91cd\u7f6e\u8ba1\u7b97\u4e3a\u7a7a \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        this.updateZm(lastMonth);
        this.updateTotal(lastMonth);
    }

    public void updateCxCk(List<String> reportIds) {
        if (reportIds != null && reportIds.size() > 0) {
            for (String reportId : reportIds) {
                List tList;
                List redList = this.reportAggrementEpdStatisticService.getRedLog(reportId);
                if (redList == null || redList.size() <= 0 || (tList = ReportAggrementEpdStatisticQuartz.calcCxCk((List)redList)) == null || tList.size() <= 0) continue;
                AggrementRedJlEntity arJlEntity = (AggrementRedJlEntity)redList.get(0);
                ReportAggrementEpdStatistic r = new ReportAggrementEpdStatistic();
                r.setId(arJlEntity.getReportId());
                BigDecimal standardCurrencyAmount = arJlEntity.getStandardCurrencyAmount();
                if (standardCurrencyAmount == null) {
                    standardCurrencyAmount = new BigDecimal(0);
                }
                for (int i = 0; i < tList.size(); ++i) {
                    CxCkEntity info = (CxCkEntity)tList.get(i);
                    if (i == 0) {
                        r.setReverseTaxAmount(info.getCxTaxAmount());
                        r.setReverseDate(info.getMaxCxDate());
                        if (info.getCkTaxAmount() == null) continue;
                        r.setReTaxAmount(info.getCkTaxAmount());
                        r.setRePaperDate(info.getMaxCkDate());
                        r.setTotalAdjustmentTaxAmount(standardCurrencyAmount.abs().subtract(info.getCkTaxAmount()).setScale(2, 0));
                        continue;
                    }
                    if (i == 1) {
                        r.setReverseTaxAmountSecond(info.getCxTaxAmount());
                        r.setReverseDateSecond(info.getMaxCxDate());
                        if (info.getCkTaxAmount() == null) continue;
                        r.setReTaxAmountSecond(info.getCkTaxAmount());
                        r.setRePaperDateSecond(info.getMaxCkDate());
                        r.setTotalAdjustmentTaxAmountSecond(standardCurrencyAmount.abs().subtract(info.getCkTaxAmount()).setScale(2, 0));
                        continue;
                    }
                    if (i != 2) continue;
                    r.setReverseTaxAmountThird(info.getCxTaxAmount());
                    r.setReverseDateThird(info.getMaxCxDate());
                    if (info.getCkTaxAmount() == null) continue;
                    r.setReTaxAmountThird(info.getCkTaxAmount());
                    r.setRePaperDateThird(info.getMaxCkDate());
                    r.setTotalAdjustmentTaxAmountThird(standardCurrencyAmount.abs().subtract(info.getCkTaxAmount()).setScale(2, 0));
                }
                this.reportAggrementEpdStatisticService.updateCxCk(r);
            }
        }
    }

    public static void main(String[] args) {
        ArrayList<AggrementRedJlEntity> redList = new ArrayList<AggrementRedJlEntity>();
        redList.add(new AggrementRedJlEntity(Long.valueOf(80231L), "20220901", "20220902", new BigDecimal(3), "0", new BigDecimal(3)));
        redList.add(new AggrementRedJlEntity(Long.valueOf(80231L), "20220902", "20220928", new BigDecimal(3), "0", new BigDecimal(3)));
        redList.add(new AggrementRedJlEntity(Long.valueOf(80231L), "20221001", "20221001", new BigDecimal(2), "0", new BigDecimal(3)));
        redList.add(new AggrementRedJlEntity(Long.valueOf(80231L), "20221002", null, new BigDecimal(1), "1", new BigDecimal(3)));
        List list = ReportAggrementEpdStatisticQuartz.calcCxCk(redList);
        System.out.println(JSON.toJSONString((Object)list));
    }

    public static List<CxCkEntity> calcCxCk(List<AggrementRedJlEntity> redList) {
        CxCkEntity t = null;
        ArrayList<CxCkEntity> tList = new ArrayList<CxCkEntity>();
        for (AggrementRedJlEntity red : redList) {
            if (t != null && Integer.parseInt(red.getInvoiceDate()) >= Integer.parseInt(t.getMaxCxDate())) {
                if (t.getCkTaxAmount() == null) {
                    t.setCkTaxAmount(new BigDecimal(0));
                }
                t.setCkTaxAmount(t.getCkTaxAmount().add(red.getTaxAmount()));
                t.setMaxCkDate(red.getInvoiceDate());
            }
            if (!"0".equals(red.getIsSq())) continue;
            if (t == null || !t.getMonth().equals(red.getCancelDate().substring(0, 6))) {
                t = new CxCkEntity();
                t.setMonth(red.getCancelDate().substring(0, 6));
                tList.add(t);
            }
            if (t.getCxTaxAmount() == null) {
                t.setCxTaxAmount(new BigDecimal(0));
            }
            t.setCxTaxAmount(t.getCxTaxAmount().add(red.getTaxAmount()));
            t.setMaxCxDate(red.getCancelDate());
        }
        return tList;
    }

    public void updateZm(String lastMonth) {
        Long startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u4f9b\u5e94\u5546\u540d\u79f0\uff0c\u662f\u5426\u7ea2\u7968\u9879\u76ee\u7ec4 \u5f00\u59cb");
        int updateLen = this.reportAggrementEpdStatisticService.updateBillDeduct(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u4f9b\u5e94\u5546\u540d\u79f0\uff0c\u662f\u5426\u7ea2\u7968\u9879\u76ee\u7ec4 \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u7ea2\u7968-AR \uff0c \u7a0e\u5dee\u8c03\u6574 \uff0c \u5f00\u5177\u65e5\u671f \u5f00\u59cb");
        updateLen = this.reportAggrementEpdStatisticService.updateAggrementRedTaxAmount(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u7ea2\u7968-AR \uff0c \u7a0e\u5dee\u8c03\u6574 \uff0c \u5f00\u5177\u65e5\u671f \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u5df2\u7ed3\u6b3e\u672a\u5f00\u7968\u7a0e\u91d1 \u5f00\u59cb");
        updateLen = this.reportAggrementEpdStatisticService.updateUnInvoiceAmount(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u5df2\u7ed3\u6b3e\u672a\u5f00\u7968\u7a0e\u91d1 \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u5df2\u84dd\u51b2\u7a0e\u91d1 \u5f00\u59cb");
        updateLen = this.reportAggrementEpdStatisticService.updateBlueOffsetAmount(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u5df2\u84dd\u51b2\u7a0e\u91d1 \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        List reportIds = this.reportAggrementEpdStatisticService.getReportIds(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u64a4\u9500\u3001\u91cd\u5f00 \u5f00\u59cb");
        this.updateCxCk(reportIds);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u64a4\u9500\u3001\u91cd\u5f00 \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)(reportIds == null ? 0 : reportIds.size()), (Object)(System.currentTimeMillis() - startTime));
    }

    public void updateTotal(String lastMonth) {
        Long startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u4f59\u989d \u5f00\u59cb");
        int updateLen = this.reportAggrementEpdStatisticService.updateBalance(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u4f59\u989d \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u5dee\u5f02 \u5f00\u59cb");
        updateLen = this.reportAggrementEpdStatisticService.updateDifferenceAmount(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u5dee\u5f02 \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
    }
}

