/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.NasConfig;
import com.reportfrom.wapp.entity.ReportClaimRedStatistic;
import com.reportfrom.wapp.entity.ReportClaimStatistic;
import com.reportfrom.wapp.mapper.first.ReportClaimRedStatisticMapper;
import com.reportfrom.wapp.mapper.first.ReportClaimStatisticMapper;
import com.reportfrom.wapp.mapper.first.TXfBillDeductMapper;
import com.reportfrom.wapp.request.ReportClaimStatisticDetailsReq;
import com.reportfrom.wapp.request.ReportClaimStatisticReq;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.ReportClaimStatisticService;
import com.reportfrom.wapp.service.impl.ReportClaimStatisticServiceImpl;
import com.reportfrom.wapp.util.DateUtils;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.MathUtils;
import com.reportfrom.wapp.util.PageUtils;
import com.reportfrom.wapp.util.excelUtil.ExcelReturnInterface;
import com.reportfrom.wapp.util.excelUtil.XssfSheetReaderUtils;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional
public class ReportClaimStatisticServiceImpl
extends ServiceImpl<ReportClaimStatisticMapper, ReportClaimStatistic>
implements ReportClaimStatisticService {
    private static final Logger log = LoggerFactory.getLogger(ReportClaimStatisticServiceImpl.class);
    @Autowired
    private ReportClaimStatisticMapper reportClaimStatisticMapper;
    @Autowired
    private ReportClaimRedStatisticMapper reportClaimRedStatisticMapper;
    @Autowired
    private TXfBillDeductMapper tXfBillDeductMapper;
    @Autowired
    private NasConfig nasConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;
    private ThreadPoolExecutor taskPool = new ThreadPoolExecutor(5, 10, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));

    public void uploadMain(InputStream inputStream, String fileName, HttpServletResponse response, String token) {
        1 excelReturnInterface = new /* Unavailable Anonymous Inner Class!! */;
        try {
            XssfSheetReaderUtils.startReadExcel((InputStream)inputStream, (ExcelReturnInterface)excelReturnInterface, (Integer)1000, (Integer)1);
            this.startSelectZeroTaxRateForInsert();
            String condition = JSON.toJSONString((Object)"params");
            String path = "upload";
            this.baseReportExportService.uploadExcel(token, condition, path, fileName);
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6excel\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
    }

    public void uploadChange(InputStream inputStream, String fileName, HttpServletResponse response, String token) {
        2 excelReturnInterface = new /* Unavailable Anonymous Inner Class!! */;
        try {
            XssfSheetReaderUtils.startReadExcel((InputStream)inputStream, (ExcelReturnInterface)excelReturnInterface, (Integer)1000, (Integer)1);
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6excel\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        String condition = JSON.toJSONString((Object)"params");
        String path = "upload";
        this.baseReportExportService.uploadExcel(token, condition, path, fileName);
    }

    public void startSelectZeroTaxRateForInsert() {
        log.info("\u5f00\u59cb\u67e5\u8be2\u4e0a\u67080\u7a0e\u7387\u5df2\u5339\u914d\u7ea2\u5b57\u5355\u636e\u7684\u7d22\u8d54\u5355...");
        String lastMonth = DateUtils.getLastMonth();
        Map queryDeductMap = DateUtils.getMounthFistAndLastByString((String)lastMonth, (String)"yyyyMM", (String)"String", (String)"yyyy-MM-dd");
        List zeroDemo = this.tXfBillDeductMapper.selecetZeroSumByParams(queryDeductMap);
        for (ReportClaimStatistic report : zeroDemo) {
            report.setSubject("2226020");
            String supplierNo = MathUtils.removeZero((String)report.getSupplierNo());
            String invoiceNo = MathUtils.removeZero((String)report.getBlueInvoiceNo());
            report.setSupplierDInvoice(supplierNo + invoiceNo);
            String yyyyMM = DateUtils.format((Date)report.getDeductDate(), (String)"yyyyMM");
            log.info("\u84dd\u7968\u53f7\uff1a{},dedectDate:{},\u5e74\u6708{}", new Object[]{report.getBlueInvoiceNo(), report.getDeductDate(), yyyyMM});
            report.setDateMonth(yyyyMM);
            QueryWrapper wrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"date_month", (Object)yyyyMM)).eq((Object)"blue_invoice_no", (Object)invoiceNo)).eq((Object)"supplier_no", (Object)supplierNo);
            ReportClaimStatistic insertOrUpdateEn = (ReportClaimStatistic)this.reportClaimStatisticMapper.selectOne((Wrapper)wrapper);
            if (insertOrUpdateEn == null) {
                this.reportClaimStatisticMapper.insert((Object)report);
                continue;
            }
            report.setId(insertOrUpdateEn.getId());
            this.reportClaimStatisticMapper.updateById((Object)report);
        }
    }

    public PageUtils queryList(ReportClaimStatisticReq params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        if (!StringUtils.isEmpty((String)params.getDateMonth())) {
            List<String> dataMonnnthList = Arrays.asList(params.getDateMonth().split(","));
            map.put("startDateMonth", dataMonnnthList.get(0));
            map.put("endDateMonth", dataMonnnthList.get(1));
        }
        List list = this.reportClaimStatisticMapper.selectListByParams(map);
        Integer count = this.reportClaimStatisticMapper.selectCountByParams(map);
        for (ReportClaimStatistic statistic : list) {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("blueInvoiceNo", statistic.getBlueInvoiceNo());
            queryMap.put("supplierNo", statistic.getSupplierNo());
            queryMap.put("dateMonth", statistic.getDateMonth());
            List redStatistic = this.reportClaimRedStatisticMapper.selectDetailsList(queryMap);
            statistic.setRedStatisticsList(redStatistic);
        }
        PageUtils rpage = new PageUtils();
        rpage.setList(list);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public PageUtils queryDetailsList(ReportClaimStatisticDetailsReq params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        List RedStatistics = this.reportClaimRedStatisticMapper.selectDetailsList(map);
        Integer count = 0;
        if (!CollectionUtils.isEmpty((Collection)RedStatistics)) {
            count = RedStatistics.size();
        }
        PageUtils rpage = new PageUtils();
        rpage.setList(RedStatistics);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void export(ReportClaimStatisticReq params, String token) {
        String downLoadfileName = "\u7d22\u8d54\u7a0e\u52a1\u62a5\u8868";
        String uploadfileName = "ReportClaimStatistic-" + DateUtils.getStringDateShort();
        List<String> dataMonnnthList = Arrays.asList(params.getDateMonth().split(","));
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("startDateMonth", dataMonnnthList.get(0));
        map.put("endDateMonth", dataMonnnthList.get(1));
        List voList = this.reportClaimStatisticMapper.selectListByParams(map);
        String path = this.nasConfig.getUrl();
        for (ReportClaimStatistic statistic : voList) {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("blueInvoiceNo", statistic.getBlueInvoiceNo());
            queryMap.put("supplierNo", statistic.getSupplierNo());
            queryMap.put("dateMonth", statistic.getDateMonth());
            List redStatistic = this.reportClaimRedStatisticMapper.selectDetailsList(queryMap);
            statistic.setRedStatisticsList(redStatistic);
        }
        ExcelUtils.createExcel((List)voList, (String)ExcelTypeConfig.CLAIM_TAX_STATEMENT, (String)uploadfileName, (String)path);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, downLoadfileName, uploadfileName);
    }

    private List<ReportClaimStatistic> excelToList(List<List<String>> rowList) {
        ArrayList<ReportClaimStatistic> list = new ArrayList<ReportClaimStatistic>();
        try {
            for (int i = 0; i < rowList.size(); ++i) {
                List<String> cellList = rowList.get(i);
                String cell = cellList.get(26);
                if (StringUtils.isEmpty((String)cell)) continue;
                ReportClaimStatistic reportClaimStatistic = new ReportClaimStatistic();
                reportClaimStatistic.setCompanyCode(cellList.get(0));
                reportClaimStatistic.setSubject(cellList.get(1));
                reportClaimStatistic.setAllocation(cellList.get(2));
                reportClaimStatistic.setCertificateNo(cellList.get(3));
                reportClaimStatistic.setBusinessScope(cellList.get(4));
                reportClaimStatistic.setCertificateType(cellList.get(5));
                reportClaimStatistic.setPostingDate(cellList.get(6));
                reportClaimStatistic.setCertificateDate(cellList.get(7));
                reportClaimStatistic.setAccountingCode(cellList.get(8));
                if (!StringUtils.isEmpty((String)cellList.get(9))) {
                    BigDecimal bigDecimal = new BigDecimal(cellList.get(9));
                    reportClaimStatistic.setStandardCurrencyAmount(bigDecimal);
                }
                reportClaimStatistic.setStandardCurrency(cellList.get(10));
                reportClaimStatistic.setTaxCode(cellList.get(11));
                reportClaimStatistic.setClearCertificate(cellList.get(12));
                reportClaimStatistic.setProfitCenter(cellList.get(13));
                reportClaimStatistic.setDuan(cellList.get(14));
                reportClaimStatistic.setTextContent(cellList.get(15));
                reportClaimStatistic.setReverseSubjectType(cellList.get(16));
                reportClaimStatistic.setReverseSubjectAccount(cellList.get(17));
                reportClaimStatistic.setPartner(cellList.get(18));
                reportClaimStatistic.setCertificateTitle(cellList.get(19));
                reportClaimStatistic.setReferenceCodeBt1(cellList.get(20));
                reportClaimStatistic.setReferenceCodeTt1(cellList.get(21));
                reportClaimStatistic.setReferenceCode1(cellList.get(22));
                reportClaimStatistic.setReferenceCode2(cellList.get(23));
                reportClaimStatistic.setReference(cellList.get(24));
                reportClaimStatistic.setInvoiceReference(cellList.get(25));
                reportClaimStatistic.setDateMonth(cellList.get(26));
                String invoiceNo = "";
                String supNo = "";
                invoiceNo = cellList.get(28);
                reportClaimStatistic.setBlueInvoiceNo(invoiceNo);
                if (cellList.get(29).length() < 6) {
                    DecimalFormat g1 = new DecimalFormat("000000");
                    supNo = g1.format(Integer.valueOf(cellList.get(29)));
                } else {
                    supNo = cellList.get(29);
                }
                reportClaimStatistic.setSupplierNo(supNo);
                reportClaimStatistic.setSupplierName(cellList.get(30));
                reportClaimStatistic.setSupplierDInvoice(supNo + invoiceNo);
                list.add(reportClaimStatistic);
            }
        }
        catch (Exception e) {
            log.error("parse excel file error :", (Throwable)e);
        }
        return list;
    }

    private List<ReportClaimStatistic> excelChangeToList(List<List<String>> rowList) {
        ArrayList<ReportClaimStatistic> list = new ArrayList<ReportClaimStatistic>();
        try {
            for (int i = 0; i < rowList.size(); ++i) {
                List<String> cellList = rowList.get(i);
                String cell = cellList.get(0);
                if (StringUtils.isEmpty((String)cell)) continue;
                ReportClaimStatistic reportClaimStatistic = new ReportClaimStatistic();
                reportClaimStatistic.setDateMonth(cellList.get(0));
                String invoiceNo = "";
                String supNo = "";
                reportClaimStatistic.setBlueInvoiceNo(cellList.get(1));
                if (cellList.get(2).length() < 6) {
                    DecimalFormat g1 = new DecimalFormat("000000");
                    supNo = g1.format(Integer.valueOf(cellList.get(2)));
                    reportClaimStatistic.setSupplierNo(supNo);
                } else {
                    reportClaimStatistic.setSupplierNo(cellList.get(2));
                }
                if (!StringUtils.isEmpty((String)cellList.get(3))) {
                    reportClaimStatistic.setCheckBalanceAmount(new BigDecimal(cellList.get(3)).setScale(2, 4));
                }
                if (!StringUtils.isEmpty((String)cellList.get(4))) {
                    reportClaimStatistic.setApplyAmount(new BigDecimal(cellList.get(4)).setScale(2, 4));
                }
                reportClaimStatistic.setDealTime(cellList.get(5));
                list.add(reportClaimStatistic);
            }
        }
        catch (Exception e) {
            log.error("parse excel file error :", (Throwable)e);
        }
        return list;
    }

    private Map<String, BigDecimal> getAllDetailsAmount(ReportClaimStatistic domain) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"date_month", (Object)domain.getDateMonth())).eq((Object)"blue_invoice_no", (Object)domain.getBlueInvoiceNo())).eq((Object)"supplier_no", (Object)domain.getSupplierNo());
        List redStatisticList = this.reportClaimRedStatisticMapper.selectList((Wrapper)wrapper);
        BigDecimal countAmountWithTax = new BigDecimal("0");
        BigDecimal countTaxAmount = new BigDecimal("0");
        for (ReportClaimRedStatistic redStatistic : redStatisticList) {
            if (redStatistic.getApplyRedNotificationAmountWithTax() != null) {
                countAmountWithTax = countAmountWithTax.add(redStatistic.getApplyRedNotificationAmountWithTax());
            }
            if (redStatistic.getReverseRedNotificationAmountWithTax() != null) {
                countAmountWithTax = countAmountWithTax.add(redStatistic.getReverseRedNotificationAmountWithTax());
            }
            if (redStatistic.getApplyRedNotificationTaxAmount() != null) {
                countTaxAmount = countTaxAmount.add(redStatistic.getApplyRedNotificationTaxAmount());
            }
            if (redStatistic.getReverseRedNotificationTaxAmount() == null) continue;
            countTaxAmount = countTaxAmount.add(redStatistic.getReverseRedNotificationTaxAmount());
        }
        HashMap<String, BigDecimal> returenMap = new HashMap<String, BigDecimal>();
        returenMap.put("amountWithTax", countAmountWithTax);
        returenMap.put("taxAmount", countTaxAmount);
        return returenMap;
    }

    static /* synthetic */ List access$000(ReportClaimStatisticServiceImpl x0, List x1) {
        return x0.excelToList(x1);
    }

    static /* synthetic */ ReportClaimStatisticMapper access$100(ReportClaimStatisticServiceImpl x0) {
        return x0.reportClaimStatisticMapper;
    }

    static /* synthetic */ ThreadPoolExecutor access$200(ReportClaimStatisticServiceImpl x0) {
        return x0.taskPool;
    }

    static /* synthetic */ List access$300(ReportClaimStatisticServiceImpl x0, List x1) {
        return x0.excelChangeToList(x1);
    }

    static /* synthetic */ TXfBillDeductMapper access$400(ReportClaimStatisticServiceImpl x0) {
        return x0.tXfBillDeductMapper;
    }

    static /* synthetic */ Map access$500(ReportClaimStatisticServiceImpl x0, ReportClaimStatistic x1) {
        return x0.getAllDetailsAmount(x1);
    }
}

