/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.config.NasConfig;
import com.reportfrom.wapp.entity.ReportChcCheck;
import com.reportfrom.wapp.mapper.first.ReportChcCheckMapper;
import com.reportfrom.wapp.request.ChcCheckRequest;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.ReportChcCheckService;
import com.reportfrom.wapp.service.impl.ReportChcCheckServiceImpl;
import com.reportfrom.wapp.util.DateUtils;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import com.reportfrom.wapp.util.SFTPUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ReportChcCheckServiceImpl
extends ServiceImpl<ReportChcCheckMapper, ReportChcCheck>
implements ReportChcCheckService {
    @Autowired
    private ReportChcCheckMapper reportChcCheckMapper;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;
    @Autowired
    private NasConfig nasConfig;

    public PageUtils queryChcCheck(ChcCheckRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        List reportChcChecks = this.reportChcCheckMapper.selectMapsByParams(map);
        Integer count = this.reportChcCheckMapper.selectChcCheckCountByParam(map);
        PageUtils rpage = new PageUtils();
        rpage.setList(reportChcChecks);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public int queryChcCheckList(ChcCheckRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        Integer count = this.reportChcCheckMapper.selectChcCheckCountByParam(map);
        return count;
    }

    public void produceChcCheck(ChcCheckRequest params) {
        File file = new File(this.ftpConfig.getChcLocalPath());
        if (!file.exists()) {
            file.mkdirs();
        }
        this.readExcelXlsx(params);
        this.readExcelXlsx2(params);
        this.readExcelXlsx3(params);
        this.readExcelXlsx4(params);
        this.calculateDifference(params);
    }

    public void chcCheckExport(ChcCheckRequest params, String token) {
        String downLoadfileName = "CHC\u6838\u5bf9\u62a5\u8868";
        String uploadfileName = "chcCheck-" + DateUtils.getStringDateShort();
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        List voList = this.reportChcCheckMapper.selectMapsByParams(map);
        String path = this.nasConfig.getUrl();
        ExcelUtils.createExcel((List)voList, (String)ExcelTypeConfig.CHCCHECK_QUERY, (String)uploadfileName, (String)path);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, downLoadfileName, uploadfileName);
    }

    public void calculateDifference(ChcCheckRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        List reportChcChecks = this.reportChcCheckMapper.selectMapsByParams(map);
        for (ReportChcCheck reportChcCheck : reportChcChecks) {
            BigDecimal salesAmount = reportChcCheck.getSalesAmount() == null ? BigDecimal.ZERO : reportChcCheck.getSalesAmount();
            BigDecimal amountWithoutTax = reportChcCheck.getAmountWithoutTax() == null ? BigDecimal.ZERO : reportChcCheck.getAmountWithoutTax();
            BigDecimal salesTaxAmount = reportChcCheck.getSalesTaxAmount() == null ? BigDecimal.ZERO : reportChcCheck.getSalesTaxAmount();
            BigDecimal taxAmount = reportChcCheck.getTaxAmount() == null ? BigDecimal.ZERO : reportChcCheck.getTaxAmount();
            BigDecimal oilSalesAmount = reportChcCheck.getOilSalesAmount() == null ? BigDecimal.ZERO : reportChcCheck.getOilSalesAmount();
            BigDecimal fOilSalesAmount = reportChcCheck.getFOilSalesAmount() == null ? BigDecimal.ZERO : reportChcCheck.getFOilSalesAmount();
            BigDecimal oilSalesTaxAmount = reportChcCheck.getOilSalesTaxAmount() == null ? BigDecimal.ZERO : reportChcCheck.getOilSalesTaxAmount();
            BigDecimal fOilSalesTaxAmount = reportChcCheck.getFOilSalesTaxAmount() == null ? BigDecimal.ZERO : reportChcCheck.getFOilSalesTaxAmount();
            reportChcCheck.setDifferenceSalesAmount(salesAmount.subtract(amountWithoutTax));
            reportChcCheck.setDifferenceSalesTaxAmount(salesTaxAmount.subtract(taxAmount));
            reportChcCheck.setDifferenceAmount(oilSalesAmount.add(fOilSalesAmount).subtract(amountWithoutTax));
            reportChcCheck.setDifferenceTaxAmount(oilSalesTaxAmount.add(fOilSalesTaxAmount).subtract(taxAmount));
            reportChcCheck.setUpdateTime(new Date());
            this.reportChcCheckMapper.updateChcCheck(reportChcCheck);
        }
    }

    public void insertChcCheck(ReportChcCheck reportChcCheck) {
        this.reportChcCheckMapper.insertChcCheck(reportChcCheck);
    }

    public void readExcelXlsx(ChcCheckRequest params) {
        try {
            SFTPUtils.getInstance().download(this.ftpConfig.getChcRemotePath() + params.getBatchNo() + "/GT108-T3(2)-KPTZ.xlsx", this.ftpConfig.getChcLocalPath() + "GT108-T3(2)-KPTZ.xlsx");
            String filePath = this.ftpConfig.getChcLocalPath() + "/GT108-T3(2)-KPTZ.xlsx";
            FileInputStream is = new FileInputStream(filePath);
            XSSFWorkbook xssfWorkbook = new XSSFWorkbook((InputStream)is);
            XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(0);
            for (int rowNum = 1; rowNum < xssfSheet.getLastRowNum(); ++rowNum) {
                XSSFRow row = xssfSheet.getRow(rowNum);
                XSSFCell jvCell = row.getCell(0);
                XSSFCell salesAmountCell = row.getCell(3);
                XSSFCell salesTaxAmountCell = row.getCell(4);
                String jv = ReportChcCheckServiceImpl.getValue((XSSFCell)jvCell);
                BigDecimal salesAmount = ReportChcCheckServiceImpl.getValue((XSSFCell)salesAmountCell) == null ? null : new BigDecimal(ReportChcCheckServiceImpl.getValue((XSSFCell)salesAmountCell));
                BigDecimal salesTaxAmount = ReportChcCheckServiceImpl.getValue((XSSFCell)salesTaxAmountCell) == null ? null : new BigDecimal(ReportChcCheckServiceImpl.getValue((XSSFCell)salesTaxAmountCell));
                ReportChcCheck reportChcCheck1 = new ReportChcCheck();
                reportChcCheck1.setJv(jv);
                reportChcCheck1.setTaxRate("00%");
                reportChcCheck1.setBatchNo(params.getBatchNo());
                reportChcCheck1.setSalesAmount(salesAmount);
                reportChcCheck1.setSalesTaxAmount(salesTaxAmount);
                reportChcCheck1.setCreateTime(new Date());
                ReportChcCheck reportChcCheck2 = new ReportChcCheck();
                XSSFCell salesAmountCell2 = row.getCell(7);
                XSSFCell salesTaxAmountCell2 = row.getCell(8);
                BigDecimal salesAmount2 = ReportChcCheckServiceImpl.getValue((XSSFCell)salesAmountCell2) == null ? null : new BigDecimal(ReportChcCheckServiceImpl.getValue((XSSFCell)salesAmountCell2));
                BigDecimal salesTaxAmount2 = ReportChcCheckServiceImpl.getValue((XSSFCell)salesTaxAmountCell2) == null ? null : new BigDecimal(ReportChcCheckServiceImpl.getValue((XSSFCell)salesTaxAmountCell2));
                reportChcCheck2.setJv(jv);
                reportChcCheck2.setTaxRate("09%");
                reportChcCheck2.setBatchNo(params.getBatchNo());
                reportChcCheck2.setSalesAmount(salesAmount2);
                reportChcCheck2.setSalesTaxAmount(salesTaxAmount2);
                reportChcCheck2.setCreateTime(new Date());
                ReportChcCheck reportChcCheck3 = new ReportChcCheck();
                XSSFCell salesAmountCell3 = row.getCell(11);
                XSSFCell salesTaxAmountCell3 = row.getCell(12);
                System.out.println(ReportChcCheckServiceImpl.getValue((XSSFCell)salesAmountCell3));
                BigDecimal salesAmount3 = ReportChcCheckServiceImpl.getValue((XSSFCell)salesAmountCell3) == null ? null : new BigDecimal(ReportChcCheckServiceImpl.getValue((XSSFCell)salesAmountCell3));
                BigDecimal salesTaxAmount3 = ReportChcCheckServiceImpl.getValue((XSSFCell)salesTaxAmountCell3) == null ? null : new BigDecimal(ReportChcCheckServiceImpl.getValue((XSSFCell)salesTaxAmountCell3));
                reportChcCheck3.setJv(jv);
                reportChcCheck3.setTaxRate("13%");
                reportChcCheck3.setBatchNo(params.getBatchNo());
                reportChcCheck3.setSalesAmount(salesAmount3);
                reportChcCheck3.setSalesTaxAmount(salesTaxAmount3);
                QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq(!StringUtils.isEmpty((String)reportChcCheck1.getBatchNo()), (Object)"batch_no", (Object)reportChcCheck1.getBatchNo())).eq(!StringUtils.isEmpty((String)reportChcCheck1.getJv()), (Object)"jv", (Object)reportChcCheck1.getJv())).eq(!StringUtils.isEmpty((String)reportChcCheck1.getTaxRate()), (Object)"tax_rate", (Object)reportChcCheck1.getTaxRate());
                List reportChcChecks = this.reportChcCheckMapper.selectList((Wrapper)queryWrapper);
                if (reportChcChecks.size() > 0) {
                    ((ReportChcCheck)reportChcChecks.get(0)).setSalesAmount(reportChcCheck1.getSalesAmount());
                    ((ReportChcCheck)reportChcChecks.get(0)).setSalesTaxAmount(reportChcCheck1.getSalesTaxAmount());
                    this.reportChcCheckMapper.updateChcCheck((ReportChcCheck)reportChcChecks.get(0));
                } else {
                    reportChcCheck1.setCreateTime(new Date());
                    this.reportChcCheckMapper.insertChcCheck(reportChcCheck1);
                }
                QueryWrapper queryWrapper2 = (QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq(!StringUtils.isEmpty((String)reportChcCheck2.getBatchNo()), (Object)"batch_no", (Object)reportChcCheck2.getBatchNo())).eq(!StringUtils.isEmpty((String)reportChcCheck2.getJv()), (Object)"jv", (Object)reportChcCheck2.getJv())).eq(!StringUtils.isEmpty((String)reportChcCheck2.getTaxRate()), (Object)"tax_rate", (Object)reportChcCheck2.getTaxRate());
                reportChcChecks = this.reportChcCheckMapper.selectList((Wrapper)queryWrapper2);
                if (reportChcChecks.size() > 0) {
                    ((ReportChcCheck)reportChcChecks.get(0)).setSalesAmount(reportChcCheck2.getSalesAmount());
                    ((ReportChcCheck)reportChcChecks.get(0)).setSalesTaxAmount(reportChcCheck2.getSalesTaxAmount());
                    this.reportChcCheckMapper.updateChcCheck((ReportChcCheck)reportChcChecks.get(0));
                } else {
                    reportChcCheck2.setCreateTime(new Date());
                    this.reportChcCheckMapper.insertChcCheck(reportChcCheck2);
                }
                QueryWrapper queryWrapper3 = (QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq(!StringUtils.isEmpty((String)reportChcCheck3.getBatchNo()), (Object)"batch_no", (Object)reportChcCheck3.getBatchNo())).eq(!StringUtils.isEmpty((String)reportChcCheck3.getJv()), (Object)"jv", (Object)reportChcCheck3.getJv())).eq(!StringUtils.isEmpty((String)reportChcCheck3.getTaxRate()), (Object)"tax_rate", (Object)reportChcCheck3.getTaxRate());
                reportChcChecks = this.reportChcCheckMapper.selectList((Wrapper)queryWrapper3);
                if (reportChcChecks.size() > 0) {
                    ((ReportChcCheck)reportChcChecks.get(0)).setSalesAmount(reportChcCheck3.getSalesAmount());
                    ((ReportChcCheck)reportChcChecks.get(0)).setSalesTaxAmount(reportChcCheck3.getSalesTaxAmount());
                    this.reportChcCheckMapper.updateChcCheck((ReportChcCheck)reportChcChecks.get(0));
                    continue;
                }
                reportChcCheck3.setCreateTime(new Date());
                this.reportChcCheckMapper.insertChcCheck(reportChcCheck3);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readExcelXlsx2(ChcCheckRequest params) {
        try {
            SFTPUtils.getInstance().download(this.ftpConfig.getChcRemotePath() + params.getBatchNo() + "/GT108-OIL-SUMM.xlsx", this.ftpConfig.getChcLocalPath() + "GT108-OIL-SUMM.xlsx");
            String filePath = this.ftpConfig.getChcLocalPath() + "/GT108-OIL-SUMM.xlsx";
            FileInputStream is = new FileInputStream(filePath);
            XSSFWorkbook xssfWorkbook = new XSSFWorkbook((InputStream)is);
            XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(0);
            for (int rowNum = 1; rowNum < xssfSheet.getLastRowNum(); ++rowNum) {
                XSSFRow row = xssfSheet.getRow(rowNum);
                XSSFCell jvCell = row.getCell(0);
                XSSFCell taxRateCell = row.getCell(1);
                XSSFCell oil_sales_amountCell = row.getCell(7);
                XSSFCell oil_sales_tax_amount_totalCell = row.getCell(8);
                String jv = ReportChcCheckServiceImpl.getValue((XSSFCell)jvCell);
                String taxRate = ReportChcCheckServiceImpl.getValue((XSSFCell)taxRateCell);
                BigDecimal oilSalesAmount = ReportChcCheckServiceImpl.getValue((XSSFCell)oil_sales_amountCell) == null ? null : new BigDecimal(ReportChcCheckServiceImpl.getValue((XSSFCell)oil_sales_amountCell));
                BigDecimal OilSalesTaxAmountTotal = ReportChcCheckServiceImpl.getValue((XSSFCell)oil_sales_tax_amount_totalCell) == null ? null : new BigDecimal(ReportChcCheckServiceImpl.getValue((XSSFCell)oil_sales_tax_amount_totalCell));
                BigDecimal OilSalesTaxAmount = OilSalesTaxAmountTotal.subtract(oilSalesAmount);
                ReportChcCheck reportChcCheck1 = new ReportChcCheck();
                reportChcCheck1.setJv(jv);
                reportChcCheck1.setTaxRate(taxRate);
                reportChcCheck1.setBatchNo(params.getBatchNo());
                QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq(!StringUtils.isEmpty((String)reportChcCheck1.getBatchNo()), (Object)"batch_no", (Object)reportChcCheck1.getBatchNo())).eq(!StringUtils.isEmpty((String)reportChcCheck1.getJv()), (Object)"jv", (Object)reportChcCheck1.getJv())).eq(!StringUtils.isEmpty((String)reportChcCheck1.getTaxRate()), (Object)"tax_rate", (Object)reportChcCheck1.getTaxRate());
                List reportChcChecks = this.reportChcCheckMapper.selectList((Wrapper)queryWrapper);
                if (reportChcChecks.size() > 0) {
                    ((ReportChcCheck)reportChcChecks.get(0)).setOilSalesAmount(oilSalesAmount);
                    ((ReportChcCheck)reportChcChecks.get(0)).setOilSalesTaxAmount(OilSalesTaxAmount);
                    this.reportChcCheckMapper.updateChcCheck((ReportChcCheck)reportChcChecks.get(0));
                    continue;
                }
                reportChcCheck1.setOilSalesAmount(oilSalesAmount);
                reportChcCheck1.setOilSalesTaxAmount(OilSalesTaxAmount);
                reportChcCheck1.setCreateTime(new Date());
                this.reportChcCheckMapper.insertChcCheck(reportChcCheck1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readExcelXlsx3(ChcCheckRequest params) {
        try {
            SFTPUtils.getInstance().download(this.ftpConfig.getChcRemotePath() + params.getBatchNo() + "/GT108-NOIL-SUMM.xlsx", this.ftpConfig.getChcLocalPath() + "GT108-NOIL-SUMM.xlsx");
            String filePath = this.ftpConfig.getChcLocalPath() + "/GT108-NOIL-SUMM.xlsx";
            FileInputStream is = new FileInputStream(filePath);
            XSSFWorkbook xssfWorkbook = new XSSFWorkbook((InputStream)is);
            XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(0);
            for (int rowNum = 1; rowNum < xssfSheet.getLastRowNum(); ++rowNum) {
                XSSFRow row = xssfSheet.getRow(rowNum);
                XSSFCell jvCell = row.getCell(0);
                XSSFCell taxRateCell = row.getCell(1);
                XSSFCell f_oil_sales_amountCell = row.getCell(7);
                XSSFCell f_oil_sales_tax_amount_totalCell = row.getCell(8);
                String jv = ReportChcCheckServiceImpl.getValue((XSSFCell)jvCell);
                String taxRate = ReportChcCheckServiceImpl.getValue((XSSFCell)taxRateCell);
                BigDecimal fOilSalesAmount = ReportChcCheckServiceImpl.getValue((XSSFCell)f_oil_sales_amountCell) == null ? null : new BigDecimal(ReportChcCheckServiceImpl.getValue((XSSFCell)f_oil_sales_amountCell));
                BigDecimal fOilSalesTaxAmountTotal = ReportChcCheckServiceImpl.getValue((XSSFCell)f_oil_sales_tax_amount_totalCell) == null ? null : new BigDecimal(ReportChcCheckServiceImpl.getValue((XSSFCell)f_oil_sales_tax_amount_totalCell));
                BigDecimal fOilSalesTaxAmount = fOilSalesTaxAmountTotal.subtract(fOilSalesAmount);
                ReportChcCheck reportChcCheck1 = new ReportChcCheck();
                reportChcCheck1.setJv(jv);
                reportChcCheck1.setTaxRate(taxRate);
                reportChcCheck1.setBatchNo(params.getBatchNo());
                QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq(!StringUtils.isEmpty((String)reportChcCheck1.getBatchNo()), (Object)"batch_no", (Object)reportChcCheck1.getBatchNo())).eq(!StringUtils.isEmpty((String)reportChcCheck1.getJv()), (Object)"jv", (Object)reportChcCheck1.getJv())).eq(!StringUtils.isEmpty((String)reportChcCheck1.getTaxRate()), (Object)"tax_rate", (Object)reportChcCheck1.getTaxRate());
                List reportChcChecks = this.reportChcCheckMapper.selectList((Wrapper)queryWrapper);
                if (reportChcChecks.size() > 0) {
                    ((ReportChcCheck)reportChcChecks.get(0)).setFOilSalesAmount(fOilSalesAmount);
                    ((ReportChcCheck)reportChcChecks.get(0)).setFOilSalesTaxAmount(fOilSalesTaxAmount);
                    ((ReportChcCheck)reportChcChecks.get(0)).setUpdateTime(new Date());
                    this.reportChcCheckMapper.updateChcCheck((ReportChcCheck)reportChcChecks.get(0));
                    continue;
                }
                reportChcCheck1.setFOilSalesAmount(fOilSalesAmount);
                reportChcCheck1.setFOilSalesTaxAmount(fOilSalesTaxAmount);
                this.reportChcCheckMapper.insertChcCheck(reportChcCheck1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readExcelXlsx4(ChcCheckRequest params) {
        try {
            SFTPUtils.getInstance().download(this.ftpConfig.getChcRemotePath() + params.getBatchNo() + "/GT108-LPDR.xlsx", this.ftpConfig.getChcLocalPath() + "GT108-LPDR.xlsx");
            String filePath = this.ftpConfig.getChcLocalPath() + "/GT108-LPDR.xlsx";
            FileInputStream is = new FileInputStream(filePath);
            XSSFWorkbook xssfWorkbook = new XSSFWorkbook((InputStream)is);
            XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(0);
            for (int rowNum = 1; rowNum < xssfSheet.getLastRowNum(); ++rowNum) {
                XSSFRow row = xssfSheet.getRow(rowNum);
                XSSFCell jvCell = row.getCell(19);
                XSSFCell taxRateCell = row.getCell(16);
                XSSFCell amount_without_taxCell = row.getCell(17);
                XSSFCell tax_amountCell = row.getCell(18);
                String jv = ReportChcCheckServiceImpl.getValue((XSSFCell)jvCell);
                String taxRate = ReportChcCheckServiceImpl.getValue((XSSFCell)taxRateCell);
                BigDecimal amountWithoutTax = ReportChcCheckServiceImpl.getValue((XSSFCell)amount_without_taxCell) == null ? null : new BigDecimal(ReportChcCheckServiceImpl.getValue((XSSFCell)amount_without_taxCell));
                BigDecimal taxAmount = ReportChcCheckServiceImpl.getValue((XSSFCell)tax_amountCell) == null ? null : new BigDecimal(ReportChcCheckServiceImpl.getValue((XSSFCell)tax_amountCell));
                ReportChcCheck reportChcCheck1 = new ReportChcCheck();
                reportChcCheck1.setJv(jv);
                reportChcCheck1.setTaxRate(taxRate);
                reportChcCheck1.setBatchNo(params.getBatchNo());
                QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq(!StringUtils.isEmpty((String)reportChcCheck1.getBatchNo()), (Object)"batch_no", (Object)reportChcCheck1.getBatchNo())).eq(!StringUtils.isEmpty((String)reportChcCheck1.getJv()), (Object)"jv", (Object)reportChcCheck1.getJv())).eq(!StringUtils.isEmpty((String)reportChcCheck1.getTaxRate()), (Object)"tax_rate", (Object)reportChcCheck1.getTaxRate());
                List reportChcChecks = this.reportChcCheckMapper.selectList((Wrapper)queryWrapper);
                if (reportChcChecks.size() > 0) {
                    ((ReportChcCheck)reportChcChecks.get(0)).setAmountWithoutTax(amountWithoutTax);
                    ((ReportChcCheck)reportChcChecks.get(0)).setTaxAmount(taxAmount);
                    ((ReportChcCheck)reportChcChecks.get(0)).setUpdateTime(new Date());
                    this.reportChcCheckMapper.updateChcCheck((ReportChcCheck)reportChcChecks.get(0));
                    continue;
                }
                reportChcCheck1.setAmountWithoutTax(amountWithoutTax);
                reportChcCheck1.setTaxAmount(taxAmount);
                this.reportChcCheckMapper.insertChcCheck(reportChcCheck1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getValue(XSSFCell xssfCell) {
        String returnValue = "";
        if (xssfCell == null) {
            return null;
        }
        switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[xssfCell.getCellTypeEnum().ordinal()]) {
            case 1: {
                returnValue = String.valueOf(xssfCell.getStringCellValue());
                if (!returnValue.trim().equals("")) break;
                returnValue = null;
                break;
            }
            case 2: {
                returnValue = String.valueOf(xssfCell.getNumericCellValue());
                break;
            }
            case 3: {
                returnValue = String.valueOf(xssfCell.getBooleanCellValue());
                break;
            }
            case 4: {
                returnValue = null;
            }
        }
        return returnValue;
    }

    public static String getValue(HSSFCell xssfCell) {
        String returnValue = "";
        switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[xssfCell.getCellTypeEnum().ordinal()]) {
            case 1: {
                returnValue = String.valueOf(xssfCell.getStringCellValue());
                if (!returnValue.trim().equals("")) break;
                returnValue = null;
                break;
            }
            case 2: {
                returnValue = String.valueOf(xssfCell.getNumericCellValue());
                break;
            }
            case 3: {
                returnValue = String.valueOf(xssfCell.getBooleanCellValue());
                break;
            }
            case 4: {
                returnValue = null;
            }
        }
        return returnValue;
    }
}

