/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.controller;

import com.reportfrom.wapp.config.R;
import com.reportfrom.wapp.entity.ReportPurchaseQuart;
import com.reportfrom.wapp.mapper.first.ReportPurchaseQuartMapper;
import com.reportfrom.wapp.request.PurcherTaxReq;
import com.reportfrom.wapp.request.RecordInvoiceDetailsReq;
import com.reportfrom.wapp.request.RecordInvoiceReq;
import com.reportfrom.wapp.service.TDxRecordInvoiceService;
import com.reportfrom.wapp.taskthread.PurchaserQuartzFalseThread;
import com.reportfrom.wapp.taskthread.PurchaserQuartzTrueThread;
import com.reportfrom.wapp.util.PageUtils;
import io.micrometer.core.instrument.util.StringUtils;
import io.swagger.annotations.ApiOperation;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/walmart-report/t-dx-record-invoice"})
public class TDxRecordInvoiceController {
    private static final Logger log = LoggerFactory.getLogger(TDxRecordInvoiceController.class);
    @Autowired
    private TDxRecordInvoiceService tDxRecordInvoiceService;
    @Autowired
    private ReportPurchaseQuartMapper quartMapper;
    private ThreadPoolExecutor threadPoolForTure = new ThreadPoolExecutor(7, 10, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
    private ThreadPoolExecutor threadPoolForFalse = new ThreadPoolExecutor(7, 10, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));

    @ApiOperation(value="\u67e5\u8be2\u975e\u5546\u4f20\u7968\u6e05\u5355")
    @RequestMapping(value={"/recordInvoiceQuery"}, method={RequestMethod.POST})
    @ResponseBody
    public R recordInvoiceQuery(@RequestBody RecordInvoiceReq params) {
        PageUtils page = this.tDxRecordInvoiceService.queryPageRecordInvoice(params);
        return R.ok().put("page", (Object)page);
    }

    @ApiOperation(value="\u975e\u5546\u4f20\u7968\u6e05\u5355\u62a5\u8868\u751f\u6210(\u540e\u53f0\u6267\u884c)")
    @RequestMapping(value={"/recordInvoiceExport"}, method={RequestMethod.POST})
    @ResponseBody
    public R recordInvoiceExport(@RequestBody RecordInvoiceReq params, @RequestHeader(value="token") String token) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return R.ok((String)"\u5bfc\u51fa\u6b63\u5728\u5904\u7406\uff0c\u8bf7\u7a0d\u540e\u5728\u6d88\u606f\u4e2d\u5fc3\u67e5\u770b");
    }

    @ApiOperation(value="\u67e5\u8be2\u975e\u5546\u53d1\u7968\u660e\u7ec6\u62a5\u8868")
    @RequestMapping(value={"/recordInvoiceDetailsQuery"}, method={RequestMethod.POST})
    @ResponseBody
    public R recordInvoiceDetailsQuery(@RequestBody RecordInvoiceDetailsReq params) {
        PageUtils page = this.tDxRecordInvoiceService.queryPageRecordInvoiceDeatils(params);
        return R.ok().put("page", (Object)page);
    }

    @ApiOperation(value="\u975e\u5546\u53d1\u7968\u660e\u7ec6\u62a5\u8868\u751f\u6210(\u540e\u53f0\u6267\u884c)")
    @RequestMapping(value={"/recordInvoiceDetailsExport"}, method={RequestMethod.POST})
    @ResponseBody
    public R recordInvoiceDetailsExport(@RequestBody RecordInvoiceDetailsReq params, @RequestHeader(value="token") String token) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return R.ok((String)"\u5bfc\u51fa\u6b63\u5728\u5904\u7406\uff0c\u8bf7\u7a0d\u540e\u5728\u6d88\u606f\u4e2d\u5fc3\u67e5\u770b");
    }

    @ApiOperation(value="\u67e5\u8be2\u8fdb\u9879\u7a0e\u91d1\u6c47\u603b\u62a5\u8868")
    @RequestMapping(value={"/purcherTaxQuery"}, method={RequestMethod.POST})
    @ResponseBody
    public R purcherTaxQuery(@RequestBody PurcherTaxReq params) {
        String dqskssq = params.getRzhBelongDate();
        if (StringUtils.isBlank((String)dqskssq) && "1".equals(params.getRzhYesorno())) {
            return R.error((String)"\u5df2\u8ba4\u8bc1\u72b6\u6001\uff0c\u7ed3\u7b97\u671f\u95f4\u4e0d\u53ef\u4e3a\u7a7a");
        }
        PageUtils page = new PageUtils();
        page = "1".equals(params.getRzhYesorno()) ? this.tDxRecordInvoiceService.purcherTaxQuery1(params) : this.tDxRecordInvoiceService.purcherTaxQuery2(params);
        return R.ok().put("page", (Object)page);
    }

    @ApiOperation(value="\u5bfc\u51fa\u8fdb\u9879\u7a0e\u91d1\u6c47\u603b\u62a5\u8868(\u540e\u53f0\u6267\u884c)")
    @RequestMapping(value={"/purcherTaxExport"}, method={RequestMethod.POST})
    @ResponseBody
    public R purcherTaxExport(@RequestBody PurcherTaxReq params, @RequestHeader(value="token") String token) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return R.ok((String)"\u5bfc\u51fa\u6b63\u5728\u5904\u7406\uff0c\u8bf7\u7a0d\u540e\u5728\u6d88\u606f\u4e2d\u5fc3\u67e5\u770b");
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public void test(@RequestParam String type, @RequestParam String dataMouth, @RequestParam String flowTypeNo) {
        ReportPurchaseQuart reportPurchaseQuart = new ReportPurchaseQuart();
        reportPurchaseQuart.setRzhYesorNo(type);
        reportPurchaseQuart.setDateMouth(dataMouth);
        this.quartMapper.insert((Object)reportPurchaseQuart);
        Long taskID = reportPurchaseQuart.getId();
        log.info("taskid->{}", (Object)taskID);
        if (StringUtils.isEmpty((String)flowTypeNo) || "0".equals(flowTypeNo)) {
            for (int i = 1; i <= 7; ++i) {
                if (i == 4) continue;
                PurcherTaxReq query = new PurcherTaxReq();
                if ("1".equals(type)) {
                    log.info("\u624b\u52a8\u64cd\u4f5c->\u5f00\u59cb\u5904\u7406\u8fdb\u9879\u7a0e\u91d1\uff08\u5df2\u8ba4\u8bc1\uff09\u660e\u7ec6  taskid->{}flowType->{}", (Object)taskID, (Object)i);
                    query.setFlowTypeNo(i + "");
                    query.setRzhBelongDate(dataMouth);
                    this.threadPoolForTure.execute((Runnable)new PurchaserQuartzTrueThread(query, taskID));
                    continue;
                }
                query.setFlowTypeNo(i + "");
                if ("1".equals(i + "")) {
                    query.setIsElectronicInvoice(Boolean.valueOf(true));
                } else {
                    query.setIsElectronicInvoice(Boolean.valueOf(false));
                }
                log.info("\u624b\u52a8\u64cd\u4f5c->\u5f00\u59cb\u5904\u7406\u8fdb\u9879\u7a0e\u91d1\uff08\u5f85\u8ba4\u8bc1\uff09\u660e\u7ec6  taskid->{}flowType->{}", (Object)taskID, (Object)i);
                this.threadPoolForTure.execute((Runnable)new PurchaserQuartzFalseThread(query, taskID));
            }
        } else {
            PurcherTaxReq query = new PurcherTaxReq();
            if ("1".equals(type)) {
                log.info("\u624b\u52a8\u64cd\u4f5c->\u5f00\u59cb\u5904\u7406\u8fdb\u9879\u7a0e\u91d1\uff08\u5df2\u8ba4\u8bc1\uff09\u660e\u7ec6  taskid->{}flowType->{}", (Object)taskID, (Object)flowTypeNo);
                query.setFlowTypeNo(flowTypeNo);
                query.setRzhBelongDate(dataMouth);
                this.threadPoolForTure.execute((Runnable)new PurchaserQuartzTrueThread(query, taskID));
            } else {
                query.setFlowTypeNo(flowTypeNo);
                if ("1".equals(flowTypeNo)) {
                    query.setIsElectronicInvoice(Boolean.valueOf(true));
                } else {
                    query.setIsElectronicInvoice(Boolean.valueOf(false));
                }
                log.info("\u624b\u52a8\u64cd\u4f5c->\u5f00\u59cb\u5904\u7406\u8fdb\u9879\u7a0e\u91d1\uff08\u5f85\u8ba4\u8bc1\uff09\u660e\u7ec6  taskid->{}flowType->{}", (Object)taskID, (Object)flowTypeNo);
                this.threadPoolForTure.execute((Runnable)new PurchaserQuartzFalseThread(query, taskID));
            }
        }
    }

    static /* synthetic */ TDxRecordInvoiceService access$000(TDxRecordInvoiceController x0) {
        return x0.tDxRecordInvoiceService;
    }
}

