/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.reportfrom.wapp.config.NasConfig;
import com.reportfrom.wapp.entity.TDxMessagecontrol;
import com.reportfrom.wapp.entity.UserEntity;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.TDxMessagecontrolService;
import com.reportfrom.wapp.util.AESUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DS(value="third")
public class BaseReportExportServiceImpl
implements BaseReportExportService {
    private static final Logger log = LoggerFactory.getLogger(BaseReportExportServiceImpl.class);
    @Autowired
    private TDxMessagecontrolService messageControlService;
    @Autowired
    private NasConfig nasConfig;

    public static void main(String[] args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel(String token, String condition, String path, String downfileName, String uploadFileName) {
        UserEntity userEntity = null;
        try {
            String decryptToken = AESUtil.decryptData((String)token, (String)this.nasConfig.getTokeKey());
            String s = StringUtils.isEmpty((String)decryptToken) ? AESUtil.decryptData((String)URLDecoder.decode(token, "UTF-8"), (String)this.nasConfig.getTokeKey()) : decryptToken;
            userEntity = (UserEntity)JSON.parseObject((String)s, UserEntity.class);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        log.info("token\u89e3\u6790\u6210\u529f>>>>suerAccount={}", (Object)userEntity.getUserid());
        TDxMessagecontrol tDxMessagecontrol = new TDxMessagecontrol();
        tDxMessagecontrol.setUserAccount(userEntity.getLoginname());
        tDxMessagecontrol.setContent(this.getSuccContent(new Date()));
        try {
            if ("upload".equals(path)) {
                tDxMessagecontrol.setTitle("\u6587\u4ef6\u3010" + uploadFileName + "\u3011\u5bfc\u5165\u6210\u529f\uff01");
            } else {
                tDxMessagecontrol.setUrl(this.getUrl(uploadFileName, downfileName));
                tDxMessagecontrol.setTitle("\u6587\u4ef6\u3010" + downfileName + "\u3011\u5bfc\u51fa\u6210\u529f\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            tDxMessagecontrol.setTitle("\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\uff01");
            tDxMessagecontrol.setContent(this.getFileContent(e.getMessage()));
        }
        finally {
            tDxMessagecontrol.setOperationStatus("0");
            tDxMessagecontrol.setCreateTime(new Date());
            this.messageControlService.save((Object)tDxMessagecontrol);
            log.info("\u5c0f\u94c3\u94db\u6d88\u606f\u8868\u3010tdxmessageControl\u3011\u8bb0\u5f55\u6210\u529f..{}", (Object)JSON.toJSONString((Object)tDxMessagecontrol));
        }
    }

    public void uploadExcel(String token, String condition, String path, String uploadFileName) {
        this.exportExcel(token, condition, path, "", uploadFileName);
    }

    public String getSuccContent(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String content = "\u7533\u8bf7\u65f6\u95f4\uff1a" + df.format(date) + "\u3002\u7533\u8bf7\u5bfc\u51fa\u6210\u529f\uff0c\u53ef\u4ee5\u4e0b\u8f7d\uff01";
        return content;
    }

    public String getFileContent(String errmsg) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String content = "\u7533\u8bf7\u65f6\u95f4:" + df.format(new Date()) + "\u3002\u7533\u8bf7\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u7533\u8bf7\uff01";
        return content;
    }

    public String getUrl(String uploadName, String fileName) {
        String url = "download/file/" + uploadName + "?filename=" + fileName + "&type=xlsx";
        return url;
    }
}

