/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.NasConfig;
import com.reportfrom.wapp.entityVO.ReportAgingStatisticVO;
import com.reportfrom.wapp.mapper.first.ReportAgingStatisticMapper;
import com.reportfrom.wapp.request.ReportAgingStatisticRequest;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.ReportAgingStatisticService;
import com.reportfrom.wapp.util.DateUtils;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ReportAgingStatisticServiceImpl
implements ReportAgingStatisticService {
    private static final Logger log = LoggerFactory.getLogger(ReportAgingStatisticServiceImpl.class);
    @Autowired
    private ReportAgingStatisticMapper reportAgingStatisticMapper;
    @Autowired
    private NasConfig nasConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;

    public PageUtils queryPage(ReportAgingStatisticRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        Integer count = 0;
        List list = new ArrayList(0);
        if ("1".equals(params.getType())) {
            count = this.reportAgingStatisticMapper.selectClaimAllCountByParam(map);
            if (null != count && count > 0) {
                list = this.reportAgingStatisticMapper.selectClaimMapsByParams(map);
            }
        } else if ("2".equals(params.getType()) && null != (count = this.reportAgingStatisticMapper.selectAggrementAllCountByParam(map)) && count > 0) {
            list = this.reportAgingStatisticMapper.selectAggrementMapsByParams(map);
        }
        this.dealResult(params.getPeriod(), list);
        PageUtils rpage = new PageUtils();
        rpage.setList(list);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    private void dealResult(String ym, List<ReportAgingStatisticVO> list) {
        if (list != null && list.size() > 0) {
            LocalDate lastymDate = LocalDate.parse(ym + "01", DateTimeFormatter.ofPattern("yyyyMMdd")).with(TemporalAdjusters.lastDayOfMonth());
            list.forEach(t -> {
                if (!StringUtils.isEmpty((String)t.getPostingDate())) {
                    String postDateStr = t.getPostingDate();
                    String format = "yyyyMMdd";
                    if (postDateStr.matches("^(\\d{1,2}/\\d{1,2}/\\d{2})$")) {
                        format = "M/d/yy";
                    } else if (postDateStr.matches("^(\\d{1,2}/\\d{1,2}/\\d{4})$")) {
                        format = "M/d/yyyy";
                    } else if (postDateStr.matches("^(\\d{8})$")) {
                        format = "yyyyMMdd";
                    } else if (postDateStr.matches("^(\\d{4}-\\d{1,2}-\\d{1,2})$")) {
                        format = "yyyy-M-d";
                    } else if (postDateStr.matches("^(\\d{4}/\\d{1,2}/\\d{1,2})$")) {
                        format = "yyyy/M/d";
                    } else {
                        postDateStr = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
                    }
                    if ("0".equals(t.getIsRedInvoiceGroup())) {
                        t.setIsRedInvoiceGroup("\u5426");
                    } else if ("1".equals(t.getIsRedInvoiceGroup())) {
                        t.setIsRedInvoiceGroup("\u662f");
                    } else {
                        t.setIsRedInvoiceGroup("");
                    }
                    LocalDate postDate = LocalDate.parse(postDateStr, DateTimeFormatter.ofPattern(format));
                    int aging = Math.abs(ReportAgingStatisticServiceImpl.diffDays((LocalDate)postDate, (LocalDate)lastymDate));
                    t.setAging(String.valueOf(aging));
                    if (aging >= 0 && aging <= 30) {
                        t.setAging0To30(t.getUnsettledTaxAmount());
                    } else if (aging >= 31 && aging <= 60) {
                        t.setAging31To60(t.getUnsettledTaxAmount());
                    } else if (aging >= 61 && aging <= 90) {
                        t.setAging61To90(t.getUnsettledTaxAmount());
                    } else if (aging >= 91 && aging <= 120) {
                        t.setAging91To120(t.getUnsettledTaxAmount());
                    } else if (aging >= 121 && aging <= 180) {
                        t.setAging121To180(t.getUnsettledTaxAmount());
                    } else if (aging >= 181 && aging <= 360) {
                        t.setAging181To360(t.getUnsettledTaxAmount());
                    } else if (aging > 361) {
                        t.setAgingGt360(t.getUnsettledTaxAmount());
                    }
                }
            });
        }
    }

    public static void main(String[] args) {
        String ym = "202209,202209";
        if (StringUtils.isEmpty((String)ym)) {
            ym = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMM"));
        } else {
            if (ym.indexOf(",") != -1) {
                ym = ym.split(",")[1];
            }
            if (ym.length() > 6) {
                ym = ym.substring(0, 6);
            } else if (ym.length() < 6) {
                ym = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMM"));
            }
        }
        LocalDate lastymDate = LocalDate.parse(ym + "01", DateTimeFormatter.ofPattern("yyyyMMdd")).with(TemporalAdjusters.lastDayOfMonth());
        String postDateStr = "7/27/22";
        String format = "yyyyMMdd";
        if (postDateStr.matches("^(\\d{1,2}/\\d{1,2}/\\d{2})$")) {
            format = "M/d/yy";
        } else if (postDateStr.matches("^(\\d{1,2}/\\d{1,2}/\\d{4})$")) {
            format = "M/d/yyyy";
        } else if (postDateStr.matches("^(\\d{8})$")) {
            format = "yyyyMMdd";
        } else if (postDateStr.matches("^(\\d{4}-\\d{1,2}-\\d{1,2})$")) {
            format = "yyyy-M-d";
        } else if (postDateStr.matches("^(\\d{4}/\\d{1,2}/\\d{1,2})$")) {
            format = "yyyy/M/d";
        } else {
            postDateStr = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        }
        LocalDate postDate = LocalDate.parse(postDateStr, DateTimeFormatter.ofPattern(format));
        int aging = Math.abs(ReportAgingStatisticServiceImpl.diffDays((LocalDate)postDate, (LocalDate)lastymDate));
        System.out.println(aging);
    }

    public static int diffDays(LocalDate localDateStart, LocalDate localDateEnd) {
        Duration duration = Duration.between(localDateStart.atStartOfDay(), localDateEnd.atStartOfDay());
        return new Integer(String.valueOf(duration.toDays()));
    }

    public void produceReportAgingStatistic(ReportAgingStatisticRequest params, String token) {
        String downLoadfileName = "\u8d26\u9f84\u7edf\u8ba1\u62a5\u8868_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS"));
        String uploadfileName = "yearOld-" + DateUtils.getStringDateShort();
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        List list = new ArrayList(0);
        if ("1".equals(params.getType())) {
            list = this.reportAgingStatisticMapper.selectClaimMapsByParams(map);
        } else if ("2".equals(params.getType())) {
            list = this.reportAgingStatisticMapper.selectAggrementMapsByParams(map);
        }
        this.dealResult(params.getPeriod(), list);
        String path = this.nasConfig.getUrl();
        ExcelUtils.createExcel(list, (String)ExcelTypeConfig.REPORT_AGING_STATISTIC_QUERY, (String)uploadfileName, (String)path);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, downLoadfileName, uploadfileName);
    }
}

