/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.quartz;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.reportfrom.wapp.entity.AggrementRedJlEntity;
import com.reportfrom.wapp.entity.ReportAggrementEpdStatistic;
import com.reportfrom.wapp.quartz.ReportAggrementEpdStatisticQuartz;
import com.reportfrom.wapp.service.ReportAggrementEpdStatisticService;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ReportAggrementEpdStatisticQuartz {
    private static final Logger log = LoggerFactory.getLogger(ReportAggrementEpdStatisticQuartz.class);
    @Autowired
    private ReportAggrementEpdStatisticService reportAggrementEpdStatisticService;

    @Scheduled(cron="${quartz.AggrementStatisticQuartz.cron}")
    public void updateTask() {
        String yesterday = LocalDate.now().minusDays(1L).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        List postDateList = this.reportAggrementEpdStatisticService.getCalcPostDate(yesterday);
        if (postDateList == null || postDateList.size() == 0) {
            log.info("{} \u6ca1\u6709\u7ea2\u5b57\u4fe1\u606f\u8868\u7684\u8fc7\u8d26\u65e5\u671f", (Object)yesterday);
            return;
        }
        for (String lastMonth : postDateList) {
            log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 : {} \u8ba1\u7b97\u5f00\u59cb", (Object)lastMonth);
            this.updateAggrementEpdStatistic(lastMonth + "%");
            log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 : {} \u8ba1\u7b97\u7ed3\u675f", (Object)lastMonth);
        }
    }

    public void updateAggrementEpdStatistic(String lastMonth) {
        Long startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u91cd\u7f6e\u8ba1\u7b97\u4e3a\u7a7a \u5f00\u59cb");
        int updateLen = this.reportAggrementEpdStatisticService.updateNull(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u91cd\u7f6e\u8ba1\u7b97\u4e3a\u7a7a \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        this.updateZm(lastMonth);
        this.updateTotal(lastMonth);
    }

    public static void main(String[] args) {
        ArrayList<AggrementRedJlEntity> redList = new ArrayList<AggrementRedJlEntity>();
        redList.add(new AggrementRedJlEntity(Long.valueOf(80231L), "20220901", "20221011", new BigDecimal(2), "0", new BigDecimal(3)));
        redList.add(new AggrementRedJlEntity(Long.valueOf(80231L), "20221012", null, new BigDecimal(1), "1", new BigDecimal(3)));
        List list = ReportAggrementEpdStatisticQuartz.calcCxCk(redList);
        System.out.println(JSON.toJSONString((Object)list));
    }

    public static List<CxCkEntity> calcCxCk(List<AggrementRedJlEntity> redList) {
        ArrayList<CxCkEntity> tList = new ArrayList<CxCkEntity>();
        for (AggrementRedJlEntity redJlEntity : redList) {
            CxCkEntity t = new CxCkEntity();
            t.setCkTaxAmount(redJlEntity.getTaxAmount());
            t.setMaxCkDate(redJlEntity.getInvoiceDate());
            t.setStandardCurrencyAmount(redJlEntity.getStandardCurrencyAmount());
            if ("0".equals(redJlEntity.getIsSq())) {
                t.setCxTaxAmount(redJlEntity.getTaxAmount());
                t.setMaxCxDate(redJlEntity.getCancelDate());
            }
            tList.add(t);
        }
        return tList;
    }

    public void updateCxCk(List<String> reportIds) {
        if (reportIds != null && reportIds.size() > 0) {
            List allRedList = this.reportAggrementEpdStatisticService.getRedLog(reportIds);
            Map<String, List<AggrementRedJlEntity>> collect = allRedList.stream().collect(Collectors.groupingBy(a -> JSON.toJSONString((Object)a.getReportId())));
            ArrayList<ReportAggrementEpdStatistic> epdList = new ArrayList<ReportAggrementEpdStatistic>();
            Set<String> strings = collect.keySet();
            for (String reportId : strings) {
                List tList;
                List<AggrementRedJlEntity> redList = collect.get(reportId);
                if (redList == null || redList.size() <= 0 || (tList = ReportAggrementEpdStatisticQuartz.calcCxCk(redList)) == null || tList.size() <= 0) continue;
                AggrementRedJlEntity arJlEntity = redList.get(0);
                ReportAggrementEpdStatistic r = new ReportAggrementEpdStatistic();
                r.setId(arJlEntity.getReportId());
                BigDecimal standardCurrencyAmount = arJlEntity.getStandardCurrencyAmount();
                if (standardCurrencyAmount == null) {
                    standardCurrencyAmount = new BigDecimal(0);
                }
                for (int i = 0; i < tList.size(); ++i) {
                    CxCkEntity cxCkEntity;
                    CxCkEntity info = (CxCkEntity)tList.get(i);
                    if (i == 0) {
                        r.setAggrementRedTaxAmount(info.getStandardCurrencyAmount().compareTo(new BigDecimal(0)) < 0 ? info.getCkTaxAmount().abs() : info.getCkTaxAmount().abs().negate());
                        r.setAdjustmentTaxAmount(info.getStandardCurrencyAmount().abs().subtract(info.getCkTaxAmount().abs()));
                        r.setPaperDate(info.getMaxCkDate());
                        if (info.getMaxCxDate() != null) {
                            r.setReverseTaxAmount(info.getCxTaxAmount());
                            r.setReverseDate(info.getMaxCxDate());
                        }
                    }
                    if (i == 1) {
                        cxCkEntity = (CxCkEntity)tList.get(i - 1);
                        r.setReverseTaxAmount(cxCkEntity.getCxTaxAmount());
                        r.setReverseDate(cxCkEntity.getMaxCxDate());
                        if (info.getCkTaxAmount() == null) continue;
                        r.setReTaxAmount(info.getStandardCurrencyAmount().compareTo(new BigDecimal(0)) < 0 ? info.getCkTaxAmount().abs() : info.getCkTaxAmount().abs().negate());
                        r.setRePaperDate(info.getMaxCkDate());
                        r.setTotalAdjustmentTaxAmount(standardCurrencyAmount.abs().subtract(info.getCkTaxAmount()).setScale(2, 0));
                        continue;
                    }
                    if (i == 2) {
                        cxCkEntity = (CxCkEntity)tList.get(i - 1);
                        r.setReverseTaxAmountSecond(cxCkEntity.getCxTaxAmount());
                        r.setReverseDateSecond(cxCkEntity.getMaxCxDate());
                        if (info.getCkTaxAmount() == null) continue;
                        r.setReTaxAmountSecond(info.getStandardCurrencyAmount().compareTo(new BigDecimal(0)) < 0 ? info.getCkTaxAmount().abs() : info.getCkTaxAmount().abs().negate());
                        r.setRePaperDateSecond(info.getMaxCkDate());
                        r.setTotalAdjustmentTaxAmountSecond(standardCurrencyAmount.abs().subtract(info.getCkTaxAmount()).setScale(2, 0));
                        continue;
                    }
                    if (i != 3) continue;
                    cxCkEntity = (CxCkEntity)tList.get(i - 1);
                    r.setReverseTaxAmountThird(cxCkEntity.getCxTaxAmount());
                    r.setReverseDateThird(cxCkEntity.getMaxCxDate());
                    if (info.getCkTaxAmount() == null) continue;
                    r.setReTaxAmountThird(info.getStandardCurrencyAmount().compareTo(new BigDecimal(0)) < 0 ? info.getCkTaxAmount().abs() : info.getCkTaxAmount().abs().negate());
                    r.setRePaperDateThird(info.getMaxCkDate());
                    r.setTotalAdjustmentTaxAmountThird(standardCurrencyAmount.abs().subtract(info.getCkTaxAmount()).setScale(2, 0));
                }
                epdList.add(r);
            }
            List allRedLetterList = this.reportAggrementEpdStatisticService.getRedLetterLog(reportIds);
            Map<String, List<AggrementRedJlEntity>> collectLetter = allRedLetterList.stream().collect(Collectors.groupingBy(a -> JSON.toJSONString((Object)a.getReportId())));
            Set<String> stringLetters = collect.keySet();
            for (String reportId : stringLetters) {
                List tList;
                List<AggrementRedJlEntity> redLetterList = collectLetter.get(reportId);
                if (redLetterList == null || redLetterList.size() <= 0 || (tList = ReportAggrementEpdStatisticQuartz.calcCxCk(redLetterList)) == null || tList.size() <= 0) continue;
                AggrementRedJlEntity arJlEntity = redLetterList.get(0);
                ReportAggrementEpdStatistic r = new ReportAggrementEpdStatistic();
                r.setId(arJlEntity.getReportId());
                for (int i = 0; i < tList.size(); ++i) {
                    CxCkEntity info = (CxCkEntity)tList.get(i);
                    if (i != 0) continue;
                    r.setUpgradesAggrementRedTaxAmount(info.getStandardCurrencyAmount().compareTo(new BigDecimal(0)) < 0 ? info.getCkTaxAmount().abs() : info.getCkTaxAmount().abs().negate());
                    r.setUpgradesAdjustmentTaxAmount(info.getStandardCurrencyAmount().abs().subtract(info.getCkTaxAmount().abs()));
                    r.setUpgradesPaperDate(info.getMaxCkDate());
                }
                epdList.add(r);
            }
            Lists.partition(epdList, (int)40).forEach(epdListpage -> {
                log.info("\u5206\u7ec4\u66f4\u65b0\u64a4\u9500/\u91cd\u5f00\u8bb0\u5f55 reportAggrementEpdStatisticService.updateCxCk size() {}", (Object)epdListpage.size());
                this.reportAggrementEpdStatisticService.updateCxCk(epdListpage);
            });
        }
    }

    public void updateZm(String lastMonth) {
        Long startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u4f9b\u5e94\u5546\u540d\u79f0\uff0c\u662f\u5426\u7ea2\u7968\u9879\u76ee\u7ec4 \u5f00\u59cb");
        int updateLen = this.reportAggrementEpdStatisticService.updateBillDeduct(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u4f9b\u5e94\u5546\u540d\u79f0\uff0c\u662f\u5426\u7ea2\u7968\u9879\u76ee\u7ec4 \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u5df2\u7ed3\u6b3e\u672a\u5f00\u7968\u7a0e\u91d1 \u5f00\u59cb");
        updateLen = this.reportAggrementEpdStatisticService.updateUnInvoiceAmount(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u5df2\u7ed3\u6b3e\u672a\u5f00\u7968\u7a0e\u91d1 \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        List reportIds = this.reportAggrementEpdStatisticService.getReportIds(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u64a4\u9500\u3001\u91cd\u5f00 \u5f00\u59cb");
        Lists.partition((List)reportIds, (int)10000).forEach(epdListpage -> this.updateCxCk(epdListpage));
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u64a4\u9500\u3001\u91cd\u5f00 \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)(reportIds == null ? 0 : reportIds.size()), (Object)(System.currentTimeMillis() - startTime));
    }

    public void updateTotal(String lastMonth) {
        Long startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u4f59\u989d \u5f00\u59cb");
        int updateLen = this.reportAggrementEpdStatisticService.updateBalance(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u4f59\u989d \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u5dee\u5f02 \u5f00\u59cb");
        updateLen = this.reportAggrementEpdStatisticService.updateDifferenceAmount(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u5dee\u5f02 \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
    }

    @Scheduled(cron="${quartz.AggrementReportQuartz.produce.cron}")
    public void produceAggrementReport() throws IOException {
        Long startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u5b9a\u671f\u751f\u6210\u62a5\u8868\u5f00\u59cb\uff1a{}", (Object)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")));
        String period = LocalDate.now().minusMonths(1L).format(DateTimeFormatter.ofPattern("yyyyMM"));
        this.reportAggrementEpdStatisticService.produceAggrementReport(period);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u5b9a\u671f\u751f\u6210\u62a5\u8868\u5b8c\u6210\uff1a{}\uff0c\u8017\u65f6\uff1a{} ms", (Object)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")), (Object)(System.currentTimeMillis() - startTime));
    }
}

