/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.config.NasConfig;
import com.reportfrom.wapp.entity.AggrementRedJlEntity;
import com.reportfrom.wapp.entity.ReportAggrementEpdStatistic;
import com.reportfrom.wapp.mapper.first.ReportAggrementEpdStatisticMapper;
import com.reportfrom.wapp.quartz.ReportAggrementEpdStatisticQuartz;
import com.reportfrom.wapp.request.ReportAggrementEpdStatisticRequest;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.ReportAggrementEpdStatisticService;
import com.reportfrom.wapp.service.impl.ReportAggrementEpdStatisticServiceImpl;
import com.reportfrom.wapp.util.DateUtils;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import com.reportfrom.wapp.util.SFTPUtils;
import com.reportfrom.wapp.util.excelUtil.ExcelReturnInterface;
import com.reportfrom.wapp.util.excelUtil.XssfSheetReaderUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ReportAggrementEpdStatisticServiceImpl
extends ServiceImpl<ReportAggrementEpdStatisticMapper, ReportAggrementEpdStatistic>
implements ReportAggrementEpdStatisticService {
    private static final Logger log = LoggerFactory.getLogger(ReportAggrementEpdStatisticServiceImpl.class);
    @Autowired
    private ReportAggrementEpdStatisticMapper reportAggrementEpdStatisticMapper;
    @Autowired
    private ReportAggrementEpdStatisticQuartz reportAggrementEpdStatisticQuartz;
    @Autowired
    private NasConfig nasConfig;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;
    private ThreadPoolExecutor taskPool = new ThreadPoolExecutor(100, 100, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
    @Value(value="${quartz.AggrementReportQuartz.produce.pageSize}")
    int PAGE_SIZE = 1000;
    @Value(value="${quartz.AggrementReportQuartz.produce.maxPage}")
    int MAX_PAGE = 1000;

    private void queryCondition(Map<String, String> map, ReportAggrementEpdStatisticRequest params) {
        if (!StringUtils.isEmpty((String)params.getPostingDate())) {
            String[] postingDates = params.getPostingDate().split(",");
            map.put("startPostingDate", postingDates[0]);
            map.put("endPostingDate", postingDates[1]);
        }
        if (!StringUtils.isEmpty((String)params.getMixedDate())) {
            map.put("mixedDate", params.getMixedDate() + "%");
        }
        if (!StringUtils.isEmpty((String)params.getTextContent())) {
            map.put("textContent", this.handleName(params.getTextContent()));
        }
        if (!StringUtils.isEmpty((String)params.getCertificateTitle())) {
            map.put("certificateTitle", this.handleName(params.getCertificateTitle()));
        }
    }

    public PageUtils queryRAESPage(ReportAggrementEpdStatisticRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        this.queryCondition(map, params);
        Integer count = this.reportAggrementEpdStatisticMapper.selectAllCountByParam(map);
        List reportChcChecks = null;
        reportChcChecks = null != count && count > 0 ? this.reportAggrementEpdStatisticMapper.selectMapsByParams(map) : new ArrayList(0);
        this.dealResult(reportChcChecks);
        PageUtils rpage = new PageUtils();
        rpage.setList(reportChcChecks);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    private void dealResult(List<ReportAggrementEpdStatistic> list) {
        if (list != null && list.size() > 0) {
            for (ReportAggrementEpdStatistic r : list) {
                if (!StringUtils.isEmpty((String)r.getPaperDate())) {
                    r.setPaperDate(r.getPaperDate().substring(0, 6));
                }
                if (!StringUtils.isEmpty((String)r.getReverseDate())) {
                    r.setReverseDate(r.getReverseDate().substring(0, 6));
                }
                if (!StringUtils.isEmpty((String)r.getRePaperDate())) {
                    r.setRePaperDate(r.getRePaperDate().substring(0, 6));
                }
                if (!StringUtils.isEmpty((String)r.getReverseDateSecond())) {
                    r.setReverseDateSecond(r.getReverseDateSecond().substring(0, 6));
                }
                if (!StringUtils.isEmpty((String)r.getRePaperDateSecond())) {
                    r.setRePaperDateSecond(r.getRePaperDateSecond().substring(0, 6));
                }
                if (!StringUtils.isEmpty((String)r.getReverseDateThird())) {
                    r.setReverseDateThird(r.getReverseDateThird().substring(0, 6));
                }
                if (!StringUtils.isEmpty((String)r.getRePaperDateThird())) {
                    r.setRePaperDateThird(r.getRePaperDateThird().substring(0, 6));
                }
                if (!StringUtils.isEmpty((String)r.getDealDate())) {
                    r.setDealDate(r.getDealDate().substring(0, 6));
                }
                if (!StringUtils.isEmpty((String)r.getPpaPaperDate())) {
                    r.setPpaPaperDate(r.getPpaPaperDate().substring(0, 6));
                }
                if (!StringUtils.isEmpty((String)r.getPostingDate())) {
                    r.setPostingDate(LocalDate.parse(r.getPostingDate(), DateTimeFormatter.ofPattern("yyyyMMdd")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                }
                if (StringUtils.isEmpty((String)r.getCertificateNo()) || StringUtils.isEmpty((String)r.getReference()) || StringUtils.isEmpty((String)r.getPostingDate())) continue;
                r.setLinkIndex(r.getCertificateNo() + r.getReference() + ReportAggrementEpdStatisticServiceImpl.getExcelDateNum((String)r.getPostingDate(), (String)"yyyy-MM-dd"));
            }
        }
    }

    private static String getExcelDateNum(String date, String dateFmt) {
        LocalDate orignDate = LocalDate.parse("19000101", DateTimeFormatter.ofPattern("yyyyMMdd"));
        LocalDate postingDate = LocalDate.parse(date, DateTimeFormatter.ofPattern(dateFmt));
        return String.valueOf(orignDate.until(postingDate, ChronoUnit.DAYS) + 2L);
    }

    public void uploadMain(String filename, InputStream is, HttpServletResponse response, String token) {
        1 excelReturnInterface = new /* Unavailable Anonymous Inner Class!! */;
        try {
            long startTime = System.currentTimeMillis();
            log.info("\u534f\u8bae\u548cEPD\u7a0e\u52a1\u62a5\u8868\u4e3b\u4fe1\u606f\u5bfc\u5165\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a" + startTime);
            XssfSheetReaderUtils.startReadExcel((InputStream)is, (ExcelReturnInterface)excelReturnInterface, (Integer)1000, (Integer)1);
            long one = System.currentTimeMillis() - startTime;
            log.info("\u534f\u8bae\u548cEPD\u7a0e\u52a1\u62a5\u8868\u4e3b\u4fe1\u606f\u5bfc\u5165,\u8017\u65f6\uff1a" + one);
            String condition = JSON.toJSONString((Object)"params");
            String path = "upload";
            this.baseReportExportService.uploadExcel(token, condition, path, filename);
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6excel\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadTax(String filename, InputStream is, HttpServletResponse response, String token) {
        HashSet postDateMonthSet = new HashSet();
        2 excelReturnInterface = new /* Unavailable Anonymous Inner Class!! */;
        try {
            long startTime = System.currentTimeMillis();
            log.info("\u672a\u7ed3\u6b3e\u534f\u8bae\u7a0e\u91d1\u8868\u4fe1\u606f\u5bfc\u5165\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a" + startTime);
            XssfSheetReaderUtils.startReadExcel((InputStream)is, (ExcelReturnInterface)excelReturnInterface, (Integer)1000, (Integer)1);
            long one = System.currentTimeMillis() - startTime;
            log.info("\u672a\u7ed3\u6b3e\u534f\u8bae\u7a0e\u91d1\u8868\u4fe1\u606f\u5bfc\u5165,\u8017\u65f6\uff1a" + one);
            String condition = JSON.toJSONString((Object)"params");
            String path = "upload";
            this.baseReportExportService.uploadExcel(token, condition, path, filename);
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
        catch (Exception e) {
            try {
                log.error("\u8bfb\u53d6excel\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                e.printStackTrace();
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            }
            catch (Throwable throwable) {
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadCheckTaxAmount(String filename, InputStream is, HttpServletResponse response, String token) {
        HashSet postDateMonthSet = new HashSet();
        4 excelReturnInterface = new /* Unavailable Anonymous Inner Class!! */;
        try {
            long startTime = System.currentTimeMillis();
            log.info("\u8c03\u8d26\u7a0e\u989d\u8868\u4fe1\u606f\u5bfc\u5165\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a" + startTime);
            XssfSheetReaderUtils.startReadExcel((InputStream)is, (ExcelReturnInterface)excelReturnInterface, (Integer)1000, (Integer)1);
            long one = System.currentTimeMillis() - startTime;
            log.info("\u8c03\u8d26\u7a0e\u989d\u8868\u4fe1\u606f\u5bfc\u5165,\u8017\u65f6\uff1a" + one);
            String condition = JSON.toJSONString((Object)"params");
            String path = "upload";
            this.baseReportExportService.uploadExcel(token, condition, path, filename);
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
        catch (Exception e) {
            try {
                log.error("\u8bfb\u53d6excel\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                e.printStackTrace();
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            }
            catch (Throwable throwable) {
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                throw throwable;
            }
        }
    }

    private List<ReportAggrementEpdStatistic> taxAmountExcelToList(List<List<String>> rowList) {
        ArrayList<ReportAggrementEpdStatistic> list = new ArrayList<ReportAggrementEpdStatistic>();
        try {
            int rowLength = rowList.size();
            for (int i = 0; i < rowLength; ++i) {
                BigDecimal applyTaxAmount;
                BigDecimal checkBalanceTaxAmount;
                ReportAggrementEpdStatistic reportAggrementEpdStatistic = new ReportAggrementEpdStatistic();
                List<String> cellList = rowList.get(i);
                String certificateNo = cellList.get(0);
                reportAggrementEpdStatistic.setCertificateNo(certificateNo);
                String reference = cellList.get(1);
                reportAggrementEpdStatistic.setReference(reference);
                String postingDate = ReportAggrementEpdStatisticServiceImpl.getDateForFormat((String)cellList.get(2), (String)"yyyyMMdd");
                reportAggrementEpdStatistic.setPostingDate(postingDate);
                reportAggrementEpdStatistic.setLinkIndex(certificateNo + reference + postingDate);
                String checkBalanceTaxAmountStr = cellList.get(3);
                if (!StringUtils.isEmpty((String)checkBalanceTaxAmountStr) && StringUtils.isNumber((String)checkBalanceTaxAmountStr)) {
                    checkBalanceTaxAmount = new BigDecimal(checkBalanceTaxAmountStr);
                    reportAggrementEpdStatistic.setCheckBalanceTaxAmount(checkBalanceTaxAmount);
                } else {
                    checkBalanceTaxAmount = new BigDecimal(0);
                    reportAggrementEpdStatistic.setCheckBalanceTaxAmount(checkBalanceTaxAmount);
                }
                String applyTaxAmountStr = cellList.get(4);
                if (!StringUtils.isEmpty((String)applyTaxAmountStr) && StringUtils.isNumber((String)applyTaxAmountStr)) {
                    applyTaxAmount = new BigDecimal(applyTaxAmountStr);
                    reportAggrementEpdStatistic.setApplyTaxAmount(applyTaxAmount);
                } else {
                    applyTaxAmount = new BigDecimal(0);
                    reportAggrementEpdStatistic.setApplyTaxAmount(applyTaxAmount);
                }
                reportAggrementEpdStatistic.setDealDate(cellList.get(5));
                list.add(reportAggrementEpdStatistic);
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u8d26\u7a0e\u989d\u8868\u4fe1\u606f\u5bfc\u5165 - excel\u8f6cList\u5f02\u5e38:", (Throwable)e);
            e.printStackTrace();
        }
        return list;
    }

    private List<ReportAggrementEpdStatistic> taxExcelToList(List<List<String>> rowList) {
        ArrayList<ReportAggrementEpdStatistic> list = new ArrayList<ReportAggrementEpdStatistic>();
        try {
            int rowLength = rowList.size();
            for (int i = 0; i < rowLength; ++i) {
                BigDecimal unSettleAmount;
                ReportAggrementEpdStatistic reportAggrementEpdStatistic = new ReportAggrementEpdStatistic();
                List<String> cellList = rowList.get(i);
                String certificateNo = cellList.get(11);
                reportAggrementEpdStatistic.setCertificateNo(certificateNo);
                String reference = cellList.get(1);
                reportAggrementEpdStatistic.setReference(reference);
                String postingDate = ReportAggrementEpdStatisticServiceImpl.getDateForFormat((String)cellList.get(8), (String)"yyyyMMdd");
                reportAggrementEpdStatistic.setPostingDate(postingDate);
                reportAggrementEpdStatistic.setLinkIndex(certificateNo + reference + postingDate);
                String unSettleAmountStr = cellList.get(13);
                if (!StringUtils.isEmpty((String)unSettleAmountStr) && StringUtils.isNumber((String)unSettleAmountStr)) {
                    unSettleAmount = new BigDecimal(unSettleAmountStr);
                    reportAggrementEpdStatistic.setUnSettleAmount(unSettleAmount);
                } else {
                    unSettleAmount = new BigDecimal(0);
                    reportAggrementEpdStatistic.setUnSettleAmount(unSettleAmount);
                }
                list.add(reportAggrementEpdStatistic);
            }
        }
        catch (Exception e) {
            log.error("\u672a\u7ed3\u6b3e\u534f\u8bae\u7a0e\u91d1\u8868\u4fe1\u606f\u5bfc\u5165 - excel\u8f6cList\u5f02\u5e38:", (Throwable)e);
            e.printStackTrace();
        }
        return list;
    }

    private List<ReportAggrementEpdStatistic> mainExcelToList(List<List<String>> rowList) {
        ArrayList<ReportAggrementEpdStatistic> list = new ArrayList<ReportAggrementEpdStatistic>();
        try {
            for (int i = 0; i < rowList.size(); ++i) {
                BigDecimal taxAmount;
                BigDecimal standardCurrencyAmount;
                ReportAggrementEpdStatistic reportAggrementEpdStatistic = new ReportAggrementEpdStatistic();
                List<String> cellList = rowList.get(i);
                if (StringUtils.isEmpty((String)cellList.get(24)) || cellList.get(24).indexOf("EPD") != -1) continue;
                reportAggrementEpdStatistic.setCompanyCode(cellList.get(0));
                reportAggrementEpdStatistic.setSubject(cellList.get(1));
                reportAggrementEpdStatistic.setAllocation(cellList.get(2));
                reportAggrementEpdStatistic.setCertificateNo(cellList.get(3));
                reportAggrementEpdStatistic.setBusinessScope(cellList.get(4));
                reportAggrementEpdStatistic.setCertificateType(cellList.get(5));
                reportAggrementEpdStatistic.setPostingDate(ReportAggrementEpdStatisticServiceImpl.getDateForFormat((String)cellList.get(6), (String)"yyyyMMdd"));
                reportAggrementEpdStatistic.setCertificateDate(ReportAggrementEpdStatisticServiceImpl.getDateForFormat((String)cellList.get(7), (String)"yyyyMMdd"));
                reportAggrementEpdStatistic.setAccountingCode(cellList.get(8));
                String standardCurrencyAmountStr = cellList.get(9);
                if (!StringUtils.isEmpty((String)standardCurrencyAmountStr) && StringUtils.isNumber((String)standardCurrencyAmountStr)) {
                    standardCurrencyAmount = new BigDecimal(standardCurrencyAmountStr);
                    reportAggrementEpdStatistic.setStandardCurrencyAmount(standardCurrencyAmount);
                } else {
                    standardCurrencyAmount = new BigDecimal(0);
                    reportAggrementEpdStatistic.setStandardCurrencyAmount(standardCurrencyAmount);
                }
                reportAggrementEpdStatistic.setStandardCurrency(cellList.get(10));
                reportAggrementEpdStatistic.setTaxCode(cellList.get(11));
                reportAggrementEpdStatistic.setClearCertificate(cellList.get(12));
                reportAggrementEpdStatistic.setProfitCenter(cellList.get(13));
                reportAggrementEpdStatistic.setDuan(cellList.get(14));
                reportAggrementEpdStatistic.setTextContent(cellList.get(15));
                reportAggrementEpdStatistic.setReverseSubjectType(cellList.get(16));
                reportAggrementEpdStatistic.setReverseSubjectAccount(cellList.get(17));
                reportAggrementEpdStatistic.setPartner(cellList.get(18));
                reportAggrementEpdStatistic.setCertificateTitle(cellList.get(19));
                reportAggrementEpdStatistic.setReferenceCodeBt1(cellList.get(20));
                reportAggrementEpdStatistic.setReferenceCodeTt1(cellList.get(21));
                reportAggrementEpdStatistic.setReferenceCode1(cellList.get(22));
                reportAggrementEpdStatistic.setReferenceCode2(cellList.get(23));
                reportAggrementEpdStatistic.setReference(cellList.get(24));
                reportAggrementEpdStatistic.setInvoiceReference(cellList.get(25));
                reportAggrementEpdStatistic.setSapCertificateDate(cellList.get(26));
                reportAggrementEpdStatistic.setJudge(cellList.get(27));
                reportAggrementEpdStatistic.setDealMonth(cellList.get(28));
                String taxAmountStr = cellList.get(29);
                if (!StringUtils.isEmpty((String)taxAmountStr) && StringUtils.isNumber((String)taxAmountStr)) {
                    taxAmount = new BigDecimal(taxAmountStr);
                    reportAggrementEpdStatistic.setTaxAmount(taxAmount);
                } else {
                    taxAmount = new BigDecimal(0);
                    reportAggrementEpdStatistic.setTaxAmount(taxAmount);
                }
                reportAggrementEpdStatistic.setLinkIndex(reportAggrementEpdStatistic.getCertificateNo() + reportAggrementEpdStatistic.getReference() + reportAggrementEpdStatistic.getPostingDate());
                if (cellList.size() > 37) {
                    reportAggrementEpdStatistic.setPreSpeDrawFirst(cellList.get(37));
                }
                if (cellList.size() > 38) {
                    reportAggrementEpdStatistic.setPreAdjustmentTaxAmountFirst(cellList.get(38));
                }
                if (cellList.size() > 39) {
                    reportAggrementEpdStatistic.setPrePaperDateFirst(cellList.get(39));
                }
                if (cellList.size() > 40) {
                    reportAggrementEpdStatistic.setPreSpeDrawSecond(cellList.get(40));
                }
                if (cellList.size() > 41) {
                    reportAggrementEpdStatistic.setPreAdjustmentTaxAmountSecond(cellList.get(41));
                }
                if (cellList.size() > 42) {
                    reportAggrementEpdStatistic.setPrePaperDateSecond(cellList.get(42));
                }
                if (cellList.size() > 43) {
                    String epdRedTaxAmountStr = cellList.get(43);
                    if (!StringUtils.isEmpty((String)epdRedTaxAmountStr) && StringUtils.isNumber((String)epdRedTaxAmountStr)) {
                        BigDecimal epdRedTaxAmount = new BigDecimal(epdRedTaxAmountStr);
                        reportAggrementEpdStatistic.setEpdRedTaxAmount(epdRedTaxAmount);
                    } else {
                        reportAggrementEpdStatistic.setEpdRedTaxAmount(BigDecimal.ZERO);
                    }
                }
                if (cellList.size() > 44) {
                    String epdAdjustmentTaxAmountStr = cellList.get(44);
                    if (!StringUtils.isEmpty((String)epdAdjustmentTaxAmountStr) && StringUtils.isNumber((String)epdAdjustmentTaxAmountStr)) {
                        BigDecimal epdAdjustmentTaxAmount = new BigDecimal(epdAdjustmentTaxAmountStr);
                        reportAggrementEpdStatistic.setEpdAdjustmentTaxAmount(epdAdjustmentTaxAmount);
                    } else {
                        reportAggrementEpdStatistic.setEpdAdjustmentTaxAmount(BigDecimal.ZERO);
                    }
                }
                if (cellList.size() > 45) {
                    reportAggrementEpdStatistic.setEpdPaperDate(cellList.get(45));
                }
                if (cellList.size() > 46) {
                    String upgradesEpdRedTaxAmountStr = cellList.get(46);
                    if (!StringUtils.isEmpty((String)upgradesEpdRedTaxAmountStr) && StringUtils.isNumber((String)upgradesEpdRedTaxAmountStr)) {
                        BigDecimal upgradesEpdRedTaxAmount = new BigDecimal(upgradesEpdRedTaxAmountStr);
                        reportAggrementEpdStatistic.setUpgradesEpdRedTaxAmount(upgradesEpdRedTaxAmount);
                    } else {
                        reportAggrementEpdStatistic.setUpgradesEpdRedTaxAmount(BigDecimal.ZERO);
                    }
                }
                if (cellList.size() > 47) {
                    String upgradesEpdAdjustmentTaxAmountStr = cellList.get(47);
                    if (!StringUtils.isEmpty((String)upgradesEpdAdjustmentTaxAmountStr) && StringUtils.isNumber((String)upgradesEpdAdjustmentTaxAmountStr)) {
                        BigDecimal upgradesEpdAdjustmentTaxAmount = new BigDecimal(upgradesEpdAdjustmentTaxAmountStr);
                        reportAggrementEpdStatistic.setUpgradesEpdAdjustmentTaxAmount(upgradesEpdAdjustmentTaxAmount);
                    } else {
                        reportAggrementEpdStatistic.setUpgradesEpdAdjustmentTaxAmount(BigDecimal.ZERO);
                    }
                }
                if (cellList.size() > 48) {
                    reportAggrementEpdStatistic.setUpgradesEpdPaperDate(cellList.get(48));
                }
                if (cellList.size() > 49) {
                    reportAggrementEpdStatistic.setPreEpdSpeDraw(cellList.get(49));
                }
                if (cellList.size() > 50) {
                    reportAggrementEpdStatistic.setPreEpdAdjustmentTaxAmount(cellList.get(50));
                }
                if (cellList.size() > 51) {
                    reportAggrementEpdStatistic.setPreEpdPaperDate(cellList.get(51));
                }
                if (cellList.size() > 52) {
                    reportAggrementEpdStatistic.setPpa(cellList.get(52));
                }
                if (cellList.size() > 53) {
                    reportAggrementEpdStatistic.setPpaAdjustmentTaxAmount(cellList.get(53));
                }
                if (cellList.size() > 54) {
                    reportAggrementEpdStatistic.setPpaPaperDate(cellList.get(54));
                }
                if (cellList.size() > 60) {
                    reportAggrementEpdStatistic.setCkBkAmount(cellList.get(60));
                }
                if (cellList.size() > 61) {
                    reportAggrementEpdStatistic.setHAdjustmentTaxAmount(cellList.get(61));
                }
                if (cellList.size() > 62) {
                    reportAggrementEpdStatistic.setHPaperDate(cellList.get(62));
                }
                list.add(reportAggrementEpdStatistic);
            }
        }
        catch (Exception e) {
            log.error("\u534f\u8bae\u548cEPD\u7a0e\u52a1\u62a5\u8868\u4e3b\u4fe1\u606f\u5bfc\u5165 - excel\u8f6cList\u5f02\u5e38:", (Throwable)e);
            e.printStackTrace();
        }
        return list;
    }

    public int queryRAESCount(ReportAggrementEpdStatisticRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        Integer count = this.reportAggrementEpdStatisticMapper.selectAllCountByParam(map);
        return count;
    }

    public void produceReportAES(ReportAggrementEpdStatisticRequest params, String token) {
        String downLoadfileName = "\u534f\u8bae\u7a0e\u52a1\u62a5\u8868_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS"));
        String uploadfileName = "produceReportAES-" + DateUtils.getStringDateShort();
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        this.queryCondition(map, params);
        List voList = this.reportAggrementEpdStatisticMapper.selectMapsByParams(map);
        this.dealResult(voList);
        String path = this.nasConfig.getUrl();
        ExcelUtils.createExcel((List)voList, (String)ExcelTypeConfig.REPORT_AGGREMENT_EPD_STATISTIC_QUERY, (String)uploadfileName, (String)path);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, downLoadfileName, uploadfileName);
    }

    private static String getCellValueByType(Cell cell, Boolean flag) {
        String returnValue = null;
        if (cell == null) {
            returnValue = "";
        } else {
            switch (6.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellTypeEnum().ordinal()]) {
                case 1: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = cell.getDateCellValue();
                        returnValue = DateUtils.format((Date)date, (String)"yyyyMMdd");
                        break;
                    }
                    double numericCellValue = cell.getNumericCellValue();
                    if (Double.isNaN(numericCellValue)) break;
                    if (flag.booleanValue()) {
                        long round = Math.round(cell.getNumericCellValue());
                        returnValue = round + "";
                        break;
                    }
                    returnValue = numericCellValue + "";
                    break;
                }
                case 2: {
                    returnValue = cell.getStringCellValue();
                    break;
                }
            }
        }
        return returnValue;
    }

    private static String getCellValueByType(Cell cell) {
        return ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)cell, (Boolean)false);
    }

    public int updateAggrementRedTaxAmount(String lastMonth) {
        return this.reportAggrementEpdStatisticMapper.updateAggrementRedTaxAmount(lastMonth);
    }

    public int updateEpdRedTaxAmount(String lastMonth) {
        return this.reportAggrementEpdStatisticMapper.updateEpdRedTaxAmount(lastMonth);
    }

    public int updateUnInvoiceAmount(String lastMonth) {
        return this.reportAggrementEpdStatisticMapper.updateUnInvoiceAmount(lastMonth);
    }

    public int updateBlueOffsetAmount(String lastMonth) {
        return this.reportAggrementEpdStatisticMapper.updateBlueOffsetAmount(lastMonth);
    }

    public int updateBalance(String lastMonth) {
        return this.reportAggrementEpdStatisticMapper.updateBalance(lastMonth);
    }

    public int updateDifferenceAmount(String lastMonth) {
        return this.reportAggrementEpdStatisticMapper.updateDifferenceAmount(lastMonth);
    }

    public int updateFirstReverse(String lastMonth) {
        return this.reportAggrementEpdStatisticMapper.updateFirstReverse(lastMonth);
    }

    public int updateFirstReopen(String lastMonth) {
        return this.reportAggrementEpdStatisticMapper.updateFirstReopen(lastMonth);
    }

    public int updateSecondReverse(String lastMonth) {
        return this.reportAggrementEpdStatisticMapper.updateSecondReverse(lastMonth);
    }

    public int updateSecondReopen(String lastMonth) {
        return this.reportAggrementEpdStatisticMapper.updateSecondReopen(lastMonth);
    }

    public int updateThirdReverse(String lastMonth) {
        return this.reportAggrementEpdStatisticMapper.updateThirdReverse(lastMonth);
    }

    public int updateThirdReopen(String lastMonth) {
        return this.reportAggrementEpdStatisticMapper.updateThirdReopen(lastMonth);
    }

    public int updateNull(String lastMonth) {
        return this.reportAggrementEpdStatisticMapper.updateNull(lastMonth);
    }

    private static String getDateForFormat(String dateStr, String targetFormat) {
        if (!StringUtils.isEmpty((String)dateStr) && dateStr.matches("\\d{4}[-/]\\d{1,2}[-/]\\d{1,2}")) {
            if (dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2}")) {
                return LocalDate.parse(dateStr, DateTimeFormatter.ofPattern("yyyy-M-d")).format(DateTimeFormatter.ofPattern(targetFormat));
            }
            if (dateStr.matches("\\d{4}/\\d{1,2}/\\d{1,2}")) {
                return LocalDate.parse(dateStr, DateTimeFormatter.ofPattern("yyyy/M/d")).format(DateTimeFormatter.ofPattern(targetFormat));
            }
        } else {
            if (!StringUtils.isEmpty((String)dateStr) && dateStr.matches("\\d{1,2}/\\d{1,2}/\\d{2}")) {
                return LocalDate.parse(dateStr, DateTimeFormatter.ofPattern("M/d/yy")).format(DateTimeFormatter.ofPattern(targetFormat));
            }
            if (!StringUtils.isEmpty((String)dateStr) && dateStr.matches("\\d{8}")) {
                return dateStr;
            }
            if (StringUtils.isNumber((String)dateStr) && dateStr.matches("\\d{5,6}(.0)?")) {
                return LocalDate.parse("19000101", DateTimeFormatter.ofPattern("yyyyMMdd")).minusDays(2 - (int)Double.parseDouble(dateStr)).format(DateTimeFormatter.ofPattern(targetFormat));
            }
        }
        return dateStr;
    }

    public static void main(String[] args) {
        System.out.println(ReportAggrementEpdStatisticServiceImpl.getDateForFormat((String)"2022-06-06", (String)"yyyyMMdd"));
    }

    private String handleName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        return "%" + name.replace("_", "[_]").replace("%", "[%]").replace("[", "[[]").replace("^", "[^]") + "%";
    }

    public List<String> getCalcPostDate(String yesterday) {
        return this.reportAggrementEpdStatisticMapper.getCalcPostDate(yesterday);
    }

    public int updateBillDeduct(String lastMonth) {
        return this.reportAggrementEpdStatisticMapper.updateBillDeduct(lastMonth);
    }

    public List<AggrementRedJlEntity> getRedLog(List<String> reportIds) {
        return this.reportAggrementEpdStatisticMapper.getRedLog(reportIds);
    }

    public List<AggrementRedJlEntity> getRedLetterLog(List<String> reportIds) {
        return this.reportAggrementEpdStatisticMapper.getRedLetterLog(reportIds);
    }

    public int updateCxCk(List<ReportAggrementEpdStatistic> r) {
        return this.reportAggrementEpdStatisticMapper.updateCxCk(r);
    }

    public List<String> getReportIds(String lastMonth) {
        return this.reportAggrementEpdStatisticMapper.getReportIds(lastMonth);
    }

    public void produceAggrementReport(String period) {
        try {
            SXSSFWorkbook workbook = null;
            CellStyle cellStyle = null;
            String downloadFilename = null;
            SXSSFSheet sheet = null;
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("period", period);
            paramMap.put("pageSize", this.PAGE_SIZE);
            int currExcelCount = 0;
            int nextExcelCount = 1;
            int count = this.reportAggrementEpdStatisticMapper.selectReportAggrementCount(paramMap);
            int totalPage = (count + this.PAGE_SIZE - 1) / this.PAGE_SIZE;
            for (int page = 1; page <= totalPage || totalPage == 0; ++page) {
                paramMap.put("currPage", page);
                List voList = null;
                voList = count > 0 ? this.reportAggrementEpdStatisticMapper.selectReportAggrement(paramMap) : new ArrayList();
                this.dealResult(voList);
                if (currExcelCount != nextExcelCount && (currExcelCount <= 0 || voList != null && voList.size() != 0)) {
                    ++currExcelCount;
                    workbook = new SXSSFWorkbook(5000);
                    workbook.setCompressTempFiles(false);
                    sheet = workbook.createSheet();
                    cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor(IndexedColors.LIGHT_ORANGE.getIndex());
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    ExcelUtils.reportAESTitle((Sheet)sheet, (CellStyle)cellStyle);
                    downloadFilename = this.PAGE_SIZE * this.MAX_PAGE <= count ? "\u534f\u8bae\u7a0e\u52a1\u62a5\u8868_" + period + "_" + currExcelCount + ".xlsx" : "\u534f\u8bae\u7a0e\u52a1\u62a5\u8868_" + period + ".xlsx";
                }
                ExcelUtils.reportAESCell((int)((page - 1) * this.PAGE_SIZE + 1 - (currExcelCount - 1) * this.PAGE_SIZE * this.MAX_PAGE), (Sheet)sheet, voList, (CellStyle)cellStyle);
                if (page % this.MAX_PAGE == 0 || voList == null || voList.size() < this.PAGE_SIZE) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    workbook.write((OutputStream)out);
                    ByteArrayInputStream is = new ByteArrayInputStream(out.toByteArray());
                    out.flush();
                    out.close();
                    String path = this.ftpConfig.getServerSavePath();
                    log.info("Excel\u6587\u4ef6\u751f\u6210\u6210\u529f,\u5f00\u59cbftp\u4e0a\u4f20\u6587\u4ef6\uff0cfileName={},servicePath={}>>>>>", (Object)downloadFilename, (Object)path);
                    SFTPUtils sftp = SFTPUtils.getInstance();
                    boolean upload = sftp.upload(path, downloadFilename, (InputStream)is);
                    log.info("ftp\u4e0a\u4f20\u7ed3\u679c\uff1a{}", (Object)upload);
                    ++nextExcelCount;
                }
                if (voList != null && voList.size() >= this.PAGE_SIZE) continue;
                return;
            }
        }
        catch (Exception e) {
            log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u5b9a\u671f\u751f\u6210\u62a5\u8868\u5f02\u5e38", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    static /* synthetic */ List access$000(ReportAggrementEpdStatisticServiceImpl x0, List x1) {
        return x0.mainExcelToList(x1);
    }

    static /* synthetic */ ThreadPoolExecutor access$100(ReportAggrementEpdStatisticServiceImpl x0) {
        return x0.taskPool;
    }

    static /* synthetic */ List access$200(ReportAggrementEpdStatisticServiceImpl x0, List x1) {
        return x0.taxExcelToList(x1);
    }

    static /* synthetic */ Logger access$300() {
        return log;
    }

    static /* synthetic */ ReportAggrementEpdStatisticMapper access$400(ReportAggrementEpdStatisticServiceImpl x0) {
        return x0.reportAggrementEpdStatisticMapper;
    }

    static /* synthetic */ ReportAggrementEpdStatisticQuartz access$500(ReportAggrementEpdStatisticServiceImpl x0) {
        return x0.reportAggrementEpdStatisticQuartz;
    }

    static /* synthetic */ List access$600(ReportAggrementEpdStatisticServiceImpl x0, List x1) {
        return x0.taxAmountExcelToList(x1);
    }
}

