/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.config.NasConfig;
import com.reportfrom.wapp.entity.TXfRedLetter;
import com.reportfrom.wapp.entity.TXfRedNotification;
import com.reportfrom.wapp.entityEnum.AllType;
import com.reportfrom.wapp.entityVO.RedPurcherDetailVO;
import com.reportfrom.wapp.entityVO.RedPurcherHistoryVO;
import com.reportfrom.wapp.entityVO.RedPurcherMsgCollectVO;
import com.reportfrom.wapp.mapper.first.TXfRedLetterMapper;
import com.reportfrom.wapp.mapper.first.TXfRedNotificationMapper;
import com.reportfrom.wapp.nasFile.FileServiceUtil;
import com.reportfrom.wapp.request.RedNotificationDetailReq;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.TXfRedNotificationService;
import com.reportfrom.wapp.util.DateUtils;
import com.reportfrom.wapp.util.PageUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TXfRedNotificationServiceImpl
extends ServiceImpl<TXfRedNotificationMapper, TXfRedNotification>
implements TXfRedNotificationService {
    private static final Logger log = LoggerFactory.getLogger(TXfRedNotificationServiceImpl.class);
    public static String[] TITLE_LIST = new String[]{"\u4e1a\u52a1\u7c7b\u578b", "\u529e\u7406\u7ea2\u7968\u65f6\u95f4", "\u4f9b\u5e94\u5546\u53f7\u7801\uff086D\uff09", "\u4f9b\u5e94\u5546\u540d\u79f0", "\u4f9b\u5e94\u5546\u7a0e\u53f7", "\u7d22\u8d54\u53f7/\u534f\u8bae\u53f7", "\u7ed3\u7b97\u5355\u53f7", "\u8d26\u6263\u84dd\u7968\u53f7\u7801", "\u51ed\u8bc1\u53f7", "\u8fc7\u8d26\u65f6\u95f4", "\u5165\u8d26\u7a0e\u7387", "\u529e\u7406\u7ea2\u7968\u91d1\u989d", "\u529e\u7406\u7ea2\u7968\u7a0e\u7387", "\u529e\u7406\u7ea2\u7968\u7a0e\u989d", "\u7a0e\u5dee"};
    public static String[] RE_TITLE_LIST = new String[]{"\u4e1a\u52a1\u7c7b\u578b", "\u64a4\u9500\u7ea2\u7968\u65f6\u95f4", "\u4f9b\u5e94\u5546\u53f7\u7801\uff086D\uff09", "\u4f9b\u5e94\u5546\u540d\u79f0", "\u4f9b\u5e94\u5546\u7a0e\u53f7", "\u7d22\u8d54\u53f7/\u534f\u8bae\u53f7", "\u7ed3\u7b97\u5355\u53f7", "\u8d26\u6263\u84dd\u7968\u53f7\u7801", "\u51ed\u8bc1\u53f7", "\u8fc7\u8d26\u65f6\u95f4", "\u5165\u8d26\u7a0e\u7387", "\u64a4\u9500\u7ea2\u7968\u91d1\u989d", "\u64a4\u9500\u7ea2\u7968\u7a0e\u7387", "\u64a4\u9500\u7ea2\u7968\u7a0e\u989d", "\u7a0e\u5dee", "\u64a4\u9500\u7ea2\u7968\u539f\u56e0"};
    public static String[] RE_TITLE_HISTORY_LIST = new String[]{"\u4e1a\u52a1\u7c7b\u578b", "\u64a4\u9500\u7ea2\u7968\u65f6\u95f4", "\u4f9b\u5e94\u5546\u53f7\u7801\uff086D\uff09", "\u4f9b\u5e94\u5546\u540d\u79f0", "\u4f9b\u5e94\u5546\u7a0e\u53f7", "\u7d22\u8d54\u53f7/\u534f\u8bae\u53f7", "\u7ed3\u7b97\u5355\u53f7", "\u8d26\u6263\u84dd\u7968\u53f7\u7801", "\u51ed\u8bc1\u53f7", "\u8fc7\u8d26\u65f6\u95f4", "\u5165\u8d26\u7a0e\u7387", "\u7ea2\u5b57\u4fe1\u606f\u7f16\u53f7", "\u64a4\u9500\u7ea2\u7968\u91d1\u989d", "\u64a4\u9500\u7ea2\u7968\u7a0e\u7387", "\u64a4\u9500\u7ea2\u7968\u7a0e\u989d", "\u64a4\u9500\u7ea2\u7968\u539f\u56e0", "\u7a0e\u5dee"};
    @Autowired
    private TXfRedNotificationMapper tXfRedNotificationMapper;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;
    @Autowired
    private NasConfig nasConfig;
    @Autowired
    private TXfRedLetterMapper tXfRedLetterMapper;

    private static void createSheet3(SXSSFWorkbook workbook, List<RedPurcherHistoryVO> voList, CellStyle titleCell) {
        int i;
        SXSSFSheet sheetAt = workbook.createSheet("CHC\u8fdb\u9879\u7ea2\u7968\u64a4\u9500\u6e05\u5355(\u5386\u53f2)");
        SXSSFRow row = sheetAt.createRow(0);
        List<String> strings = Arrays.asList(RE_TITLE_HISTORY_LIST);
        for (i = 0; i < strings.size(); ++i) {
            SXSSFCell cell = row.createCell(i);
            cell.setCellValue(strings.get(i));
            cell.setCellStyle(titleCell);
        }
        for (i = 0; i < voList.size(); ++i) {
            SXSSFRow row1 = sheetAt.createRow(i + 1);
            row1.createCell(0).setCellValue(AllType.ChcBusinessTypeEnum.getMsgByCode((String)voList.get(i).getBusinessType()));
            row1.createCell(1).setCellValue(voList.get(i).getCancelTime());
            row1.createCell(2).setCellValue(voList.get(i).getSellerNo());
            row1.createCell(3).setCellValue(voList.get(i).getSellerName());
            row1.createCell(4).setCellValue(voList.get(i).getSellerTaxNo());
            row1.createCell(5).setCellValue(voList.get(i).getBusinessNo());
            row1.createCell(6).setCellValue(voList.get(i).getSettlementNo());
            row1.createCell(7).setCellValue(voList.get(i).getDeductInvoice());
            row1.createCell(8).setCellValue(voList.get(i).getAgreementDocumentNumber());
            row1.createCell(9).setCellValue(voList.get(i).getDeductDate());
            row1.createCell(10).setCellValue(voList.get(i).getMainTaxRate() == null ? "" : voList.get(i).getMainTaxRate() + "");
            row1.createCell(11).setCellValue(voList.get(i).getRedNotificationNo());
            row1.createCell(12).setCellValue(voList.get(i).getItemAmountWithoutTax() == null ? "0" : voList.get(i).getItemAmountWithoutTax() + "");
            row1.createCell(13).setCellValue(voList.get(i).getItemTaxRate() == null ? "" : voList.get(i).getItemTaxRate() + "");
            row1.createCell(14).setCellValue(voList.get(i).getItemTaxAmount() == null ? "0" : voList.get(i).getItemTaxAmount() + "");
            row1.createCell(15).setCellValue(voList.get(i).getRevertRemark());
        }
    }

    private static void createSheet2(SXSSFWorkbook workbook, List<RedPurcherDetailVO> voList, CellStyle titleCell) {
        int i;
        SXSSFSheet sheetAt = workbook.createSheet("CHC\u8fdb\u9879\u7ea2\u7968\u64a4\u9500\u6e05\u5355");
        SXSSFRow row = sheetAt.createRow(0);
        List<String> strings = Arrays.asList(RE_TITLE_LIST);
        for (i = 0; i < strings.size(); ++i) {
            SXSSFCell cell = row.createCell(i);
            cell.setCellValue(strings.get(i));
            cell.setCellStyle(titleCell);
        }
        for (i = 0; i < voList.size(); ++i) {
            SXSSFRow row1 = sheetAt.createRow(i + 1);
            row1.createCell(0).setCellValue(AllType.ChcBusinessTypeEnum.getMsgByCode((String)voList.get(i).getBusinessType()));
            row1.createCell(1).setCellValue(voList.get(i).getCancelTime());
            row1.createCell(2).setCellValue(voList.get(i).getSellerNo());
            row1.createCell(3).setCellValue(voList.get(i).getSellerName());
            row1.createCell(4).setCellValue(voList.get(i).getSellerTaxNo());
            row1.createCell(5).setCellValue(voList.get(i).getBusinessNo());
            row1.createCell(6).setCellValue(voList.get(i).getSettlementNo());
            row1.createCell(7).setCellValue(voList.get(i).getDeductInvoice());
            row1.createCell(8).setCellValue(voList.get(i).getAgreementDocumentNumber());
            row1.createCell(9).setCellValue(voList.get(i).getDeductDate());
            row1.createCell(10).setCellValue(voList.get(i).getMainTaxRate() == null ? "0" : voList.get(i).getMainTaxRate() + "");
            row1.createCell(11).setCellValue(voList.get(i).getItemAmountWithoutTax() == null ? "0" : voList.get(i).getItemAmountWithoutTax() + "");
            row1.createCell(12).setCellValue(voList.get(i).getItemTaxRate() == null ? "0" : voList.get(i).getItemTaxRate() + "");
            row1.createCell(13).setCellValue(voList.get(i).getItemTaxAmount() == null ? "0" : voList.get(i).getItemTaxAmount() + "");
            row1.createCell(14).setCellValue(voList.get(i).getTaxBlance() == null ? "0" : voList.get(i).getTaxBlance() + "");
            row1.createCell(15).setCellValue(voList.get(i).getRevertRemark());
        }
    }

    private static void createSheet1(SXSSFWorkbook workbook, List<RedPurcherDetailVO> voList, CellStyle titleCell) {
        int i;
        SXSSFSheet sheetAt = workbook.createSheet("CHC\u8fdb\u9879\u7ea2\u7968\u529e\u7406\u6e05\u5355");
        SXSSFRow row = sheetAt.createRow(0);
        List<String> strings = Arrays.asList(TITLE_LIST);
        for (i = 0; i < strings.size(); ++i) {
            SXSSFCell cell = row.createCell(i);
            cell.setCellValue(strings.get(i));
            cell.setCellStyle(titleCell);
        }
        for (i = 0; i < voList.size(); ++i) {
            SXSSFRow row1 = sheetAt.createRow(i + 1);
            row1.createCell(0).setCellValue(AllType.ChcBusinessTypeEnum.getMsgByCode((String)voList.get(i).getBusinessType()));
            row1.createCell(1).setCellValue(voList.get(i).getInvoiceDate());
            row1.createCell(2).setCellValue(voList.get(i).getSellerNo());
            row1.createCell(3).setCellValue(voList.get(i).getSellerName());
            row1.createCell(4).setCellValue(voList.get(i).getSellerTaxNo());
            row1.createCell(5).setCellValue(voList.get(i).getBusinessNo());
            row1.createCell(6).setCellValue(voList.get(i).getSettlementNo());
            row1.createCell(7).setCellValue(voList.get(i).getDeductInvoice());
            row1.createCell(8).setCellValue(voList.get(i).getAgreementDocumentNumber());
            row1.createCell(9).setCellValue(voList.get(i).getDeductDate());
            row1.createCell(10).setCellValue(voList.get(i).getMainTaxRate() == null ? "0" : voList.get(i).getMainTaxRate() + "");
            row1.createCell(11).setCellValue(voList.get(i).getItemAmountWithoutTax() == null ? "0" : voList.get(i).getItemAmountWithoutTax() + "");
            row1.createCell(12).setCellValue(voList.get(i).getItemTaxRate() == null ? "0" : voList.get(i).getItemTaxRate() + "");
            row1.createCell(13).setCellValue(voList.get(i).getItemTaxAmount() == null ? "0" : voList.get(i).getItemTaxAmount() + "");
            row1.createCell(14).setCellValue(voList.get(i).getTaxBlance() == null ? "0" : voList.get(i).getTaxBlance() + "");
        }
    }

    public void createChcRedNotification(RedPurcherMsgCollectVO vo, List<RedPurcherDetailVO> voList, List<RedPurcherDetailVO> voReList, List<RedPurcherHistoryVO> historyList, String fileName, String path) {
        try {
            SXSSFWorkbook workbook = new SXSSFWorkbook(5000);
            workbook.setCompressTempFiles(false);
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setFillForegroundColor(IndexedColors.LIGHT_ORANGE.getIndex());
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            TXfRedNotificationServiceImpl.createSheet0((SXSSFWorkbook)workbook, (RedPurcherMsgCollectVO)vo, (CellStyle)cellStyle);
            TXfRedNotificationServiceImpl.createSheet1((SXSSFWorkbook)workbook, voList, (CellStyle)cellStyle);
            TXfRedNotificationServiceImpl.createSheet2((SXSSFWorkbook)workbook, voReList, (CellStyle)cellStyle);
            TXfRedNotificationServiceImpl.createSheet3((SXSSFWorkbook)workbook, historyList, (CellStyle)cellStyle);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            out.flush();
            out.close();
            log.info("Excel\u6587\u4ef6\u751f\u6210\u6210\u529f,\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6\u81f3NAS\uff0cfileName={},servicePath={}>>>>>", (Object)(fileName + ".xlsx"), (Object)path);
            String vid = FileServiceUtil.uploadFile((byte[])out.toByteArray(), (String)fileName, (String)this.nasConfig.getUrl());
            log.info("ftp\u4e0a\u4f20\u7ed3\u679c\uff1a{}", (Object)vid);
        }
        catch (Exception e) {
            log.error("\u9519\u8bef\u4fe1\u606f\uff1a{}", (Throwable)e);
        }
    }

    private static void createSheet0(SXSSFWorkbook workbook, RedPurcherMsgCollectVO vo, CellStyle titleCell) {
        titleCell.setAlignment(HorizontalAlignment.CENTER_SELECTION);
        titleCell.setBorderBottom(BorderStyle.THIN);
        titleCell.setBorderLeft(BorderStyle.THIN);
        titleCell.setBorderRight(BorderStyle.THIN);
        titleCell.setBorderTop(BorderStyle.THIN);
        SXSSFSheet sheetAt = workbook.createSheet("\u7edf\u8ba1");
        for (int i = 0; i < 14; ++i) {
            SXSSFCell cell;
            SXSSFCell cell5;
            SXSSFCell cell4;
            SXSSFCell cell3;
            SXSSFCell tcell2;
            SXSSFCell tcell1;
            SXSSFCell tcell;
            SXSSFCell cell32;
            SXSSFCell cell2;
            SXSSFCell cell1;
            CellRangeAddress region3;
            CellRangeAddress region2;
            CellRangeAddress region1;
            SXSSFCell cell6;
            CellRangeAddress region;
            sheetAt.setColumnWidth(i, 6000);
            SXSSFRow row = sheetAt.createRow(i);
            if (i == 0) {
                region = new CellRangeAddress(i, i + 1, 0, 0);
                sheetAt.addMergedRegion(region);
                cell6 = row.createCell(0);
                cell6.setCellValue("\u529e\u7406\u7ea2\u7968\u4fe1\u606f\u8868\u7c7b\u522b");
                cell6.setCellStyle(titleCell);
                region1 = new CellRangeAddress(i, i, 1, 2);
                sheetAt.addMergedRegion(region1);
                region2 = new CellRangeAddress(i, i, 3, 4);
                sheetAt.addMergedRegion(region2);
                region3 = new CellRangeAddress(i, i, 5, 6);
                sheetAt.addMergedRegion(region3);
                cell1 = row.createCell(1);
                cell1.setCellValue("\u5f53\u6708\u5df2\u529e\u7406\u7ea2\u7968\u4fe1\u606f\u8868\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09");
                cell1.setCellStyle(titleCell);
                cell2 = row.createCell(3);
                cell2.setCellValue("\u5f53\u6708\u5df2\u529e\u7406\u7ea2\u7968\u4fe1\u606f\u8868\u7a0e\u989d");
                cell2.setCellStyle(titleCell);
                cell32 = row.createCell(5);
                cell32.setCellValue("\u529e\u7406\u7ea2\u7968\u7684\u7a0e\u5dee");
                cell32.setCellStyle(titleCell);
            }
            if (i == 1) {
                tcell = row.createCell(1);
                tcell.setCellValue("before");
                tcell.setCellStyle(titleCell);
                tcell1 = row.createCell(2);
                tcell1.setCellValue("after");
                tcell1.setCellStyle(titleCell);
                tcell2 = row.createCell(3);
                tcell2.setCellValue("before");
                tcell2.setCellStyle(titleCell);
                cell3 = row.createCell(4);
                cell3.setCellValue("after");
                cell3.setCellStyle(titleCell);
                cell4 = row.createCell(5);
                cell4.setCellValue("before");
                cell4.setCellStyle(titleCell);
                cell5 = row.createCell(6);
                cell5.setCellValue("after");
                cell5.setCellStyle(titleCell);
            }
            if (i == 2) {
                cell = row.createCell(0);
                cell.setCellValue("\u7d22\u8d54-\u7a0e\u63a7");
                cell.setCellStyle(titleCell);
                row.createCell(2).setCellValue(vo.getApplyingMsg().getClaimWithoutTaxAmountAfter());
                row.createCell(4).setCellValue(vo.getApplyingMsg().getClaimTaxAmountAfter());
                row.createCell(6).setCellValue(vo.getApplyingMsg().getClaimGapAfter());
            }
            if (i == 3) {
                cell = row.createCell(0);
                cell.setCellValue("\u7d22\u8d54-\u6570\u7535");
                cell.setCellStyle(titleCell);
                row.createCell(2).setCellValue(vo.getLetterMsg().getClaimWithoutTaxAmountAfter());
                row.createCell(4).setCellValue(vo.getLetterMsg().getClaimTaxAmountAfter());
                row.createCell(6).setCellValue(vo.getLetterMsg().getClaimGapAfter());
            }
            if (i == 4) {
                cell = row.createCell(0);
                cell.setCellValue("\u534f\u8bae-\u7a0e\u63a7");
                cell.setCellStyle(titleCell);
                row.createCell(1).setCellValue(vo.getApplyingMsg().getAggrementWithoutTaxAmountBefore());
                row.createCell(2).setCellValue(vo.getApplyingMsg().getAggrementWithoutTaxAmountAfter());
                row.createCell(3).setCellValue(vo.getApplyingMsg().getAggrementTaxAmountBefore());
                row.createCell(4).setCellValue(vo.getApplyingMsg().getAggrementTaxAmountAfter());
                row.createCell(5).setCellValue(vo.getApplyingMsg().getAggrementGapBefore());
                row.createCell(6).setCellValue(vo.getApplyingMsg().getAggrementGapAfter());
            }
            if (i == 5) {
                cell = row.createCell(0);
                cell.setCellValue("\u534f\u8bae-\u6570\u7535");
                cell.setCellStyle(titleCell);
                row.createCell(1).setCellValue(vo.getLetterMsg().getAggrementWithoutTaxAmountBefore());
                row.createCell(2).setCellValue(vo.getLetterMsg().getAggrementWithoutTaxAmountAfter());
                row.createCell(3).setCellValue(vo.getLetterMsg().getAggrementTaxAmountBefore());
                row.createCell(4).setCellValue(vo.getLetterMsg().getAggrementTaxAmountAfter());
                row.createCell(5).setCellValue(vo.getLetterMsg().getAggrementGapBefore());
                row.createCell(6).setCellValue(vo.getLetterMsg().getAggrementGapAfter());
            }
            if (i == 6) {
                cell = row.createCell(0);
                cell.setCellValue("\u5176\u4ed6-\u7a0e\u63a7");
                cell.setCellStyle(titleCell);
                row.createCell(2).setCellValue(vo.getApplyingMsg().getOtherWithoutTaxAmountAfter());
                row.createCell(4).setCellValue(vo.getApplyingMsg().getOtherTaxAmountAfter());
            }
            if (i == 7) {
                cell = row.createCell(0);
                cell.setCellValue("\u5176\u4ed6-\u6570\u7535");
                cell.setCellStyle(titleCell);
                row.createCell(2).setCellValue(vo.getLetterMsg().getOtherWithoutTaxAmountAfter());
                row.createCell(4).setCellValue(vo.getLetterMsg().getOtherTaxAmountAfter());
            }
            if (i == 9) {
                region = new CellRangeAddress(i, i + 1, 0, 0);
                sheetAt.addMergedRegion(region);
                cell6 = row.createCell(0);
                cell6.setCellValue("\u64a4\u9500\u7ea2\u7968\u4fe1\u606f\u8868\u7c7b\u522b");
                cell6.setCellStyle(titleCell);
                region1 = new CellRangeAddress(i, i, 1, 2);
                sheetAt.addMergedRegion(region1);
                region2 = new CellRangeAddress(i, i, 3, 4);
                sheetAt.addMergedRegion(region2);
                region3 = new CellRangeAddress(i, i, 5, 6);
                sheetAt.addMergedRegion(region3);
                cell1 = row.createCell(1);
                cell1.setCellValue("\u5f53\u6708\u5df2\u64a4\u9500\u7ea2\u7968\u4fe1\u606f\u8868\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09");
                cell1.setCellStyle(titleCell);
                cell2 = row.createCell(3);
                cell2.setCellValue("\u5f53\u6708\u5df2\u64a4\u9500\u7ea2\u7968\u4fe1\u606f\u8868\u7a0e\u989d");
                cell2.setCellStyle(titleCell);
                cell32 = row.createCell(5);
                cell32.setCellValue("\u64a4\u9500\u7ea2\u7968\u7684\u7a0e\u5dee");
                cell32.setCellStyle(titleCell);
            }
            if (i == 10) {
                tcell = row.createCell(1);
                tcell.setCellValue("before");
                tcell.setCellStyle(titleCell);
                tcell1 = row.createCell(2);
                tcell1.setCellValue("after");
                tcell1.setCellStyle(titleCell);
                tcell2 = row.createCell(3);
                tcell2.setCellValue("before");
                tcell2.setCellStyle(titleCell);
                cell3 = row.createCell(4);
                cell3.setCellValue("after");
                cell3.setCellStyle(titleCell);
                cell4 = row.createCell(5);
                cell4.setCellValue("before");
                cell4.setCellStyle(titleCell);
                cell5 = row.createCell(6);
                cell5.setCellValue("after");
                cell5.setCellStyle(titleCell);
            }
            if (i == 11) {
                cell = row.createCell(0);
                cell.setCellValue("\u7d22\u8d54");
                cell.setCellStyle(titleCell);
                row.createCell(2).setCellValue(vo.getRevokeMsg().getReClaimWithoutTaxAmountAfter());
                row.createCell(4).setCellValue(vo.getRevokeMsg().getReClaimTaxAmountAfter());
                row.createCell(6).setCellValue(vo.getRevokeMsg().getReClaimGapAfter());
            }
            if (i == 12) {
                cell = row.createCell(0);
                cell.setCellValue("\u534f\u8bae");
                cell.setCellStyle(titleCell);
                row.createCell(1).setCellValue(vo.getRevokeMsg().getReAggrementWithoutTaxAmountBefore());
                row.createCell(2).setCellValue(vo.getRevokeMsg().getReAggrementWithoutTaxAmountAfter());
                row.createCell(3).setCellValue(vo.getRevokeMsg().getReAggrementTaxAmountBefore());
                row.createCell(4).setCellValue(vo.getRevokeMsg().getReAggrementTaxAmountAfter());
                row.createCell(5).setCellValue(vo.getRevokeMsg().getReAggrementGapBefore());
                row.createCell(6).setCellValue(vo.getRevokeMsg().getReAggrementGapAfter());
            }
            if (i != 13) continue;
            cell = row.createCell(0);
            cell.setCellValue("\u5176\u4ed6");
            cell.setCellStyle(titleCell);
            row.createCell(2).setCellValue(vo.getRevokeMsg().getReOtherWithoutTaxAmountAfter());
            row.createCell(4).setCellValue(vo.getRevokeMsg().getReOtherTaxAmountAfter());
        }
    }

    public RedPurcherMsgCollectVO queryPurcherMsg(String dateMouth) {
        Map remap4;
        Map remap2_1;
        Map letterMap4;
        Map letterMap2_1;
        Map map4;
        Map map2_1;
        RedPurcherMsgCollectVO.ApplyingVO vo = new RedPurcherMsgCollectVO.ApplyingVO();
        Map queryMap = DateUtils.getMounthFistAndLastByString((String)dateMouth, (String)"yyyy-MM", (String)"String", (String)"yyyy-MM-dd");
        Map map1 = this.tXfRedNotificationMapper.selectSumAmountByBusiness((String)queryMap.get("firstDay"), (String)queryMap.get("lastDay"), "1", "0");
        if (map1 != null) {
            vo.setClaimWithoutTaxAmountAfter("" + map1.get("amountWithoutTax"));
            vo.setClaimTaxAmountAfter("" + map1.get("taxAmount"));
        }
        String difference = this.getTaxDifference(queryMap, "1", "0");
        vo.setClaimGapAfter(difference);
        Map map2_0 = this.tXfRedNotificationMapper.selectSumAmountByBusiness2((String)queryMap.get("firstDay"), (String)queryMap.get("lastDay"), "0", "0");
        if (map2_0 != null) {
            vo.setAggrementWithoutTaxAmountAfter("" + map2_0.get("amountWithoutTax"));
            vo.setAggrementTaxAmountAfter("" + map2_0.get("taxAmount"));
            if (map2_0.get("taxAmount") != null) {
                String difference2 = this.getTaxDifference(queryMap, "2", "0");
                vo.setAggrementGapAfter(difference2);
            }
        }
        if ((map2_1 = this.tXfRedNotificationMapper.selectSumAmountByBusiness2((String)queryMap.get("firstDay"), (String)queryMap.get("lastDay"), "0", "1")) != null) {
            vo.setAggrementWithoutTaxAmountBefore("" + map2_1.get("amountWithoutTax"));
            vo.setAggrementTaxAmountBefore("" + map2_1.get("taxAmount"));
            if (map2_1.get("taxAmount") != null) {
                String difference2 = this.getTaxDifference(queryMap, "2", "0", "1");
                vo.setAggrementGapBefore(difference2);
            }
        }
        if ((map4 = this.tXfRedNotificationMapper.selectSumAmountByBusiness((String)queryMap.get("firstDay"), (String)queryMap.get("lastDay"), "4", "0")) != null) {
            vo.setOtherWithoutTaxAmountAfter("" + map4.get("amountWithoutTax"));
            vo.setOtherTaxAmountAfter("" + map4.get("taxAmount"));
        }
        RedPurcherMsgCollectVO.ApplyingVO letterVo = new RedPurcherMsgCollectVO.ApplyingVO();
        Map letterMap1 = this.tXfRedLetterMapper.selectSumAmountByBusiness((String)queryMap.get("firstDay"), (String)queryMap.get("lastDay"), "1", "0");
        if (letterMap1 != null) {
            letterVo.setClaimWithoutTaxAmountAfter("" + letterMap1.get("amountWithoutTax"));
            letterVo.setClaimTaxAmountAfter("" + letterMap1.get("taxAmount"));
        }
        letterVo.setClaimGapAfter(this.getLetterTaxDifference(queryMap, "1", "0", "0"));
        Map letterMap2_0 = this.tXfRedLetterMapper.selectSumAmountByBusiness2((String)queryMap.get("firstDay"), (String)queryMap.get("lastDay"), "2", "0", "0");
        if (letterMap2_0 != null) {
            letterVo.setAggrementWithoutTaxAmountAfter("" + letterMap2_0.get("amountWithoutTax"));
            letterVo.setAggrementTaxAmountAfter("" + letterMap2_0.get("taxAmount"));
            if (letterMap2_0.get("taxAmount") != null) {
                letterVo.setAggrementGapAfter(this.getLetterTaxDifference(queryMap, "2", "0", "0"));
            }
        }
        if ((letterMap2_1 = this.tXfRedLetterMapper.selectSumAmountByBusiness2((String)queryMap.get("firstDay"), (String)queryMap.get("lastDay"), "2", "0", "1")) != null) {
            letterVo.setAggrementWithoutTaxAmountBefore("" + letterMap2_1.get("amountWithoutTax"));
            letterVo.setAggrementTaxAmountBefore("" + letterMap2_1.get("taxAmount"));
            if (letterMap2_1.get("taxAmount") != null) {
                letterVo.setAggrementGapBefore(this.getLetterTaxDifference(queryMap, "2", "0", "1"));
            }
        }
        if ((letterMap4 = this.tXfRedLetterMapper.selectSumAmountByBusiness((String)queryMap.get("firstDay"), (String)queryMap.get("lastDay"), "4", "0")) != null) {
            letterVo.setOtherWithoutTaxAmountAfter("" + letterMap4.get("amountWithoutTax"));
            letterVo.setOtherTaxAmountAfter("" + letterMap4.get("taxAmount"));
        }
        RedPurcherMsgCollectVO.RevokeMsgVO reVo = new RedPurcherMsgCollectVO.RevokeMsgVO();
        Map remap1 = this.tXfRedNotificationMapper.selectSumAmountByBusiness((String)queryMap.get("firstDay"), (String)queryMap.get("lastDay"), "1", "1");
        if (remap1 != null) {
            reVo.setReClaimWithoutTaxAmountAfter("" + remap1.get("amountWithoutTax"));
            reVo.setReClaimTaxAmountAfter("" + remap1.get("taxAmount"));
        }
        String reDifference = this.getTaxDifference(queryMap, "1", "1");
        reVo.setReClaimGapAfter(reDifference);
        Map remap2_0 = this.tXfRedNotificationMapper.selectSumAmountByBusiness2((String)queryMap.get("firstDay"), (String)queryMap.get("lastDay"), "1", "0");
        if (remap2_0 != null) {
            reVo.setReAggrementWithoutTaxAmountAfter("" + remap2_0.get("amountWithoutTax"));
            reVo.setReAggrementTaxAmountAfter("" + remap2_0.get("taxAmount"));
            if (remap2_0.get("taxAmount") != null) {
                String reDifference2 = this.getTaxDifference(queryMap, "2", "1");
                reVo.setReAggrementGapAfter(reDifference2);
            }
        }
        if ((remap2_1 = this.tXfRedNotificationMapper.selectSumAmountByBusiness2((String)queryMap.get("firstDay"), (String)queryMap.get("lastDay"), "1", "1")) != null) {
            reVo.setReAggrementWithoutTaxAmountBefore("" + remap2_1.get("amountWithoutTax"));
            reVo.setReAggrementTaxAmountBefore("" + remap2_1.get("taxAmount"));
            if (remap2_1.get("taxAmount") != null) {
                String reDifference2 = this.getTaxDifference(queryMap, "2", "1", "1");
                reVo.setReAggrementGapBefore(reDifference2);
            }
        }
        if ((remap4 = this.tXfRedNotificationMapper.selectSumAmountByBusiness((String)queryMap.get("firstDay"), (String)queryMap.get("lastDay"), "4", "1")) != null) {
            reVo.setReOtherWithoutTaxAmountAfter("" + remap4.get("amountWithoutTax"));
            reVo.setReOtherTaxAmountAfter("" + remap4.get("taxAmount"));
        }
        RedPurcherMsgCollectVO collectVO = new RedPurcherMsgCollectVO();
        collectVO.setApplyingMsg(vo);
        collectVO.setLetterMsg(letterVo);
        collectVO.setRevokeMsg(reVo);
        return collectVO;
    }

    private String getTaxDifference(Map<String, String> queryMap, String businessType, String isRe) {
        return this.getTaxDifference(queryMap, businessType, isRe, "0");
    }

    private String getTaxDifference(Map<String, String> queryMap, String businessType, String isRe, String isBefore) {
        BigDecimal difference = new BigDecimal(0);
        BigDecimal selecTaxBlace = this.tXfRedNotificationMapper.selectDifferenceByIdSet(queryMap.get("firstDay"), queryMap.get("lastDay"), businessType, isRe, isBefore);
        if (selecTaxBlace != null) {
            difference = selecTaxBlace;
        }
        String s = difference.toString();
        return s;
    }

    private String getLetterTaxDifference(Map<String, String> queryMap, String businessType, String isRe, String isBefore) {
        BigDecimal difference = new BigDecimal(0);
        BigDecimal selecTaxBlace = this.tXfRedLetterMapper.selectDifferenceByIdSet(queryMap.get("firstDay"), queryMap.get("lastDay"), businessType, isRe, isBefore);
        if (selecTaxBlace != null) {
            difference = selecTaxBlace;
        }
        String s = difference.toString();
        return s;
    }

    public PageUtils queryDetails(RedNotificationDetailReq params, Boolean isPage) {
        Map dayOfThreeMonth = DateUtils.getMounthFistAndLastByString((String)params.getDateMouth(), (String)"yyyy-MM", (String)"String", (String)"yyyyMMdd");
        List redNotificationList = this.tXfRedNotificationMapper.selectRedNotification((String)dayOfThreeMonth.get("firstDay"), (String)dayOfThreeMonth.get("lastDay"), params.getBusinessType(), params.getIsRe());
        Map<Long, List<TXfRedNotification>> idMap = redNotificationList.stream().collect(Collectors.groupingBy(a -> a.getId()));
        Map<String, List<TXfRedNotification>> idMapString = redNotificationList.stream().collect(Collectors.groupingBy(a -> a.getId() + ""));
        Map<String, List<TXfRedNotification>> collectMap = redNotificationList.stream().collect(Collectors.groupingBy(a -> a.getBillNo()));
        Set<Long> idSet = idMap.keySet();
        Map<Object, Object> collect = new HashMap();
        List redLetterList = this.tXfRedLetterMapper.selectRedNotification((String)dayOfThreeMonth.get("firstDay"), (String)dayOfThreeMonth.get("lastDay"), params.getBusinessType(), params.getIsRe());
        Map<Long, List<TXfRedLetter>> idLetterMap = redLetterList.stream().collect(Collectors.groupingBy(a -> a.getId()));
        Map<String, List<TXfRedLetter>> idLetterMapString = redLetterList.stream().collect(Collectors.groupingBy(a -> a.getId() + ""));
        Set<Long> idLetterSet = idLetterMap.keySet();
        Map<Object, Object> collectLetter = new HashMap();
        String isBefore = "before".equals(params.getAfterOrBefore()) ? "1" : "0";
        String isPageFlag = isPage != false ? "1" : "0";
        List tXfBillDeduct = new ArrayList();
        Integer count = 0;
        if (!CollectionUtils.isEmpty(idSet)) {
            if (isPage.booleanValue()) {
                tXfBillDeduct = this.tXfRedNotificationMapper.selectDetailsByBillNo(idSet, params.getBusinessType(), (String)dayOfThreeMonth.get("firstDay"), (String)dayOfThreeMonth.get("lastDay"), params.getIsRe(), isBefore, isPageFlag, params.getCurrPage().intValue(), params.getPageSize().intValue());
                count = this.tXfRedNotificationMapper.selectDetailsCountByBillNo(idSet, params.getBusinessType(), (String)dayOfThreeMonth.get("firstDay"), (String)dayOfThreeMonth.get("lastDay"), params.getIsRe(), isBefore);
            } else {
                tXfBillDeduct = this.tXfRedNotificationMapper.selectDetailsByBillNo(idSet, params.getBusinessType(), (String)dayOfThreeMonth.get("firstDay"), (String)dayOfThreeMonth.get("lastDay"), params.getIsRe(), isBefore, isPageFlag);
            }
            List addFieldVo = this.tXfRedNotificationMapper.selectTaxRateByIdSet(idSet);
            collect = addFieldVo.stream().collect(Collectors.groupingBy(a -> a.getRedNotificationId()));
        }
        for (RedPurcherDetailVO vo : tXfBillDeduct) {
            List redPurcherDetailVOS = (List)collect.get(vo.getRedNotificationId());
            List<TXfRedNotification> tXfRedNotifications = idMapString.get(vo.getRedNotificationId());
            if (!CollectionUtils.isEmpty(tXfRedNotifications)) {
                TXfRedNotification tXfRedNotification = tXfRedNotifications.get(0);
                vo.setInvoiceDate(tXfRedNotification.getInvoiceDate());
                vo.setCancelTime(tXfRedNotification.getCancelTime());
                vo.setRevertRemark(tXfRedNotification.getRevertRemark());
                vo.setSettlementNo(tXfRedNotification.getBillNo());
            }
            if (!CollectionUtils.isEmpty((Collection)redPurcherDetailVOS)) {
                RedPurcherDetailVO redPurcherDetailVO = (RedPurcherDetailVO)redPurcherDetailVOS.get(0);
                vo.setItemTaxRate(redPurcherDetailVO.getItemTaxRate());
            } else {
                vo.setItemTaxRate(BigDecimal.ZERO);
            }
            BigDecimal reduce = new BigDecimal("0");
            if (vo.getItemTaxRate().compareTo(vo.getMainTaxRate()) != 0) {
                BigDecimal amounntWithTax = vo.getItemTaxAmount().add(vo.getItemAmountWithoutTax());
                BigDecimal add = new BigDecimal("1").add(vo.getMainTaxRate());
                BigDecimal mainTaxAmount = amounntWithTax.divide(add, 4).multiply(vo.getMainTaxRate());
                reduce = mainTaxAmount.subtract(vo.getItemTaxAmount());
            }
            BigDecimal bigDecimal = reduce.setScale(2, 4);
            vo.setTaxBlance(bigDecimal);
        }
        List tXfBillDeductLetter = new ArrayList();
        if (!CollectionUtils.isEmpty(idLetterSet)) {
            if (isPage.booleanValue()) {
                tXfBillDeductLetter = this.tXfRedLetterMapper.selectDetailsByBillNo(idSet, params.getBusinessType(), (String)dayOfThreeMonth.get("firstDay"), (String)dayOfThreeMonth.get("lastDay"), params.getIsRe(), isBefore, isPageFlag, params.getCurrPage().intValue(), params.getPageSize().intValue());
                count = this.tXfRedLetterMapper.selectDetailsCountByBillNo(idSet, params.getBusinessType(), (String)dayOfThreeMonth.get("firstDay"), (String)dayOfThreeMonth.get("lastDay"), params.getIsRe(), isBefore);
            } else {
                tXfBillDeductLetter = this.tXfRedLetterMapper.selectDetailsByBillNo(idSet, params.getBusinessType(), (String)dayOfThreeMonth.get("firstDay"), (String)dayOfThreeMonth.get("lastDay"), params.getIsRe(), isBefore, isPageFlag, 0, 0);
            }
            List addFieldVo = this.tXfRedLetterMapper.selectTaxRateByIdSet(idLetterSet);
            collectLetter = addFieldVo.stream().collect(Collectors.groupingBy(a -> a.getRedLetterId()));
        }
        for (RedPurcherDetailVO vo : tXfBillDeductLetter) {
            List redPurcherDetailVOS = (List)collectLetter.get(vo.getRedLetterId());
            List<TXfRedLetter> tXfRedLetters = idLetterMapString.get(vo.getRedLetterId());
            if (!CollectionUtils.isEmpty(tXfRedLetters)) {
                TXfRedLetter tXfRedLetter = tXfRedLetters.get(0);
                vo.setInvoiceDate(tXfRedLetter.getApplySuccessTime());
                vo.setCancelTime(tXfRedLetter.getCancelTime());
                vo.setRevertRemark(tXfRedLetter.getRevertRemark());
                vo.setSettlementNo(tXfRedLetter.getBillNo());
            }
            if (!CollectionUtils.isEmpty((Collection)redPurcherDetailVOS)) {
                RedPurcherDetailVO redPurcherDetailVO = (RedPurcherDetailVO)redPurcherDetailVOS.get(0);
                vo.setItemTaxRate(redPurcherDetailVO.getItemTaxRate());
            } else {
                vo.setItemTaxRate(BigDecimal.ZERO);
            }
            BigDecimal reduce = new BigDecimal("0");
            if (vo.getItemTaxRate().compareTo(vo.getMainTaxRate()) != 0) {
                BigDecimal amounntWithTax = vo.getItemTaxAmount().add(vo.getItemAmountWithoutTax());
                BigDecimal add = new BigDecimal("1").add(vo.getMainTaxRate());
                BigDecimal mainTaxAmount = amounntWithTax.divide(add, 4).multiply(vo.getMainTaxRate());
                reduce = mainTaxAmount.subtract(vo.getItemTaxAmount());
            }
            BigDecimal bigDecimal = reduce.setScale(2, 4);
            vo.setTaxBlance(bigDecimal);
        }
        ArrayList allList = new ArrayList();
        allList.addAll(tXfBillDeduct);
        allList.addAll(tXfBillDeductLetter);
        PageUtils rpage = new PageUtils();
        rpage.setList(allList);
        if (params.getCurrPage() != null && params.getPageSize() != null) {
            rpage.setCurrPage(params.getCurrPage().intValue());
            rpage.setPageSize(params.getPageSize().intValue());
            int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
            rpage.setTotalPage(totalpage);
            rpage.setTotalCount(count.intValue());
        }
        return rpage;
    }

    public void export(RedNotificationDetailReq params, String token) {
        String downLoadfileName = "CHC-SHC\u8fdb\u9879\u7ea2\u7968\u6708\u5ea6\u6c47\u603b\u8868";
        String uploadfileName = "chcRedCount-" + DateUtils.getStringDateShort();
        RedPurcherMsgCollectVO collectVO = this.queryPurcherMsg(params.getDateMouth());
        log.info("\u4e3b\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)collectVO));
        ArrayList list = new ArrayList();
        RedNotificationDetailReq type1Query = new RedNotificationDetailReq();
        type1Query.setDateMouth(params.getDateMouth());
        type1Query.setBusinessType("1");
        type1Query.setIsRe("0");
        PageUtils pageUtils1 = this.queryDetails(type1Query, Boolean.valueOf(false));
        list.addAll(pageUtils1.getList());
        log.info("\u7d22\u8d54after\uff1a{}", (Object)pageUtils1.getList().size());
        RedNotificationDetailReq type2AndBeforeQuery = new RedNotificationDetailReq();
        type2AndBeforeQuery.setDateMouth(params.getDateMouth());
        type2AndBeforeQuery.setAfterOrBefore("before");
        type2AndBeforeQuery.setBusinessType("2");
        type2AndBeforeQuery.setIsRe("0");
        PageUtils pageUtils2 = this.queryDetails(type2AndBeforeQuery, Boolean.valueOf(false));
        log.info("\u534f\u8baebefore\uff1a{}", (Object)pageUtils2.getList().size());
        list.addAll(pageUtils2.getList());
        RedNotificationDetailReq type2AndAfterQuery = new RedNotificationDetailReq();
        type2AndAfterQuery.setDateMouth(params.getDateMouth());
        type2AndAfterQuery.setAfterOrBefore("after");
        type2AndAfterQuery.setBusinessType("2");
        type2AndAfterQuery.setIsRe("0");
        PageUtils pageUtils3 = this.queryDetails(type2AndAfterQuery, Boolean.valueOf(false));
        log.info("\u534f\u8baeafter\uff1a{}", (Object)pageUtils3.getList().size());
        list.addAll(pageUtils3.getList());
        RedNotificationDetailReq type4Query = new RedNotificationDetailReq();
        type4Query.setDateMouth(params.getDateMouth());
        type4Query.setBusinessType("4");
        type4Query.setIsRe("0");
        PageUtils pageUtils4 = this.queryDetails(type4Query, Boolean.valueOf(false));
        log.info("\u5176\u4ed6after\uff1a{}", (Object)pageUtils4.getList().size());
        list.addAll(pageUtils4.getList());
        ArrayList reList = new ArrayList();
        RedNotificationDetailReq retype1Query = new RedNotificationDetailReq();
        retype1Query.setDateMouth(params.getDateMouth());
        retype1Query.setBusinessType("1");
        retype1Query.setIsRe("1");
        PageUtils repageUtils1 = this.queryDetails(retype1Query, Boolean.valueOf(false));
        log.info("\u64a4\u9500\u7d22\u8d54after\uff1a{}", (Object)repageUtils1.getList().size());
        reList.addAll(repageUtils1.getList());
        RedNotificationDetailReq retype2AndBeforeQuery = new RedNotificationDetailReq();
        retype2AndBeforeQuery.setDateMouth(params.getDateMouth());
        retype2AndBeforeQuery.setBusinessType("2");
        retype2AndBeforeQuery.setAfterOrBefore("before");
        retype2AndBeforeQuery.setIsRe("1");
        PageUtils repageUtils2 = this.queryDetails(retype2AndBeforeQuery, Boolean.valueOf(false));
        log.info("\u64a4\u9500\u534f\u8baebefore\uff1a{}", (Object)repageUtils2.getList().size());
        reList.addAll(repageUtils2.getList());
        RedNotificationDetailReq retype2AndAfterQuery = new RedNotificationDetailReq();
        retype2AndAfterQuery.setDateMouth(params.getDateMouth());
        retype2AndAfterQuery.setBusinessType("2");
        retype2AndAfterQuery.setAfterOrBefore("after");
        retype2AndAfterQuery.setIsRe("1");
        PageUtils repageUtils3 = this.queryDetails(retype2AndAfterQuery, Boolean.valueOf(false));
        log.info("\u64a4\u9500\u534f\u8baeafter\uff1a{}", (Object)repageUtils3.getList().size());
        reList.addAll(repageUtils3.getList());
        RedNotificationDetailReq retType4Query = new RedNotificationDetailReq();
        retType4Query.setDateMouth(params.getDateMouth());
        retType4Query.setBusinessType("4");
        retType4Query.setIsRe("1");
        PageUtils repageUtils4 = this.queryDetails(type4Query, Boolean.valueOf(false));
        log.info("\u64a4\u9500\u5176\u4ed6after\uff1a{}", (Object)repageUtils4.getList().size());
        reList.addAll(repageUtils4.getList());
        List historyList = this.getRedPurcherHistoryVO(params.getDateMouth());
        String path = this.nasConfig.getUrl();
        this.createChcRedNotification(collectVO, list, reList, historyList, uploadfileName, path);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, downLoadfileName, uploadfileName);
    }

    private List<RedPurcherHistoryVO> getRedPurcherHistoryVO(String dateMouth) {
        Map dayOfThreeMonth = DateUtils.getMounthFistAndLastByString((String)dateMouth, (String)"yyyy-MM", (String)"String", (String)"yyyy-MM-dd");
        List historyMsgList = this.tXfRedNotificationMapper.getHistoryMsg((String)dayOfThreeMonth.get("firstDay"), (String)dayOfThreeMonth.get("lastDay"));
        Map<Long, List<RedPurcherHistoryVO>> idMap = historyMsgList.stream().collect(Collectors.groupingBy(a -> Long.valueOf(a.getRedNotificationId())));
        Set<Long> idSet = idMap.keySet();
        if (!CollectionUtils.isEmpty(idSet)) {
            List addFieldVo = this.tXfRedNotificationMapper.selectHistoryTaxRateByIdSet(idSet);
            Map<String, List<RedPurcherHistoryVO>> collect = addFieldVo.stream().collect(Collectors.groupingBy(a -> a.getRedNotificationId()));
            for (RedPurcherHistoryVO vo : historyMsgList) {
                List<RedPurcherHistoryVO> redPurcherDetailVOS = collect.get(vo.getRedNotificationId());
                if (CollectionUtils.isEmpty(redPurcherDetailVOS)) continue;
                RedPurcherHistoryVO redPurcherDetailVO = redPurcherDetailVOS.get(0);
                vo.setItemTaxRate(redPurcherDetailVO.getItemTaxRate());
            }
        }
        return historyMsgList;
    }
}

