/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.taskthread;

import com.alibaba.fastjson.JSON;
import com.reportfrom.wapp.config.BeanContext;
import com.reportfrom.wapp.entity.ReportPurchaseQuartQuery;
import com.reportfrom.wapp.entityVO.PurcherTaxVO;
import com.reportfrom.wapp.mapper.first.ReportPurchaseQuartQueryMapper;
import com.reportfrom.wapp.mapper.first.ReportTaxCodeMapper;
import com.reportfrom.wapp.mapper.first.TDxRecordInvoiceMapper;
import com.reportfrom.wapp.request.PurcherTaxReq;
import com.reportfrom.wapp.util.MathUtils;
import io.micrometer.core.instrument.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PurchaserQuartzTrueThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PurchaserQuartzTrueThread.class);
    private PurcherTaxReq query;
    private Long taskID;
    private ReportPurchaseQuartQueryMapper purchaseQuartQueryMapper = (ReportPurchaseQuartQueryMapper)BeanContext.getBean(ReportPurchaseQuartQueryMapper.class);
    private TDxRecordInvoiceMapper tDxRecordInvoiceMapper = (TDxRecordInvoiceMapper)BeanContext.getBean(TDxRecordInvoiceMapper.class);
    private ReportTaxCodeMapper reportTaxCodeMapper = (ReportTaxCodeMapper)BeanContext.getBean(ReportTaxCodeMapper.class);

    public PurchaserQuartzTrueThread() {
    }

    public PurchaserQuartzTrueThread(PurcherTaxReq req, Long taskID) {
        this.query = req;
        this.taskID = taskID;
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        List purcherTaxVOS = this.purcherTaxQuery1(this.query);
        long endTime = System.currentTimeMillis();
        log.info("\u8fdb\u9879\u7a0e\u91d1\uff08\u5df2\u8ba4\u8bc1\uff09\u67e5\u8be2\u7ed3\u679c  taskid->{}\uff0cflowType->{}\uff0csize->{},\u8017\u65f6->{}", new Object[]{this.taskID, this.query.getFlowTypeNo(), purcherTaxVOS.size(), endTime - startTime});
        for (PurcherTaxVO next : purcherTaxVOS) {
            ReportPurchaseQuartQuery purchaseQuartQuery = (ReportPurchaseQuartQuery)JSON.parseObject((String)JSON.toJSONString((Object)next), ReportPurchaseQuartQuery.class);
            purchaseQuartQuery.setTaskId(this.taskID);
            this.purchaseQuartQueryMapper.insert((Object)purchaseQuartQuery);
        }
    }

    public List<PurcherTaxVO> purcherTaxQuery1(PurcherTaxReq params) {
        List exceptTaxList;
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        ArrayList firstList = new ArrayList();
        ArrayList<PurcherTaxVO> voList = new ArrayList<PurcherTaxVO>();
        List onlyTaxList = this.tDxRecordInvoiceMapper.selectPurcherTaxByParamOnlyTax(map);
        if (!CollectionUtils.isEmpty((Collection)onlyTaxList)) {
            firstList.addAll(onlyTaxList);
        }
        if (!CollectionUtils.isEmpty((Collection)(exceptTaxList = this.tDxRecordInvoiceMapper.selectPurcherTaxByParamExceptTax(map)))) {
            firstList.addAll(exceptTaxList);
        }
        Map<String, List<PurcherTaxVO>> collect = firstList.stream().collect(Collectors.groupingBy(a -> a.getInvoiceType() + "_" + a.getGfTaxNo() + "_" + (StringUtils.isEmpty((String)a.getTaxRate()) ? "null" : a.getTaxRate()) + "_" + (StringUtils.isEmpty((String)a.getJvcode()) ? "null" : a.getJvcode())));
        for (List<PurcherTaxVO> oldlist : collect.values()) {
            PurcherTaxVO vo = new PurcherTaxVO();
            BigDecimal taxAmount = oldlist.stream().map(PurcherTaxVO::getSumTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal amountwithoutTax = oldlist.stream().map(PurcherTaxVO::getSumAmountWithoutTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal invoiceCount = oldlist.stream().map(PurcherTaxVO::getInvoiceCount).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setRzhBelongDate(oldlist.get(0).getRzhBelongDate());
            vo.setCompanyCode(oldlist.get(0).getCompanyCode());
            vo.setGfTaxNo(oldlist.get(0).getGfTaxNo());
            vo.setGfName(oldlist.get(0).getGfName());
            vo.setJvcode(oldlist.get(0).getJvcode());
            vo.setInvoiceType(oldlist.get(0).getInvoiceType());
            vo.setTaxRate(oldlist.get(0).getTaxRate());
            vo.setInvoiceCount(invoiceCount);
            vo.setSumTaxAmount(taxAmount);
            vo.setSumAmountWithoutTax(amountwithoutTax);
            vo.setSumAmountWithTax(taxAmount.add(amountwithoutTax));
            voList.add(vo);
        }
        HashMap<String, String> taxCodeMap = new HashMap<String, String>();
        for (PurcherTaxVO purcherTaxVO : voList) {
            String taxRate = MathUtils.formatPointInt((String)purcherTaxVO.getTaxRate());
            String invoiceType = purcherTaxVO.getInvoiceType();
            String taxCode = (String)taxCodeMap.get(taxRate + invoiceType);
            if (StringUtils.isEmpty((String)taxCode)) {
                HashMap<String, String> getCodeMap = new HashMap<String, String>();
                getCodeMap.put("taxRate", taxRate);
                getCodeMap.put("invoiceType", invoiceType);
                taxCode = this.reportTaxCodeMapper.selectCodeByRateAndType(getCodeMap);
                taxCodeMap.put(taxRate + invoiceType, taxCode);
            }
            purcherTaxVO.setTaxCode(taxCode);
            if (StringUtils.isNotEmpty((String)params.getFlowTypeNo())) {
                purcherTaxVO.setFlowTypeNo(params.getFlowTypeNo());
            }
            if (purcherTaxVO == null) continue;
            purcherTaxVO.setTaxRate(MathUtils.formatPointDouble((String)taxRate));
        }
        return voList;
    }
}

