/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.taskthread;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.reportfrom.wapp.config.BeanContext;
import com.reportfrom.wapp.entity.ReportClaimRedStatistic;
import com.reportfrom.wapp.entity.ReportClaimStatistic;
import com.reportfrom.wapp.entity.ReportClaimStatisticBeanWithTaxRate;
import com.reportfrom.wapp.mapper.first.ReportClaimRedStatisticMapper;
import com.reportfrom.wapp.mapper.first.ReportClaimStatisticMapper;
import com.reportfrom.wapp.mapper.first.TXfBillDeductMapper;
import com.reportfrom.wapp.util.DateUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class ReportClaimUploadMainExcelThread
implements Runnable {
    private TXfBillDeductMapper tXfBillDeductMapper = (TXfBillDeductMapper)BeanContext.getBean(TXfBillDeductMapper.class);
    private ReportClaimStatisticMapper reportClaimStatisticMapper = (ReportClaimStatisticMapper)BeanContext.getBean(ReportClaimStatisticMapper.class);
    private ReportClaimRedStatisticMapper reportClaimRedStatisticMapper = (ReportClaimRedStatisticMapper)BeanContext.getBean(ReportClaimRedStatisticMapper.class);
    private List<ReportClaimStatistic> updateList;
    private Map<String, List<ReportClaimStatistic>> collect;

    public ReportClaimUploadMainExcelThread() {
    }

    public ReportClaimUploadMainExcelThread(List<ReportClaimStatistic> updateList, Map<String, List<ReportClaimStatistic>> collect) {
        this.updateList = updateList;
        this.collect = collect;
    }

    @Override
    public void run() {
        Map<String, List<ReportClaimStatistic>> collect2 = this.updateList.stream().collect(Collectors.groupingBy(a -> a.getDateMonth() + "_" + a.getBlueInvoiceNo() + "_" + a.getSupplierNo()));
        Set entries = this.collect.entrySet();
        for (Map.Entry next : entries) {
            List<ReportClaimStatistic> updateStatisticsList;
            List value = (List)next.getValue();
            ReportClaimStatistic reportClaimStatistic = (ReportClaimStatistic)value.get(0);
            if (reportClaimStatistic.getDateMonth().length() == 6) {
                BigDecimal standardCurrencyAmount = reportClaimStatistic.getStandardCurrencyAmount();
                Map queryDeductMap = DateUtils.getFistAndLastByString((String)reportClaimStatistic.getDateMonth(), (String)"yyyyMM", (String)"String", null);
                queryDeductMap.put("blueInvoiceNo", reportClaimStatistic.getBlueInvoiceNo());
                queryDeductMap.put("supplierNo", reportClaimStatistic.getSupplierNo());
                ReportClaimStatisticBeanWithTaxRate demo = this.tXfBillDeductMapper.selectSumByParams(queryDeductMap);
                if (demo == null) {
                    demo = new ReportClaimStatisticBeanWithTaxRate();
                    demo.setClaimAmountWithTax(new BigDecimal(0));
                    demo.setClaimTaxAmount(new BigDecimal(0));
                }
                reportClaimStatistic.setClaimAmountWithTax(demo.getClaimAmountWithTax());
                reportClaimStatistic.setClaimTaxAmount(demo.getClaimTaxAmount());
                if (standardCurrencyAmount == null) {
                    standardCurrencyAmount = new BigDecimal(0);
                }
                reportClaimStatistic.setDifferenceTaxAmount(standardCurrencyAmount.abs().subtract(demo.getClaimTaxAmount()));
                Map allDetailsAmount = this.getAllDetailsAmount(reportClaimStatistic);
                if (allDetailsAmount != null) {
                    BigDecimal bigDecimal = allDetailsAmount.get("amountWithTax") == null ? new BigDecimal(0) : (BigDecimal)allDetailsAmount.get("amountWithTax");
                    BigDecimal bigDecimal1 = allDetailsAmount.get("taxAmount") == null ? new BigDecimal(0) : (BigDecimal)allDetailsAmount.get("taxAmount");
                    reportClaimStatistic.setUnsettledAmountWithTax(demo.getClaimAmountWithTax().subtract(bigDecimal));
                    reportClaimStatistic.setUnsettledTaxAmount(demo.getClaimTaxAmount().subtract(bigDecimal1));
                }
            }
            if (CollectionUtils.isEmpty(updateStatisticsList = collect2.get(next.getKey()))) {
                if (reportClaimStatistic.getDateMonth().length() != 6) continue;
                this.reportClaimStatisticMapper.insert((Object)reportClaimStatistic);
                continue;
            }
            ReportClaimStatistic updateStatistics = updateStatisticsList.get(0);
            reportClaimStatistic.setId(updateStatistics.getId());
            this.reportClaimStatisticMapper.updateById((Object)reportClaimStatistic);
        }
    }

    private Map<String, BigDecimal> getAllDetailsAmount(ReportClaimStatistic domain) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"date_month", (Object)domain.getDateMonth())).eq((Object)"blue_invoice_no", (Object)domain.getBlueInvoiceNo())).eq((Object)"supplier_no", (Object)domain.getSupplierNo());
        List redStatisticList = this.reportClaimRedStatisticMapper.selectList((Wrapper)wrapper);
        BigDecimal countAmountWithTax = new BigDecimal("0");
        BigDecimal countTaxAmount = new BigDecimal("0");
        for (ReportClaimRedStatistic redStatistic : redStatisticList) {
            if (redStatistic.getApplyRedNotificationAmountWithTax() != null) {
                countAmountWithTax = countAmountWithTax.add(redStatistic.getApplyRedNotificationAmountWithTax());
            }
            if (redStatistic.getReverseRedNotificationAmountWithTax() != null) {
                countAmountWithTax = countAmountWithTax.add(redStatistic.getReverseRedNotificationAmountWithTax());
            }
            if (redStatistic.getApplyRedNotificationTaxAmount() != null) {
                countTaxAmount = countTaxAmount.add(redStatistic.getApplyRedNotificationTaxAmount());
            }
            if (redStatistic.getReverseRedNotificationTaxAmount() == null) continue;
            countTaxAmount = countTaxAmount.add(redStatistic.getReverseRedNotificationTaxAmount());
        }
        HashMap<String, BigDecimal> returenMap = new HashMap<String, BigDecimal>();
        returenMap.put("amountWithTax", countAmountWithTax);
        returenMap.put("taxAmount", countTaxAmount);
        return returenMap;
    }
}

