/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.util;

import com.alibaba.druid.util.StringUtils;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.entity.ReportAggrementEpdStatistic;
import com.reportfrom.wapp.entity.ReportChcCheck;
import com.reportfrom.wapp.entity.ReportClaimRedStatistic;
import com.reportfrom.wapp.entity.ReportClaimStatistic;
import com.reportfrom.wapp.entityEnum.AllType;
import com.reportfrom.wapp.entityEnum.IsUpgradesEnum;
import com.reportfrom.wapp.entityEnum.ProtocolQueryEnum;
import com.reportfrom.wapp.entityVO.ChcJvInvoiceVO;
import com.reportfrom.wapp.entityVO.ClaimantVO;
import com.reportfrom.wapp.entityVO.EpdVO;
import com.reportfrom.wapp.entityVO.InvoiceDetailVO;
import com.reportfrom.wapp.entityVO.ProtocolQueryExceptionVO;
import com.reportfrom.wapp.entityVO.ProtocolQueryRedNotifiVO;
import com.reportfrom.wapp.entityVO.ProtocolQueryVO;
import com.reportfrom.wapp.entityVO.PurcherTaxVO;
import com.reportfrom.wapp.entityVO.RecordInvoiceVO;
import com.reportfrom.wapp.entityVO.ReportAgingStatisticVO;
import com.reportfrom.wapp.entityVO.ReportChcJvInvoiceVO;
import com.reportfrom.wapp.entityVO.ReportJvChcInterInvoiceVO;
import com.reportfrom.wapp.entityVO.ReportMTRJvInterInvoiceVO;
import com.reportfrom.wapp.entityVO.SellerInvoiceItemVO;
import com.reportfrom.wapp.entityVO.TXfSellerInvoiceVO;
import com.reportfrom.wapp.nasFile.FileServiceUtil;
import com.reportfrom.wapp.util.DateUtils;
import com.reportfrom.wapp.util.SFTPUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExcelUtils
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);

    public static void createExcel(List model4s, String reportType, String fileName, String path) {
        ExcelUtils.createExcel((List)model4s, null, (String)reportType, (String)fileName, (String)path, (String)"NAS");
    }

    public static void createExcel(List model4s, String reportType, String fileName, String path, String flag) {
        ExcelUtils.createExcel((List)model4s, null, (String)reportType, (String)fileName, (String)path, (String)flag);
    }

    public static void createExcel(List model4s, List detailsList, String reportType, String fileName, String path) {
        ExcelUtils.createExcel((List)model4s, (List)detailsList, (String)reportType, (String)fileName, (String)path, (String)"NAS");
    }

    public static void createExcel(List model4s, List detailsList, String reportType, String fileName, String path, String flag) {
        log.info("\u5f00\u59cb\u751f\u6210Excel\u6587\u4ef6\u3010{}\u3011>>>>>", (Object)fileName);
        try {
            SXSSFWorkbook workbook = new SXSSFWorkbook(5000);
            workbook.setCompressTempFiles(false);
            SXSSFSheet sheet0 = workbook.createSheet();
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setFillForegroundColor(IndexedColors.LIGHT_ORANGE.getIndex());
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            if (ExcelTypeConfig.EPD_REPORT.equals(reportType)) {
                ExcelUtils.epdReport((Sheet)sheet0, (List)model4s, (CellStyle)cellStyle);
            } else if (ExcelTypeConfig.FS_INVOICE.equals(reportType)) {
                ExcelUtils.fsInvoice((Sheet)sheet0, (List)model4s, (CellStyle)cellStyle);
            } else if (ExcelTypeConfig.FS_INVOICE_DETAILS.equals(reportType)) {
                ExcelUtils.fsInvoiceDetails((Sheet)sheet0, (List)model4s, (CellStyle)cellStyle);
            } else if (ExcelTypeConfig.PROTOCOL_QUERY.equals(reportType)) {
                ExcelUtils.protocolQuery((Workbook)workbook, (Sheet)sheet0, (List)model4s, (CellStyle)cellStyle);
            } else if (ExcelTypeConfig.CHC_SELLER_INVOICE.equals(reportType)) {
                ExcelUtils.chcSellerInvoice((Sheet)sheet0, (List)model4s, (CellStyle)cellStyle);
            } else if (ExcelTypeConfig.CHC_SELLER_RED_INVOICE.equals(reportType)) {
                ExcelUtils.chcSellerRedInvoice((Sheet)sheet0, (List)model4s, (CellStyle)cellStyle);
            } else if (ExcelTypeConfig.CHCCHECK_QUERY.equals(reportType)) {
                ExcelUtils.chcCheckQuery((Sheet)sheet0, (List)model4s, (CellStyle)cellStyle);
            } else if (ExcelTypeConfig.CLAIMANT_QUERY.equals(reportType)) {
                ExcelUtils.claimantQuery((Workbook)workbook, (Sheet)sheet0, (List)model4s, (List)detailsList, (CellStyle)cellStyle);
            } else if (ExcelTypeConfig.JX_PURCHER_TAX1.equals(reportType)) {
                ExcelUtils.jxpurcherTaxExport1((Sheet)sheet0, (List)model4s, (CellStyle)cellStyle);
            } else if (ExcelTypeConfig.JX_PURCHER_TAX2.equals(reportType)) {
                ExcelUtils.jxpurcherTaxExport2((Sheet)sheet0, (List)model4s, (CellStyle)cellStyle);
            } else if (ExcelTypeConfig.RECORD_INVOICE.equals(reportType)) {
                ExcelUtils.recodeInvoice((Sheet)sheet0, (List)model4s, (CellStyle)cellStyle);
            } else if (ExcelTypeConfig.CLAIM_TAX_STATEMENT.equals(reportType)) {
                ExcelUtils.claimTaxStatement((Sheet)sheet0, (List)model4s, (CellStyle)cellStyle);
            } else if (ExcelTypeConfig.REPORT_AGGREMENT_EPD_STATISTIC_QUERY.equals(reportType)) {
                ExcelUtils.reportAES((Sheet)sheet0, (List)model4s, (CellStyle)cellStyle);
            } else if (ExcelTypeConfig.REPORT_CHC_JV_INVOICE_QUERY.equals(reportType)) {
                ExcelUtils.reportChcJvInvoice((Workbook)workbook, (Sheet)sheet0, (List)model4s, (CellStyle)cellStyle);
            } else if (ExcelTypeConfig.REPORT_JV_CHC_INTER_INVOICE_QUERY.equals(reportType)) {
                ExcelUtils.reportJvChcInterInvoice((Sheet)sheet0, (List)model4s, (CellStyle)cellStyle);
            } else if (ExcelTypeConfig.REPORT_AGING_STATISTIC_QUERY.equals(reportType)) {
                ExcelUtils.reportAgingStatistic((Sheet)sheet0, (List)model4s, (CellStyle)cellStyle);
            } else if (ExcelTypeConfig.REPORT_MTR_JV_INTER_INVOICE_QUERY.equals(reportType)) {
                ExcelUtils.reportMTRJvInterInvoice((Sheet)sheet0, (List)model4s, (CellStyle)cellStyle);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            ByteArrayInputStream is = new ByteArrayInputStream(out.toByteArray());
            out.flush();
            out.close();
            if ("NAS".equals(flag)) {
                log.info("Excel\u6587\u4ef6\u751f\u6210\u6210\u529f,\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6\u81f3NAS\uff0cfileName={},servicePath={}>>>>>", (Object)(fileName + ".xlsx"), (Object)path);
                String vid = FileServiceUtil.uploadFile((byte[])out.toByteArray(), (String)fileName, (String)path);
                log.info("nas\u4e0a\u4f20\u7ed3\u679c\uff1a{}", (Object)vid);
            } else {
                log.info("Excel\u6587\u4ef6\u751f\u6210\u6210\u529f,\u5f00\u59cbftp\u4e0a\u4f20\u6587\u4ef6\uff0cfileName={},servicePath={}>>>>>", (Object)(fileName + ".xlsx"), (Object)path);
                SFTPUtils sftp = SFTPUtils.getInstance();
                boolean upload = sftp.upload(path, fileName + ".xlsx", (InputStream)is);
                log.info("ftp\u4e0a\u4f20\u7ed3\u679c\uff1a{}", (Object)upload);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private static void jxpurcherTaxExport1(Sheet sheet0, List model4s, CellStyle cellStyle) {
        Row row = sheet0.createRow(0);
        List<String> strings = Arrays.asList(ExcelTypeConfig.purcherTaxTitleList);
        for (int i = 0; i < strings.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(strings.get(i));
            cell.setCellStyle(cellStyle);
        }
        List mapList = model4s;
        for (int i = 0; i < mapList.size(); ++i) {
            Row row1 = sheet0.createRow(i + 1);
            row1.createCell(0).setCellValue(((PurcherTaxVO)mapList.get(i)).getRzhBelongDate());
            row1.createCell(1).setCellValue(((PurcherTaxVO)mapList.get(i)).getCompanyCode());
            row1.createCell(2).setCellValue(((PurcherTaxVO)mapList.get(i)).getGfTaxNo());
            row1.createCell(3).setCellValue(((PurcherTaxVO)mapList.get(i)).getGfName());
            row1.createCell(4).setCellValue(((PurcherTaxVO)mapList.get(i)).getJvcode());
            row1.createCell(5).setCellValue(AllType.InvoiceTypesEnum.getMsgByCode((String)((PurcherTaxVO)mapList.get(i)).getInvoiceType()));
            row1.createCell(6).setCellValue(((PurcherTaxVO)mapList.get(i)).getTaxRate());
            row1.createCell(7).setCellValue(((PurcherTaxVO)mapList.get(i)).getTaxCode());
            row1.createCell(8).setCellValue(AllType.FlowTypeEnum.getMsgByCode((String)((PurcherTaxVO)mapList.get(i)).getFlowTypeNo()));
            row1.createCell(9).setCellValue(((PurcherTaxVO)mapList.get(i)).getInvoiceCount() + "");
            row1.createCell(10).setCellValue(((PurcherTaxVO)mapList.get(i)).getSumAmountWithoutTax() + "");
            row1.createCell(11).setCellValue(((PurcherTaxVO)mapList.get(i)).getSumTaxAmount() + "");
            row1.createCell(12).setCellValue(((PurcherTaxVO)mapList.get(i)).getSumAmountWithTax() + "");
        }
    }

    private static void jxpurcherTaxExport2(Sheet sheet0, List model4s, CellStyle cellStyle) {
        Row row = sheet0.createRow(0);
        List<String> strings = Arrays.asList(ExcelTypeConfig.purcherTaxTitleList2);
        for (int i = 0; i < strings.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(strings.get(i));
            cell.setCellStyle(cellStyle);
        }
        List mapList = model4s;
        for (int i = 0; i < mapList.size(); ++i) {
            Row row1 = sheet0.createRow(i + 1);
            row1.createCell(0).setCellValue(((PurcherTaxVO)mapList.get(i)).getCompanyCode());
            row1.createCell(1).setCellValue(((PurcherTaxVO)mapList.get(i)).getGfTaxNo());
            row1.createCell(2).setCellValue(((PurcherTaxVO)mapList.get(i)).getGfName());
            row1.createCell(3).setCellValue(((PurcherTaxVO)mapList.get(i)).getJvcode());
            row1.createCell(4).setCellValue(AllType.InvoiceTypesEnum.getMsgByCode((String)((PurcherTaxVO)mapList.get(i)).getInvoiceType()));
            row1.createCell(5).setCellValue(((PurcherTaxVO)mapList.get(i)).getTaxRate());
            row1.createCell(6).setCellValue(((PurcherTaxVO)mapList.get(i)).getTaxCode());
            row1.createCell(7).setCellValue(AllType.FlowTypeEnum.getMsgByCode((String)((PurcherTaxVO)mapList.get(i)).getFlowTypeNo()));
            row1.createCell(8).setCellValue(((PurcherTaxVO)mapList.get(i)).getInvoiceCount() + "");
            row1.createCell(9).setCellValue(((PurcherTaxVO)mapList.get(i)).getSumAmountWithoutTax() + "");
            row1.createCell(10).setCellValue(((PurcherTaxVO)mapList.get(i)).getSumTaxAmount() + "");
            row1.createCell(11).setCellValue(((PurcherTaxVO)mapList.get(i)).getSumAmountWithTax() + "");
        }
    }

    private static void claimantQuery(Workbook workbook, Sheet sheet0, List model4s, List detailsList, CellStyle cellStyle) {
        workbook.setSheetName(0, "\u7d22\u8d54\u7efc\u5408\u67e5\u8be2");
        Row titileRow = sheet0.createRow(0);
        List<String> strings = Arrays.asList(ExcelTypeConfig.claimantQueryTitleList);
        for (int i = 0; i < strings.size(); ++i) {
            Cell cell = titileRow.createCell(i);
            cell.setCellValue(strings.get(i));
            cell.setCellStyle(cellStyle);
        }
        List mapList = model4s;
        List mapDetailsList = detailsList;
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sf1 = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < mapList.size(); ++i) {
            Row row1 = sheet0.createRow(i + 1);
            row1.createCell(0).setCellValue(((ClaimantVO)mapList.get(i)).getBusinessNo());
            row1.createCell(1).setCellValue(IsUpgradesEnum.fromValue((Integer)((ClaimantVO)mapList.get(i)).getIsUpgrades()).getTitle());
            row1.createCell(2).setCellValue(sf1.format(((ClaimantVO)mapList.get(i)).getDeductDate()));
            row1.createCell(3).setCellValue(((ClaimantVO)mapList.get(i)).getPurchaserName());
            row1.createCell(4).setCellValue(((ClaimantVO)mapList.get(i)).getSellerNo());
            row1.createCell(5).setCellValue(((ClaimantVO)mapList.get(i)).getSellerName());
            row1.createCell(6).setCellValue(((ClaimantVO)mapList.get(i)).getAmountWithTax() == null ? "" : String.valueOf(((ClaimantVO)mapList.get(i)).getAmountWithTax()));
            row1.createCell(7).setCellValue(((ClaimantVO)mapList.get(i)).getTaxRate() == null ? "" : String.valueOf(((ClaimantVO)mapList.get(i)).getTaxRate()));
            row1.createCell(8).setCellValue(((ClaimantVO)mapList.get(i)).getAmountWithoutTax() == null ? "" : String.valueOf(((ClaimantVO)mapList.get(i)).getAmountWithoutTax()));
            row1.createCell(9).setCellValue(((ClaimantVO)mapList.get(i)).getTaxAmount() == null ? "" : String.valueOf(((ClaimantVO)mapList.get(i)).getTaxAmount()));
            row1.createCell(10).setCellValue(AllType.InvoiceTypesEnum.getMsgByCode((String)((ClaimantVO)mapList.get(i)).getInvoiceType()));
            row1.createCell(11).setCellValue(sf1.format(((ClaimantVO)mapList.get(i)).getVerdictDate()));
            row1.createCell(12).setCellValue(((ClaimantVO)mapList.get(i)).getBatchNo());
            row1.createCell(13).setCellValue(((ClaimantVO)mapList.get(i)).getDeductInvoice());
            row1.createCell(14).setCellValue(((ClaimantVO)mapList.get(i)).getSumAmountWithoutTax() == null ? "" : String.valueOf(((ClaimantVO)mapList.get(i)).getSumAmountWithoutTax()));
            row1.createCell(15).setCellValue(((ClaimantVO)mapList.get(i)).getSumAmountWithTax() == null ? "" : String.valueOf(((ClaimantVO)mapList.get(i)).getSumAmountWithTax()));
            row1.createCell(16).setCellValue(((ClaimantVO)mapList.get(i)).getSumTaxAmount() == null ? "" : String.valueOf(((ClaimantVO)mapList.get(i)).getSumTaxAmount()));
            row1.createCell(17).setCellValue(((ClaimantVO)mapList.get(i)).getSettlementCount() == null ? "" : String.valueOf(((ClaimantVO)mapList.get(i)).getSettlementCount()));
            row1.createCell(18).setCellValue(((ClaimantVO)mapList.get(i)).getRedNotifiCount() == null ? "" : String.valueOf(((ClaimantVO)mapList.get(i)).getRedNotifiCount()));
            row1.createCell(19).setCellValue(((ClaimantVO)mapList.get(i)).getSumRedNotifiAmountWithTax() == null ? "" : String.valueOf(((ClaimantVO)mapList.get(i)).getSumRedNotifiAmountWithTax()));
            row1.createCell(20).setCellValue(((ClaimantVO)mapList.get(i)).getSumRedNotifiTaxAmount() == null ? "" : String.valueOf(((ClaimantVO)mapList.get(i)).getSumRedNotifiTaxAmount()));
            row1.createCell(21).setCellValue(((ClaimantVO)mapList.get(i)).getNoneRedNotifiAmountWithTax() == null ? "" : String.valueOf(((ClaimantVO)mapList.get(i)).getNoneRedNotifiAmountWithTax()));
            row1.createCell(22).setCellValue(((ClaimantVO)mapList.get(i)).getRedLetterCount() == null ? "" : String.valueOf(((ClaimantVO)mapList.get(i)).getRedLetterCount()));
            row1.createCell(23).setCellValue(((ClaimantVO)mapList.get(i)).getSumRedLetterAmountWithTax() == null ? "" : String.valueOf(((ClaimantVO)mapList.get(i)).getSumRedLetterAmountWithTax()));
            row1.createCell(24).setCellValue(((ClaimantVO)mapList.get(i)).getSumRedLetterTaxAmount() == null ? "" : String.valueOf(((ClaimantVO)mapList.get(i)).getSumRedLetterTaxAmount()));
            row1.createCell(25).setCellValue(((ClaimantVO)mapList.get(i)).getNoneRedLetterAmountWithTax() == null ? "" : String.valueOf(((ClaimantVO)mapList.get(i)).getNoneRedLetterAmountWithTax()));
            row1.createCell(26).setCellValue(((ClaimantVO)mapList.get(i)).getTaxBalance());
        }
    }

    private static void protocolQuery(Workbook workbook, Sheet sheet0, List model4s, CellStyle cellStyle) {
        Row row;
        int i;
        workbook.setSheetName(0, "\u534f\u8bae\u5355");
        Sheet sheet1 = workbook.createSheet("\u7ed3\u7b97\u5355\u53ca\u7ea2\u5b57\u4fe1\u606f");
        Sheet sheet2 = workbook.createSheet("\u4f8b\u5916\u62a5\u544a");
        Row titileRow = sheet0.createRow(0);
        Row titileRow1 = sheet1.createRow(0);
        Row titileRow2 = sheet2.createRow(0);
        List<String> strings = Arrays.asList(ExcelTypeConfig.protocolQueryTitleList);
        for (int i2 = 0; i2 < strings.size(); ++i2) {
            Cell cell = titileRow.createCell(i2);
            cell.setCellValue(strings.get(i2));
            cell.setCellStyle(cellStyle);
        }
        List<String> strings1 = Arrays.asList(ExcelTypeConfig.protocolQueryRednotofiTitleList);
        for (int i3 = 0; i3 < strings1.size(); ++i3) {
            Cell cell = titileRow1.createCell(i3);
            cell.setCellValue(strings1.get(i3));
            cell.setCellStyle(cellStyle);
        }
        List<String> strings2 = Arrays.asList(ExcelTypeConfig.claimantQueryExceptionTitleList);
        for (int i4 = 0; i4 < strings2.size(); ++i4) {
            Cell cell = titileRow2.createCell(i4);
            cell.setCellValue(strings2.get(i4));
            cell.setCellStyle(cellStyle);
        }
        List enums = model4s;
        List protocolQueryVOs = ((ProtocolQueryEnum)enums.get(0)).getProtocolQueryVOs();
        List protocolQueryRedNotifiVOs = ((ProtocolQueryEnum)enums.get(0)).getProtocolQueryRedNotifiVOs();
        List protocolQueryExceptionVOs = ((ProtocolQueryEnum)enums.get(0)).getProtocolQueryExceptionVOs();
        for (i = 0; i < protocolQueryVOs.size(); ++i) {
            Row row1 = sheet0.createRow(i + 1);
            row1.createCell(0).setCellValue(((ProtocolQueryVO)protocolQueryVOs.get(i)).getSellerNo());
            row1.createCell(1).setCellValue(((ProtocolQueryVO)protocolQueryVOs.get(i)).getSellerName());
            row1.createCell(2).setCellValue(((ProtocolQueryVO)protocolQueryVOs.get(i)).getPurchaserNo());
            row1.createCell(3).setCellValue(((ProtocolQueryVO)protocolQueryVOs.get(i)).getAmountWithTax());
            row1.createCell(4).setCellValue(((ProtocolQueryVO)protocolQueryVOs.get(i)).getAgreementReasonCode());
            row1.createCell(5).setCellValue(((ProtocolQueryVO)protocolQueryVOs.get(i)).getBusinessNo());
            row1.createCell(6).setCellValue(AllType.billDeductIsUpgradesEnum.getMsgByCode((String)((ProtocolQueryVO)protocolQueryVOs.get(i)).getIsUpgrades()));
            row1.createCell(7).setCellValue(((ProtocolQueryVO)protocolQueryVOs.get(i)).getAgreementTaxCode());
            row1.createCell(8).setCellValue(((ProtocolQueryVO)protocolQueryVOs.get(i)).getDeductDate());
            row1.createCell(9).setCellValue(((ProtocolQueryVO)protocolQueryVOs.get(i)).getTaxRate());
            row1.createCell(10).setCellValue(((ProtocolQueryVO)protocolQueryVOs.get(i)).getTaxAmount());
            row1.createCell(11).setCellValue(((ProtocolQueryVO)protocolQueryVOs.get(i)).getAgreementMemo());
            row1.createCell(12).setCellValue(((ProtocolQueryVO)protocolQueryVOs.get(i)).getAgreementReference());
            row1.createCell(13).setCellValue(((ProtocolQueryVO)protocolQueryVOs.get(i)).getAgreementDocumentNumber());
            row1.createCell(14).setCellValue(((ProtocolQueryVO)protocolQueryVOs.get(i)).getAgreementDocumentType());
            row1.createCell(15).setCellValue(((ProtocolQueryVO)protocolQueryVOs.get(i)).getVerdictDate());
            row1.createCell(16).setCellValue(((ProtocolQueryVO)protocolQueryVOs.get(i)).getBatchNo());
            row1.createCell(17).setCellValue(((ProtocolQueryVO)protocolQueryVOs.get(i)).getCreateTime());
            row1.createCell(18).setCellValue(AllType.billDeductLockFlagEnum.getMsgByCode((String)((ProtocolQueryVO)protocolQueryVOs.get(i)).getLockFlag()));
            row1.createCell(19).setCellValue(AllType.billDeductStatusEnum.getMsgByCode((String)((ProtocolQueryVO)protocolQueryVOs.get(i)).getStatusNo()));
        }
        for (i = 0; i < protocolQueryRedNotifiVOs.size(); ++i) {
            row = sheet1.createRow(i + 1);
            row.createCell(0).setCellValue(((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getBusinessNo());
            row.createCell(1).setCellValue(AllType.billDeductIsUpgradesEnum.getMsgByCode((String)((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getIsUpgrades()));
            row.createCell(2).setCellValue(((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getVerdictDate());
            row.createCell(3).setCellValue(((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getAmountWithTax());
            row.createCell(4).setCellValue(((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getSettlementNo());
            row.createCell(5).setCellValue(AllType.billDeductSettlementStatusEnum.getMsgByCode((String)((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getSettlementStatus()));
            row.createCell(6).setCellValue(((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getRedNotificationNo());
            row.createCell(7).setCellValue(AllType.redNotificationEnum.getMsgByCode((String)((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getRedNotificationStatus()));
            row.createCell(8).setCellValue(((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getRedNotificationApplyDate());
            row.createCell(9).setCellValue(((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getRedNotificationApproveDate());
            row.createCell(10).setCellValue(((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getRedLetterNo());
            row.createCell(11).setCellValue(AllType.billDeductUpgradesApplyingStatusEnum.getMsgByCode((String)((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getUpgradesApplyingStatus()));
            row.createCell(12).setCellValue(DateUtils.format((Date)DateUtils.stringToDate((String)((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss.SSS"), (String)"yyyy-MM-dd"));
            row.createCell(13).setCellValue(DateUtils.format((Date)DateUtils.stringToDate((String)((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getApplySuccessTime(), (String)"yyyy-MM-dd HH:mm:ss.SSS"), (String)"yyyy-MM-dd"));
            row.createCell(14).setCellValue(AllType.redInvoiceEnum.getMsgByCode((String)((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getRedInvoiceStatus()));
            row.createCell(15).setCellValue(((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getRedInvoiceDate());
            row.createCell(16).setCellValue(((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getRedInvoiceDate());
            row.createCell(17).setCellValue(((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getBlueInvoiceNo());
            row.createCell(18).setCellValue(((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getBlueInvoiceCode());
            row.createCell(19).setCellValue(((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getBlueInvoiceDate());
            row.createCell(20).setCellValue(((ProtocolQueryRedNotifiVO)protocolQueryRedNotifiVOs.get(i)).getAgreementDocumentNumber());
        }
        for (i = 0; i < protocolQueryExceptionVOs.size(); ++i) {
            row = sheet2.createRow(i + 1);
            row.createCell(0).setCellValue(((ProtocolQueryExceptionVO)protocolQueryExceptionVOs.get(i)).getBusinessNo());
            row.createCell(1).setCellValue(((ProtocolQueryExceptionVO)protocolQueryExceptionVOs.get(i)).getVerdictDate());
            row.createCell(2).setCellValue(((ProtocolQueryExceptionVO)protocolQueryExceptionVOs.get(i)).getAmountWithTax());
            row.createCell(3).setCellValue(((ProtocolQueryExceptionVO)protocolQueryExceptionVOs.get(i)).getCode());
            row.createCell(4).setCellValue(((ProtocolQueryExceptionVO)protocolQueryExceptionVOs.get(i)).getDescription());
            row.createCell(5).setCellValue(((ProtocolQueryExceptionVO)protocolQueryExceptionVOs.get(i)).getAgreementDocumentNumber());
        }
    }

    private static void chcCheckQuery(Sheet sheet0, List model4s, CellStyle cellStyle) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setFillBackgroundColor(IndexedColors.WHITE.getIndex());
        String[] head0 = new String[]{"\u9500\u552e\u6e05\u5355", "", "", "", "\u6210\u54c1\u6cb9", "", "\u975e\u6210\u54c1\u6cb9", "", "\u5f85\u5f00\u84dd\u7968", "", "\u9500\u552e\u6e05\u5355\u4e0e\u5f85\u5f00\u84dd\u7968\u5dee\u5f02", "", "\u6210\u54c1\u6cb9&\u975e\u6210\u54c1\u6cb9\u4e0e\u5f85\u5f00\u84dd\u7968\u5dee\u5f02", ""};
        String[] headnum0 = new String[]{"0,0,0,3", "0,0,4,5", "0,0,6,7", "0,0,8,9", "0,0,10,11", "0,0,12,13"};
        Row row0 = sheet0.createRow(0);
        for (int i = 0; i < head0.length; ++i) {
            Cell cell = row0.createCell(i);
            cell.setCellValue(head0[i]);
            cell.setCellStyle(cellStyle);
        }
        for (int j = 0; j < headnum0.length; ++j) {
            String[] temp = headnum0[j].split(",");
            Integer startrow = Integer.parseInt(temp[0]);
            Integer overrow = Integer.parseInt(temp[1]);
            Integer startcol = Integer.parseInt(temp[2]);
            Integer overcol = Integer.parseInt(temp[3]);
            sheet0.addMergedRegion(new CellRangeAddress(startrow.intValue(), overrow.intValue(), startcol.intValue(), overcol.intValue()));
        }
        Row row = sheet0.createRow(1);
        List<String> strings = Arrays.asList(ExcelTypeConfig.chcCheckQueryTitleList);
        for (int i = 0; i < strings.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(strings.get(i));
            cell.setCellStyle(cellStyle);
        }
        List mapList = model4s;
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < mapList.size(); ++i) {
            Row row1 = sheet0.createRow(i + 2);
            row1.createCell(0).setCellValue(((ReportChcCheck)mapList.get(i)).getJv());
            row1.createCell(1).setCellValue(((ReportChcCheck)mapList.get(i)).getTaxRate());
            row1.createCell(2).setCellValue(((ReportChcCheck)mapList.get(i)).getSalesAmount() == null ? "" : String.valueOf(((ReportChcCheck)mapList.get(i)).getSalesAmount()));
            row1.createCell(3).setCellValue(((ReportChcCheck)mapList.get(i)).getSalesTaxAmount() == null ? "" : String.valueOf(((ReportChcCheck)mapList.get(i)).getSalesTaxAmount()));
            row1.createCell(4).setCellValue(((ReportChcCheck)mapList.get(i)).getOilSalesAmount() == null ? "" : String.valueOf(((ReportChcCheck)mapList.get(i)).getOilSalesAmount()));
            row1.createCell(5).setCellValue(((ReportChcCheck)mapList.get(i)).getOilSalesTaxAmount() == null ? "" : String.valueOf(((ReportChcCheck)mapList.get(i)).getOilSalesTaxAmount()));
            row1.createCell(6).setCellValue(((ReportChcCheck)mapList.get(i)).getFOilSalesAmount() == null ? "" : String.valueOf(((ReportChcCheck)mapList.get(i)).getFOilSalesAmount()));
            row1.createCell(7).setCellValue(((ReportChcCheck)mapList.get(i)).getFOilSalesTaxAmount() == null ? "" : String.valueOf(((ReportChcCheck)mapList.get(i)).getFOilSalesTaxAmount()));
            row1.createCell(8).setCellValue(((ReportChcCheck)mapList.get(i)).getAmountWithoutTax() == null ? "" : String.valueOf(((ReportChcCheck)mapList.get(i)).getAmountWithoutTax()));
            row1.createCell(9).setCellValue(((ReportChcCheck)mapList.get(i)).getTaxAmount() == null ? "" : String.valueOf(((ReportChcCheck)mapList.get(i)).getTaxAmount()));
            row1.createCell(10).setCellValue(((ReportChcCheck)mapList.get(i)).getDifferenceSalesAmount() == null ? "" : String.valueOf(((ReportChcCheck)mapList.get(i)).getDifferenceSalesAmount()));
            row1.createCell(11).setCellValue(((ReportChcCheck)mapList.get(i)).getDifferenceSalesTaxAmount() == null ? "" : String.valueOf(((ReportChcCheck)mapList.get(i)).getDifferenceSalesTaxAmount()));
            row1.createCell(12).setCellValue(((ReportChcCheck)mapList.get(i)).getDifferenceAmount() == null ? "" : String.valueOf(((ReportChcCheck)mapList.get(i)).getDifferenceAmount()));
            row1.createCell(13).setCellValue(((ReportChcCheck)mapList.get(i)).getDifferenceTaxAmount() == null ? "" : String.valueOf(((ReportChcCheck)mapList.get(i)).getDifferenceTaxAmount()));
        }
    }

    private static void fsInvoiceDetails(Sheet sheet0, List list, CellStyle titleCell) {
        Row row = sheet0.createRow(0);
        List<String> strings = Arrays.asList(ExcelTypeConfig.FS_INVOICE_DETAILS_TitleList);
        for (int i = 0; i < strings.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(strings.get(i));
            cell.setCellStyle(titleCell);
        }
        List mapList = list;
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < mapList.size(); ++i) {
            Row row1 = sheet0.createRow(i + 1);
            row1.createCell(0).setCellValue(AllType.AuthStatusEnum.getMsgByCode((String)((InvoiceDetailVO)mapList.get(i)).getAuthStatus()));
            row1.createCell(1).setCellValue(((InvoiceDetailVO)mapList.get(i)).getRzhBelongDate());
            row1.createCell(2).setCellValue(DateUtils.format((Date)((InvoiceDetailVO)mapList.get(i)).getConfirmDate()));
            row1.createCell(3).setCellValue(((InvoiceDetailVO)mapList.get(i)).getJvcode());
            row1.createCell(4).setCellValue(AllType.BussinessEnum.getMsgByCode((String)((InvoiceDetailVO)mapList.get(i)).getBussinessType()));
            if (!StringUtils.isEmpty((String)((InvoiceDetailVO)mapList.get(i)).getStoreStart()) && !StringUtils.isEmpty((String)((InvoiceDetailVO)mapList.get(i)).getStoreEnd())) {
                row1.createCell(5).setCellValue(((InvoiceDetailVO)mapList.get(i)).getStoreStart() + "\u81f3" + ((InvoiceDetailVO)mapList.get(i)).getStoreEnd());
            }
            row1.createCell(6).setCellValue(((InvoiceDetailVO)mapList.get(i)).getStoreNo());
            row1.createCell(7).setCellValue(((InvoiceDetailVO)mapList.get(i)).getVenderId());
            row1.createCell(8).setCellValue(DateUtils.format((Date)((InvoiceDetailVO)mapList.get(i)).getCreateTime()));
            row1.createCell(9).setCellValue(((InvoiceDetailVO)mapList.get(i)).getBussinessNo());
            row1.createCell(10).setCellValue(AllType.InvoiceTypesEnum.getMsgByCode((String)((InvoiceDetailVO)mapList.get(i)).getInvoiceType()));
            row1.createCell(11).setCellValue("");
            row1.createCell(12).setCellValue(((InvoiceDetailVO)mapList.get(i)).getPurchaserNo());
            row1.createCell(13).setCellValue(((InvoiceDetailVO)mapList.get(i)).getGfName());
            row1.createCell(14).setCellValue(((InvoiceDetailVO)mapList.get(i)).getGfTaxNo());
            row1.createCell(15).setCellValue(((InvoiceDetailVO)mapList.get(i)).getGfAddressAndPhone());
            row1.createCell(16).setCellValue(((InvoiceDetailVO)mapList.get(i)).getGfBankAndNo());
            row1.createCell(17).setCellValue(((InvoiceDetailVO)mapList.get(i)).getXfName());
            row1.createCell(18).setCellValue(((InvoiceDetailVO)mapList.get(i)).getXfTaxNo());
            row1.createCell(19).setCellValue(((InvoiceDetailVO)mapList.get(i)).getXfAddressAndPhone());
            row1.createCell(20).setCellValue(((InvoiceDetailVO)mapList.get(i)).getXfBankAndNo());
            row1.createCell(21).setCellValue(((InvoiceDetailVO)mapList.get(i)).getGoodsName());
            row1.createCell(22).setCellValue(((InvoiceDetailVO)mapList.get(i)).getUnit());
            row1.createCell(23).setCellValue(((InvoiceDetailVO)mapList.get(i)).getNum());
            row1.createCell(24).setCellValue(((InvoiceDetailVO)mapList.get(i)).getTaxRate());
            row1.createCell(25).setCellValue(((InvoiceDetailVO)mapList.get(i)).getUnitPrice());
            row1.createCell(26).setCellValue(((InvoiceDetailVO)mapList.get(i)).getDetailAmount() == null ? "" : String.valueOf(((InvoiceDetailVO)mapList.get(i)).getDetailAmount()));
            row1.createCell(27).setCellValue(((InvoiceDetailVO)mapList.get(i)).getTaxAmount() == null ? "" : String.valueOf(((InvoiceDetailVO)mapList.get(i)).getTaxAmount()));
            if (((InvoiceDetailVO)mapList.get(i)).getDetailAmount() != null && ((InvoiceDetailVO)mapList.get(i)).getTaxAmount() != null) {
                row1.createCell(28).setCellValue("" + ((InvoiceDetailVO)mapList.get(i)).getDetailAmount().add(((InvoiceDetailVO)mapList.get(i)).getTaxAmount()));
            }
            row1.createCell(29).setCellValue(((InvoiceDetailVO)mapList.get(i)).getRemark());
            row1.createCell(30).setCellValue(((InvoiceDetailVO)mapList.get(i)).getInvoiceNo());
            row1.createCell(31).setCellValue(((InvoiceDetailVO)mapList.get(i)).getInvoiceCode());
            row1.createCell(32).setCellValue(DateUtils.format((Date)((InvoiceDetailVO)mapList.get(i)).getInvoiceDate(), (String)"yyyy-MM-dd"));
            row1.createCell(33).setCellValue(((InvoiceDetailVO)mapList.get(i)).getInvoiceAmount());
            row1.createCell(34).setCellValue(((InvoiceDetailVO)mapList.get(i)).getTaxAmountMain());
            row1.createCell(35).setCellValue(((InvoiceDetailVO)mapList.get(i)).getTotalAmount());
        }
    }

    private static void fsInvoice(Sheet sheet0, List list, CellStyle titleCell) {
        Row row = sheet0.createRow(0);
        List<String> strings = Arrays.asList(ExcelTypeConfig.FS_INVOICE_TitleList);
        for (int i = 0; i < strings.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(strings.get(i));
            cell.setCellStyle(titleCell);
        }
        List mapList = list;
        for (int i = 0; i < mapList.size(); ++i) {
            Row row1 = sheet0.createRow(i + 1);
            String storeStart = ((RecordInvoiceVO)mapList.get(i)).getStoreStart();
            if (!StringUtils.isEmpty((String)storeStart)) {
                String yyyyMM = DateUtils.format((Date)DateUtils.stringToDate((String)storeStart, (String)"yyyy-MM-dd"), (String)"yyyyMM");
                row1.createCell(0).setCellValue(yyyyMM);
            }
            row1.createCell(1).setCellValue("");
            row1.createCell(2).setCellValue("");
            row1.createCell(3).setCellValue(((RecordInvoiceVO)mapList.get(i)).getJvcode());
            row1.createCell(4).setCellValue(((RecordInvoiceVO)mapList.get(i)).getInvoiceCode());
            row1.createCell(5).setCellValue(((RecordInvoiceVO)mapList.get(i)).getInvoiceNo());
            row1.createCell(6).setCellValue("");
            row1.createCell(7).setCellValue("");
            row1.createCell(8).setCellValue(((RecordInvoiceVO)mapList.get(i)).getSupplierNumber());
            row1.createCell(9).setCellValue(((RecordInvoiceVO)mapList.get(i)).getVendername());
            row1.createCell(10).setCellValue(((RecordInvoiceVO)mapList.get(i)).getStoreNo());
            row1.createCell(11).setCellValue(((RecordInvoiceVO)mapList.get(i)).getTaxAmount() == null ? "" : String.valueOf(((RecordInvoiceVO)mapList.get(i)).getTaxAmount()));
            row1.createCell(12).setCellValue(((RecordInvoiceVO)mapList.get(i)).getTaxCode());
            row1.createCell(13).setCellValue(((RecordInvoiceVO)mapList.get(i)).getTaxRate());
            row1.createCell(14).setCellValue(((RecordInvoiceVO)mapList.get(i)).getAmountWithTax() == null ? "" : String.valueOf(((RecordInvoiceVO)mapList.get(i)).getAmountWithTax()));
            row1.createCell(15).setCellValue(((RecordInvoiceVO)mapList.get(i)).getAmountWithoutTax() == null ? "" : String.valueOf(((RecordInvoiceVO)mapList.get(i)).getAmountWithoutTax()));
            row1.createCell(16).setCellValue("");
            row1.createCell(17).setCellValue(((RecordInvoiceVO)mapList.get(i)).getInvoiceDate());
            row1.createCell(18).setCellValue("");
            row1.createCell(19).setCellValue(((RecordInvoiceVO)mapList.get(i)).getRemark());
            row1.createCell(20).setCellValue("");
            row1.createCell(21).setCellValue(AllType.BussinessEnum.getMsgByCode((String)((RecordInvoiceVO)mapList.get(i)).getBussinessType()));
            row1.createCell(22).setCellValue("");
            row1.createCell(23).setCellValue("");
            row1.createCell(24).setCellValue("");
            row1.createCell(25).setCellValue("");
            row1.createCell(26).setCellValue("");
            row1.createCell(27).setCellValue("");
            row1.createCell(28).setCellValue("");
            row1.createCell(29).setCellValue(((RecordInvoiceVO)mapList.get(i)).getClassA());
            row1.createCell(30).setCellValue(AllType.InvoiceTypesEnum.getMsgByCode((String)((RecordInvoiceVO)mapList.get(i)).getInvoiceType()));
            row1.createCell(31).setCellValue(((RecordInvoiceVO)mapList.get(i)).getFunctionGroup());
            row1.createCell(32).setCellValue("");
            row1.createCell(33).setCellValue("");
            row1.createCell(34).setCellValue("");
            row1.createCell(35).setCellValue("" + ((RecordInvoiceVO)mapList.get(i)).getInvoiceCode() + ((RecordInvoiceVO)mapList.get(i)).getInvoiceNo());
            row1.createCell(36).setCellValue(((RecordInvoiceVO)mapList.get(i)).getGfTaxNo());
            row1.createCell(37).setCellValue(((RecordInvoiceVO)mapList.get(i)).getGfName());
            row1.createCell(38).setCellValue(((RecordInvoiceVO)mapList.get(i)).getXfTaxNo());
            row1.createCell(39).setCellValue(((RecordInvoiceVO)mapList.get(i)).getXfName());
            row1.createCell(40).setCellValue("");
            row1.createCell(41).setCellValue(((RecordInvoiceVO)mapList.get(i)).getInvoiceRemark());
            row1.createCell(42).setCellValue(AllType.AuthStatusEnum.getMsgByCode((String)((RecordInvoiceVO)mapList.get(i)).getAuthStatus()));
            row1.createCell(43).setCellValue(((RecordInvoiceVO)mapList.get(i)).getRzhBelongDate());
            row1.createCell(44).setCellValue(DateUtils.format((Date)((RecordInvoiceVO)mapList.get(i)).getConfirmDate(), (String)"yyyy-MM-dd"));
            row1.createCell(45).setCellValue(((RecordInvoiceVO)mapList.get(i)).getInvoiceStoreNo());
        }
    }

    private static void epdReport(Sheet sheet0, List list, CellStyle titleCell) {
        Row row = sheet0.createRow(0);
        List<String> strings = Arrays.asList(ExcelTypeConfig.epdReportTitleList);
        for (int i = 0; i < strings.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(strings.get(i));
            cell.setCellStyle(titleCell);
        }
        List mapList = list;
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < mapList.size(); ++i) {
            Row row1 = sheet0.createRow(i + 1);
            row1.createCell(0).setCellValue(((EpdVO)mapList.get(i)).getPurchaserName());
            row1.createCell(1).setCellValue(((EpdVO)mapList.get(i)).getAgreementMemo());
            row1.createCell(2).setCellValue(((EpdVO)mapList.get(i)).getSellerNo());
            row1.createCell(3).setCellValue(((EpdVO)mapList.get(i)).getSellerName());
            row1.createCell(4).setCellValue(((EpdVO)mapList.get(i)).getDeductDate());
            row1.createCell(5).setCellValue(((EpdVO)mapList.get(i)).getBusinessNo());
            row1.createCell(6).setCellValue(((EpdVO)mapList.get(i)).getRefSettlementNo());
            row1.createCell(7).setCellValue(((EpdVO)mapList.get(i)).getAmountWithTax());
            row1.createCell(8).setCellValue(((EpdVO)mapList.get(i)).getTaxRate());
            row1.createCell(9).setCellValue(((EpdVO)mapList.get(i)).getAmountWithoutTax());
            row1.createCell(10).setCellValue(((EpdVO)mapList.get(i)).getTaxAmount());
            row1.createCell(11).setCellValue(((EpdVO)mapList.get(i)).getAgreementTaxCode());
            row1.createCell(13).setCellValue(((EpdVO)mapList.get(i)).getAgreementDocumentType());
            row1.createCell(14).setCellValue(((EpdVO)mapList.get(i)).getAgreementDocumentNumber());
            row1.createCell(15).setCellValue(((EpdVO)mapList.get(i)).getVerdictDate());
            row1.createCell(16).setCellValue(((EpdVO)mapList.get(i)).getStatus());
            row1.createCell(17).setCellValue(((EpdVO)mapList.get(i)).getBatchNo());
            row1.createCell(18).setCellValue(((EpdVO)mapList.get(i)).getCreateTime());
            row1.createCell(19).setCellValue(((EpdVO)mapList.get(i)).getCode());
            row1.createCell(20).setCellValue(((EpdVO)mapList.get(i)).getDescription());
            row1.createCell(21).setCellValue(((EpdVO)mapList.get(i)).getSettlementStatus());
            row1.createCell(22).setCellValue(((EpdVO)mapList.get(i)).getInvoiceDate());
            row1.createCell(23).setCellValue(((EpdVO)mapList.get(i)).getRedNotificationNo());
            row1.createCell(24).setCellValue(((EpdVO)mapList.get(i)).getOriginInvoiceNo());
            row1.createCell(25).setCellValue(((EpdVO)mapList.get(i)).getUpdateDate());
            row1.createCell(26).setCellValue(((EpdVO)mapList.get(i)).getRevertRemark());
            row1.createCell(28).setCellValue(((EpdVO)mapList.get(i)).getBlueInvoiceNo());
            row1.createCell(29).setCellValue(((EpdVO)mapList.get(i)).getBlueInvoiceCode());
            row1.createCell(30).setCellValue(((EpdVO)mapList.get(i)).getBlueInvoiceDate());
        }
    }

    private static void chcSellerInvoice(Sheet sheet0, List list, CellStyle titleCell) {
        Row row = sheet0.createRow(0);
        List<String> strings = Arrays.asList(ExcelTypeConfig.CHC_SELLER_INVOICE_TitleList);
        for (int i = 0; i < strings.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(strings.get(i));
            cell.setCellStyle(titleCell);
        }
        List mapList = list;
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < mapList.size(); ++i) {
            Row row1 = sheet0.createRow(i + 1);
            row1.createCell(0).setCellValue(AllType.ChcInvoiceEnum.getMsgByCode((String)((TXfSellerInvoiceVO)mapList.get(i)).getInvoiceType()));
            row1.createCell(1).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getInvoiceCode());
            row1.createCell(2).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getInvoiceNo());
            row1.createCell(3).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getMachineNo());
            row1.createCell(4).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getPurchaserName());
            row1.createCell(5).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getPurchaserTaxNo());
            row1.createCell(6).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getPurchaserAddrTel());
            row1.createCell(7).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getPurchaserBankAccount());
            row1.createCell(8).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getPaperDrewDate());
            row1.createCell(11).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getRelevancyPeriod());
            row1.createCell(12).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getAmountWithoutTax().doubleValue());
            row1.createCell(13).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getTaxRate().doubleValue());
            row1.createCell(14).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getTaxAmount().doubleValue());
            row1.createCell(15).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getCargoName());
            row1.createCell(17).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getRemark());
            row1.createCell(18).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getInvoicerName());
            row1.createCell(19).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getCashierName());
            row1.createCell(20).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getExt8());
            row1.createCell(21).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getInvalidateFlag());
            row1.createCell(24).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getCheckerName());
            row1.createCell(25).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getDeposeTime());
            row1.createCell(26).setCellValue(AllType.ChcInvoiceStatusEnum.getMsgByCode((String)((TXfSellerInvoiceVO)mapList.get(i)).getStatus()));
            row1.createCell(27).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getCheckCode());
        }
    }

    private static void chcSellerRedInvoice(Sheet sheet0, List list, CellStyle titleCell) {
        Row row = sheet0.createRow(0);
        List<String> strings = Arrays.asList(ExcelTypeConfig.CHC_SELLER_RED_INVOICE_TitleList);
        for (int i = 0; i < strings.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(strings.get(i));
            cell.setCellStyle(titleCell);
        }
        List mapList = list;
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < mapList.size(); ++i) {
            Row row1 = sheet0.createRow(i + 1);
            row1.createCell(0).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getRelevancyPeriod());
            row1.createCell(1).setCellValue(AllType.ChcInvoiceEnum.getMsgByCode((String)((TXfSellerInvoiceVO)mapList.get(i)).getInvoiceType()));
            row1.createCell(2).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getInvoiceCode());
            row1.createCell(3).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getInvoiceNo());
            row1.createCell(4).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getMachineNo());
            row1.createCell(5).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getJvCode());
            row1.createCell(6).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getPurchaserName());
            row1.createCell(7).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getPurchaserTaxNo());
            row1.createCell(8).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getPurchaserAddrTel());
            row1.createCell(9).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getPurchaserBankAccount());
            row1.createCell(10).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getPaperDrewDate());
            row1.createCell(11).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getCargoName());
            row1.createCell(14).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getAmountWithoutTax().doubleValue());
            row1.createCell(15).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getTaxRate().doubleValue());
            row1.createCell(16).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getTaxAmount().doubleValue());
            row1.createCell(17).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getRemark());
            row1.createCell(18).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getExt7());
            row1.createCell(19).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getExt8());
            row1.createCell(20).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getInvalidateFlag());
            row1.createCell(21).setCellValue(AllType.ChcInvoiceStatusEnum.getMsgByCode((String)((TXfSellerInvoiceVO)mapList.get(i)).getStatus()));
            row1.createCell(22).setCellValue(((TXfSellerInvoiceVO)mapList.get(i)).getDeposeTime());
        }
    }

    private static void recodeInvoice(Sheet sheet0, List list, CellStyle titleCell) {
        Row row = sheet0.createRow(0);
        List<String> strings = Arrays.asList(ExcelTypeConfig.RECORD_INVOICE_TitleList);
        for (int i = 0; i < strings.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(strings.get(i));
            cell.setCellStyle(titleCell);
        }
        List mapList = list;
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        for (int i = 0; i < mapList.size(); ++i) {
            Row row1 = sheet0.createRow(i + 1);
            row1.createCell(0).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getNo());
            row1.createCell(1).setCellValue(AllType.ChcInvoiceEnum.getMsgByCode((String)((SellerInvoiceItemVO)mapList.get(i)).getInvoiceType()));
            row1.createCell(2).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getInvoiceCode());
            row1.createCell(3).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getInvoiceNo());
            row1.createCell(4).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getMachineNo());
            row1.createCell(5).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getJvCode());
            row1.createCell(6).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getPurchaserName());
            row1.createCell(7).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getPurchaserTaxNo());
            row1.createCell(8).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getPurchaserAddrTel());
            row1.createCell(9).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getPurchaserBankAccount());
            row1.createCell(10).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getPaperDrewDate());
            row1.createCell(11).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getCargoName());
            row1.createCell(12).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getItemSpec());
            row1.createCell(13).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getQuantityUnit());
            row1.createCell(14).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getUnitPrice() == null ? "" : "" + ((SellerInvoiceItemVO)mapList.get(i)).getUnitPrice());
            row1.createCell(15).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getQuantity());
            row1.createCell(16).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getAmountWithoutTax());
            row1.createCell(17).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getTaxRate());
            row1.createCell(18).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getTaxAmount());
            row1.createCell(19).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getCargoCode());
            row1.createCell(20).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getMatchSettlementNo());
            row1.createCell(21).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getRelevancyPeriod());
            row1.createCell(22).setCellValue(AllType.DeleteFlagStatusEnum.getMsgByCode((String)((SellerInvoiceItemVO)mapList.get(i)).getStatus()));
            row1.createCell(23).setCellValue(((SellerInvoiceItemVO)mapList.get(i)).getRemark());
        }
    }

    private static void claimTaxStatement(Sheet sheet0, List list, CellStyle titleCell) {
        titleCell.setAlignment(HorizontalAlignment.CENTER);
        titleCell.setVerticalAlignment(VerticalAlignment.CENTER);
        Row row_0 = sheet0.createRow(0);
        Row row_1 = sheet0.createRow(1);
        List<String> strings = Arrays.asList(ExcelTypeConfig.claimTaxStatementTitleList);
        List mouthStr = DateUtils.getTwoYearFromNew((Date)new Date());
        Collections.reverse(mouthStr);
        Iterator iterator = mouthStr.iterator();
        for (int i = 0; i < strings.size(); ++i) {
            Cell cell_0 = row_0.createCell(i);
            Cell cell_1 = row_1.createCell(i);
            if (36 <= i && i <= 83) {
                if (i % 2 == 0) {
                    CellRangeAddress region1 = new CellRangeAddress(0, 0, i, i + 1);
                    cell_0.setCellValue((String)iterator.next());
                    cell_0.setCellStyle(titleCell);
                    sheet0.addMergedRegion(region1);
                }
                cell_1.setCellValue(strings.get(i));
                cell_1.setCellStyle(titleCell);
                continue;
            }
            cell_0.setCellValue(strings.get(i));
            cell_0.setCellStyle(titleCell);
            CellRangeAddress region = new CellRangeAddress(0, 1, i, i);
            sheet0.addMergedRegion(region);
        }
        List mapList = list;
        for (int i = 0; i < mapList.size(); ++i) {
            List redStatisticsList = ((ReportClaimStatistic)mapList.get(i)).getRedStatisticsList();
            Row row1 = sheet0.createRow(i + 2);
            row1.createCell(0).setCellValue(((ReportClaimStatistic)mapList.get(i)).getCompanyCode());
            row1.createCell(1).setCellValue(((ReportClaimStatistic)mapList.get(i)).getSubject());
            row1.createCell(2).setCellValue(((ReportClaimStatistic)mapList.get(i)).getAllocation());
            row1.createCell(3).setCellValue(((ReportClaimStatistic)mapList.get(i)).getCertificateNo());
            row1.createCell(4).setCellValue(((ReportClaimStatistic)mapList.get(i)).getBusinessScope());
            row1.createCell(5).setCellValue(((ReportClaimStatistic)mapList.get(i)).getCertificateType());
            row1.createCell(6).setCellValue(((ReportClaimStatistic)mapList.get(i)).getPostingDate());
            row1.createCell(7).setCellValue(((ReportClaimStatistic)mapList.get(i)).getCertificateDate());
            row1.createCell(8).setCellValue(((ReportClaimStatistic)mapList.get(i)).getAccountingCode());
            if (((ReportClaimStatistic)mapList.get(i)).getStandardCurrencyAmount() == null) {
                row1.createCell(9).setCellValue("");
            } else {
                String s = String.valueOf(((ReportClaimStatistic)mapList.get(i)).getStandardCurrencyAmount());
                if (s.indexOf(".") > 0) {
                    s = s.replaceAll("0+?$", "");
                    s = s.replaceAll("[.]$", "");
                }
                row1.createCell(9).setCellValue(s);
            }
            row1.createCell(10).setCellValue(((ReportClaimStatistic)mapList.get(i)).getStandardCurrency());
            row1.createCell(11).setCellValue(((ReportClaimStatistic)mapList.get(i)).getTaxCode());
            row1.createCell(12).setCellValue(((ReportClaimStatistic)mapList.get(i)).getClearCertificate());
            row1.createCell(13).setCellValue(((ReportClaimStatistic)mapList.get(i)).getProfitCenter());
            row1.createCell(14).setCellValue(((ReportClaimStatistic)mapList.get(i)).getDuan());
            row1.createCell(15).setCellValue(((ReportClaimStatistic)mapList.get(i)).getTextContent());
            row1.createCell(16).setCellValue(((ReportClaimStatistic)mapList.get(i)).getReverseSubjectType());
            row1.createCell(17).setCellValue(((ReportClaimStatistic)mapList.get(i)).getReverseSubjectAccount());
            row1.createCell(18).setCellValue(((ReportClaimStatistic)mapList.get(i)).getPartner());
            row1.createCell(19).setCellValue(((ReportClaimStatistic)mapList.get(i)).getCertificateTitle());
            row1.createCell(20).setCellValue(((ReportClaimStatistic)mapList.get(i)).getReferenceCodeBt1());
            row1.createCell(21).setCellValue(((ReportClaimStatistic)mapList.get(i)).getReferenceCodeTt1());
            row1.createCell(22).setCellValue(((ReportClaimStatistic)mapList.get(i)).getReferenceCode1());
            row1.createCell(23).setCellValue(((ReportClaimStatistic)mapList.get(i)).getReferenceCode2());
            row1.createCell(24).setCellValue(((ReportClaimStatistic)mapList.get(i)).getReference());
            row1.createCell(25).setCellValue(((ReportClaimStatistic)mapList.get(i)).getInvoiceReference());
            row1.createCell(26).setCellValue(((ReportClaimStatistic)mapList.get(i)).getDateMonth());
            row1.createCell(27).setCellValue(((ReportClaimStatistic)mapList.get(i)).getBlueInvoiceNo());
            row1.createCell(28).setCellValue(((ReportClaimStatistic)mapList.get(i)).getSupplierNo());
            row1.createCell(29).setCellValue(((ReportClaimStatistic)mapList.get(i)).getSupplierName());
            row1.createCell(30).setCellValue(((ReportClaimStatistic)mapList.get(i)).getSupplierDInvoice());
            row1.createCell(31).setCellValue(((ReportClaimStatistic)mapList.get(i)).getClaimAmountWithTax() == null ? "" : String.valueOf(((ReportClaimStatistic)mapList.get(i)).getClaimAmountWithTax()));
            row1.createCell(32).setCellValue(((ReportClaimStatistic)mapList.get(i)).getClaimTaxAmount() == null ? "" : String.valueOf(((ReportClaimStatistic)mapList.get(i)).getClaimTaxAmount()));
            row1.createCell(33).setCellValue(((ReportClaimStatistic)mapList.get(i)).getDifferenceTaxAmount() == null ? "" : String.valueOf(((ReportClaimStatistic)mapList.get(i)).getDifferenceTaxAmount()));
            row1.createCell(34).setCellValue(((ReportClaimStatistic)mapList.get(i)).getZeroClaimAmountWithTax() == null ? "" : String.valueOf(((ReportClaimStatistic)mapList.get(i)).getZeroClaimAmountWithTax()));
            row1.createCell(35).setCellValue(((ReportClaimStatistic)mapList.get(i)).getZeroClaimTaxAmount() == null ? "" : String.valueOf(((ReportClaimStatistic)mapList.get(i)).getZeroClaimTaxAmount()));
            if (!CollectionUtils.isEmpty((Collection)redStatisticsList)) {
                int o = 36;
                BigDecimal reverTaxAmount = new BigDecimal("0");
                BigDecimal reverAmountWithTax = new BigDecimal("0");
                ArrayList<String> reverMonths = new ArrayList<String>();
                for (ReportClaimRedStatistic details : redStatisticsList) {
                    int monthDifferent = DateUtils.getMonthDifferent((String)details.getRedDate());
                    int xiuZhengZhi = 23 - monthDifferent;
                    if (xiuZhengZhi >= 0) {
                        row1.createCell(o + 2 * xiuZhengZhi).setCellValue("" + details.getApplyRedNotificationAmountWithTax());
                        row1.createCell(o + 2 * xiuZhengZhi + 1).setCellValue("" + details.getApplyRedNotificationTaxAmount());
                    }
                    if (details.getReverseRedNotificationAmountWithTax() == null) continue;
                    reverTaxAmount = reverTaxAmount.add(details.getReverseRedNotificationTaxAmount());
                    reverAmountWithTax = reverAmountWithTax.add(details.getReverseRedNotificationAmountWithTax());
                    reverMonths.add(details.getRedDate());
                }
                row1.createCell(84).setCellValue(reverAmountWithTax == null ? "" : String.valueOf(reverAmountWithTax));
                row1.createCell(85).setCellValue(reverTaxAmount == null ? "" : String.valueOf(reverTaxAmount));
                row1.createCell(86).setCellValue(String.join((CharSequence)",", reverMonths));
            }
            row1.createCell(87).setCellValue(((ReportClaimStatistic)mapList.get(i)).getCheckBalanceAmount() == null ? "" : String.valueOf(((ReportClaimStatistic)mapList.get(i)).getCheckBalanceAmount()));
            row1.createCell(88).setCellValue(((ReportClaimStatistic)mapList.get(i)).getApplyAmount() == null ? "" : String.valueOf(((ReportClaimStatistic)mapList.get(i)).getApplyAmount()));
            row1.createCell(89).setCellValue(((ReportClaimStatistic)mapList.get(i)).getDealTime() == null ? "" : String.valueOf(((ReportClaimStatistic)mapList.get(i)).getDealTime()));
            row1.createCell(90).setCellValue(((ReportClaimStatistic)mapList.get(i)).getUnsettledAmountWithTax() == null ? "" : String.valueOf(((ReportClaimStatistic)mapList.get(i)).getUnsettledAmountWithTax()));
            row1.createCell(91).setCellValue(((ReportClaimStatistic)mapList.get(i)).getUnsettledTaxAmount() == null ? "" : String.valueOf(((ReportClaimStatistic)mapList.get(i)).getUnsettledTaxAmount()));
        }
    }

    public static void reportAESTitle(Sheet sheet0, CellStyle titleCell) {
        Row row = sheet0.createRow(0);
        List<String> strings = Arrays.asList(ExcelTypeConfig.REPORT_AGGREMENT_EPD_STATISTIC_TITLE);
        for (int i = 0; i < strings.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(strings.get(i));
            cell.setCellStyle(titleCell);
        }
    }

    public static void reportAESCell(int startRow, Sheet sheet0, List list, CellStyle titleCell) {
        List mapList = list;
        for (int i = 0; i < mapList.size(); ++i) {
            Row row1 = sheet0.createRow(i + startRow);
            ReportAggrementEpdStatistic info = (ReportAggrementEpdStatistic)mapList.get(i);
            row1.createCell(0).setCellValue(info.getCompanyCode());
            row1.createCell(1).setCellValue(info.getSubject());
            row1.createCell(2).setCellValue(info.getAllocation());
            row1.createCell(3).setCellValue(info.getCertificateNo());
            row1.createCell(4).setCellValue(info.getBusinessScope());
            row1.createCell(5).setCellValue(info.getCertificateType());
            row1.createCell(6).setCellValue(info.getPostingDate());
            row1.createCell(7).setCellValue(info.getCertificateDate());
            row1.createCell(8).setCellValue(info.getAccountingCode());
            row1.createCell(9).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getStandardCurrencyAmount()));
            row1.createCell(10).setCellValue(info.getStandardCurrency());
            row1.createCell(11).setCellValue(info.getTaxCode());
            row1.createCell(12).setCellValue(info.getClearCertificate());
            row1.createCell(13).setCellValue(info.getProfitCenter());
            row1.createCell(14).setCellValue(info.getDuan());
            row1.createCell(15).setCellValue(info.getTextContent());
            row1.createCell(16).setCellValue(info.getReverseSubjectType());
            row1.createCell(17).setCellValue(info.getReverseSubjectAccount());
            row1.createCell(18).setCellValue(info.getPartner());
            row1.createCell(19).setCellValue(info.getCertificateTitle());
            row1.createCell(20).setCellValue(info.getReferenceCodeBt1());
            row1.createCell(21).setCellValue(info.getReferenceCodeTt1());
            row1.createCell(22).setCellValue(info.getReferenceCode1());
            row1.createCell(23).setCellValue(info.getReferenceCode2());
            row1.createCell(24).setCellValue(info.getReference());
            row1.createCell(25).setCellValue(info.getInvoiceReference());
            row1.createCell(26).setCellValue(info.getSapCertificateDate());
            row1.createCell(27).setCellValue(info.getJudge());
            row1.createCell(28).setCellValue(info.getDealMonth());
            row1.createCell(29).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getTaxAmount()));
            row1.createCell(30).setCellValue(info.getLinkIndex());
            row1.createCell(31).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getAggrementRedTaxAmount()));
            row1.createCell(32).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getAdjustmentTaxAmount()));
            row1.createCell(33).setCellValue(info.getPaperDate());
            row1.createCell(34).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getUpgradesAggrementRedTaxAmount()));
            row1.createCell(35).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getUpgradesAdjustmentTaxAmount()));
            row1.createCell(36).setCellValue(info.getUpgradesPaperDate());
            row1.createCell(37).setCellValue(info.getPreSpeDrawFirst());
            row1.createCell(38).setCellValue(info.getPreAdjustmentTaxAmountFirst());
            row1.createCell(39).setCellValue(info.getPrePaperDateFirst());
            row1.createCell(40).setCellValue(info.getPreSpeDrawSecond());
            row1.createCell(41).setCellValue(info.getPreAdjustmentTaxAmountSecond());
            row1.createCell(42).setCellValue(info.getPrePaperDateSecond());
            row1.createCell(43).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getEpdRedTaxAmount()));
            row1.createCell(44).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getEpdAdjustmentTaxAmount()));
            row1.createCell(45).setCellValue(info.getEpdPaperDate());
            row1.createCell(46).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getUpgradesEpdRedTaxAmount()));
            row1.createCell(47).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getUpgradesEpdAdjustmentTaxAmount()));
            row1.createCell(48).setCellValue(info.getUpgradesEpdPaperDate());
            row1.createCell(49).setCellValue(info.getPreEpdSpeDraw());
            row1.createCell(50).setCellValue(info.getPreEpdAdjustmentTaxAmount());
            row1.createCell(51).setCellValue(info.getPreEpdPaperDate());
            row1.createCell(52).setCellValue(info.getPpa());
            row1.createCell(53).setCellValue(info.getPpaAdjustmentTaxAmount());
            row1.createCell(54).setCellValue(info.getPpaPaperDate());
            row1.createCell(55).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getReverseTaxAmount()));
            row1.createCell(56).setCellValue(info.getReverseDate());
            row1.createCell(57).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getReTaxAmount()));
            row1.createCell(58).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getTotalAdjustmentTaxAmount()));
            row1.createCell(59).setCellValue(info.getRePaperDate());
            row1.createCell(60).setCellValue(info.getCkBkAmount());
            row1.createCell(61).setCellValue(info.getHAdjustmentTaxAmount());
            row1.createCell(62).setCellValue(info.getHPaperDate());
            row1.createCell(63).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getReverseTaxAmountSecond()));
            row1.createCell(64).setCellValue(info.getReverseDateSecond());
            row1.createCell(65).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getReTaxAmountSecond()));
            row1.createCell(66).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getTotalAdjustmentTaxAmountSecond()));
            row1.createCell(67).setCellValue(info.getRePaperDateSecond());
            row1.createCell(68).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getReverseTaxAmountThird()));
            row1.createCell(69).setCellValue(info.getReverseDateThird());
            row1.createCell(70).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getReTaxAmountThird()));
            row1.createCell(71).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getTotalAdjustmentTaxAmountThird()));
            row1.createCell(72).setCellValue(info.getRePaperDateThird());
            row1.createCell(73).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getCheckBalanceTaxAmount()));
            row1.createCell(74).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getApplyTaxAmount()));
            row1.createCell(75).setCellValue(info.getDealDate());
            row1.createCell(76).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getBalance()));
            row1.createCell(77).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getUnSettleAmount()));
            row1.createCell(78).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getUnInvoiceAmount()));
            row1.createCell(79).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getBlueOffsetAmount()));
            row1.createCell(80).setCellValue(ExcelUtils.bigDecimalToString((BigDecimal)info.getDifferenceAmount()));
        }
    }

    private static void reportAES(Sheet sheet0, List list, CellStyle titleCell) {
        ExcelUtils.reportAESTitle((Sheet)sheet0, (CellStyle)titleCell);
        ExcelUtils.reportAESCell((int)1, (Sheet)sheet0, (List)list, (CellStyle)titleCell);
    }

    private static String bigDecimalToString(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return "";
        }
        return bigDecimal.toString();
    }

    private static void reportChcJvInvoice(Workbook workbook, Sheet sheet0, List list, CellStyle titleCell) {
        workbook.setSheetName(0, "CHC&JV\u84dd\u5b57\u53d1\u7968\u6e05\u5355");
        Sheet sheet1 = workbook.createSheet("0%9%\u589e\u503c\u7a0e\u53d1\u7968");
        Sheet sheet2 = workbook.createSheet("13%\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff081\uff09");
        Sheet sheet3 = workbook.createSheet("13%\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff082\uff09");
        Row sheet0Row0 = sheet0.createRow(0);
        List<String> strings = Arrays.asList(ExcelTypeConfig.REPORT_CHC_JV_INVOICE_TITLE_SHEET0);
        for (int i = 0; i < strings.size(); ++i) {
            Cell cell = sheet0Row0.createCell(i);
            cell.setCellValue(strings.get(i));
            cell.setCellStyle(titleCell);
        }
        List rList = (List)list.get(0);
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        for (int i = 0; i < rList.size(); ++i) {
            Row row = sheet0.createRow(i + 1);
            ReportChcJvInvoiceVO info = (ReportChcJvInvoiceVO)rList.get(i);
            row.createCell(0).setCellValue(info.getJv());
            row.createCell(1).setCellValue(info.getInvoiceAmountWithoutTax());
            row.createCell(2).setCellValue(info.getInvoiceTaxAmount());
            row.createCell(3).setCellValue(info.getBillAmountWithoutTax());
            row.createCell(4).setCellValue(info.getBillTaxAmount());
            row.createCell(5).setCellValue(info.getDiffInvoiceAmountWithoutTax());
            row.createCell(6).setCellValue(info.getDiffInvoiceTaxAmount());
            row.createCell(7).setCellValue(info.getFirstPayment());
            row.createCell(8).setCellValue(info.getSecondPayment());
            row.createCell(9).setCellValue(info.getThirdPayment());
            row.createCell(10).setCellValue(info.getTotalAmount());
            row.createCell(11).setCellValue(info.getCheckAmount());
        }
        Row sheet1Row0 = sheet1.createRow(0);
        Row sheet2Row0 = sheet2.createRow(0);
        Row sheet3Row0 = sheet3.createRow(0);
        List<String> strings123 = Arrays.asList(ExcelTypeConfig.REPORT_CHC_JV_INVOICE_TITLE_SHEET123);
        for (int i = 0; i < strings123.size(); ++i) {
            Cell cell = sheet1Row0.createCell(i);
            cell.setCellValue(strings123.get(i));
            cell.setCellStyle(titleCell);
            cell = sheet2Row0.createCell(i);
            cell.setCellValue(strings123.get(i));
            cell.setCellStyle(titleCell);
            cell = sheet3Row0.createCell(i);
            cell.setCellValue(strings123.get(i));
            cell.setCellStyle(titleCell);
        }
        List cjiList = (List)list.get(1);
        int sheet1RowIndex = 1;
        int sheet2RowIndex = 1;
        int sheet3RowIndex = 1;
        for (int i = 0; i < cjiList.size(); ++i) {
            ChcJvInvoiceVO info = (ChcJvInvoiceVO)cjiList.get(i);
            String taxRateStr = info.getTaxRate();
            if (StringUtils.isEmpty((String)taxRateStr)) continue;
            double taxRate = Double.parseDouble(taxRateStr);
            if (0.0 == taxRate || 0.09 == taxRate) {
                sheet1RowIndex = ExcelUtils.rowDeal((ChcJvInvoiceVO)info, (Sheet)sheet1, (int)sheet1RowIndex);
                continue;
            }
            if (0.13 != taxRate) continue;
            if ((info.getNum() + 1) % 2 == 0) {
                sheet2RowIndex = ExcelUtils.rowDeal((ChcJvInvoiceVO)info, (Sheet)sheet2, (int)sheet2RowIndex);
                continue;
            }
            sheet3RowIndex = ExcelUtils.rowDeal((ChcJvInvoiceVO)info, (Sheet)sheet3, (int)sheet3RowIndex);
        }
    }

    private static int rowDeal(ChcJvInvoiceVO vo, Sheet sheet, int index) {
        Row row = sheet.createRow(index);
        row.createCell(0).setCellValue((double)index);
        row.createCell(1).setCellValue(vo.getInvoiceType());
        row.createCell(2).setCellValue(vo.getInvoiceCode());
        row.createCell(3).setCellValue(vo.getInvoiceNo());
        row.createCell(4).setCellValue(vo.getSubmitStatus());
        row.createCell(5).setCellValue(vo.getMachineNo());
        row.createCell(6).setCellValue(vo.getJvCode());
        row.createCell(7).setCellValue(vo.getPurchaserName());
        row.createCell(8).setCellValue(vo.getPurchaserTaxNo());
        row.createCell(9).setCellValue(vo.getPurchaserAddrTel());
        row.createCell(10).setCellValue(vo.getPurchaserBankInfo());
        row.createCell(11).setCellValue(vo.getAmountWithoutTax());
        row.createCell(12).setCellValue(vo.getTaxRate());
        row.createCell(13).setCellValue(vo.getTaxAmount());
        row.createCell(14).setCellValue(vo.getAmountWithTax());
        row.createCell(15).setCellValue(vo.getPaperDrewDate());
        row.createCell(16).setCellValue(vo.getTaxPeriod());
        row.createCell(17).setCellValue(vo.getCargoName());
        row.createCell(18).setCellValue(vo.getInvoicerName());
        row.createCell(19).setCellValue(vo.getCashierName());
        row.createCell(20).setCellValue(vo.getCheckerName());
        row.createCell(21).setCellValue(vo.getStatus());
        row.createCell(22).setCellValue(vo.getSalesBillNo());
        row.createCell(23).setCellValue(vo.getRelevancyPeriod());
        row.createCell(24).setCellValue(vo.getRemark());
        return index + 1;
    }

    private static void reportJvChcInterInvoice(Sheet sheet0, List list, CellStyle titleCell) {
        Row row = sheet0.createRow(0);
        List<String> strings = Arrays.asList(ExcelTypeConfig.REPORT_JV_CHC_INTER_INVOICE_TITLE);
        for (int i = 0; i < strings.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(strings.get(i));
            cell.setCellStyle(titleCell);
        }
        List mapList = list;
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        for (int i = 0; i < mapList.size(); ++i) {
            Row row1 = sheet0.createRow(i + 1);
            ReportJvChcInterInvoiceVO info = (ReportJvChcInterInvoiceVO)mapList.get(i);
            row1.createCell(0).setCellValue(info.getInvoiceType());
            row1.createCell(1).setCellValue(info.getGoodsName());
            row1.createCell(2).setCellValue(info.getSellerJv());
            row1.createCell(3).setCellValue(info.getSellerStoreNo());
            row1.createCell(4).setCellValue(info.getSellerTaxNo());
            row1.createCell(5).setCellValue(info.getSellerName());
            row1.createCell(6).setCellValue(info.getPurchaserJv());
            row1.createCell(7).setCellValue(info.getPurchaserStoreNo());
            row1.createCell(8).setCellValue(info.getPurchaserTaxNo());
            row1.createCell(9).setCellValue(info.getPurchaserName());
            row1.createCell(10).setCellValue(info.getInvoiceCode());
            row1.createCell(11).setCellValue(info.getInvoiceNo());
            row1.createCell(12).setCellValue(info.getInvoiceDate());
            row1.createCell(13).setCellValue(info.getTaxRate());
            row1.createCell(14).setCellValue(info.getTaxAmount());
            row1.createCell(15).setCellValue(info.getAmountWithoutTax());
            row1.createCell(16).setCellValue(info.getAmountWithTax());
            row1.createCell(17).setCellValue(info.getTaxCode());
            row1.createCell(18).setCellValue(info.getExt1());
            row1.createCell(19).setCellValue(info.getRemark());
            row1.createCell(20).setCellValue("");
            row1.createCell(21).setCellValue(info.getQsStatus());
            row1.createCell(22).setCellValue(info.getQsDate());
            row1.createCell(23).setCellValue(info.getAuthStatus());
            row1.createCell(24).setCellValue(info.getAuthDate());
            row1.createCell(25).setCellValue(info.getInvoiceStatus());
        }
    }

    private static void reportAgingStatistic(Sheet sheet0, List list, CellStyle titleCell) {
        Row row = sheet0.createRow(0);
        List<String> strings = Arrays.asList(ExcelTypeConfig.REPORT_AGING_STATISTIC_TITLE);
        for (int i = 0; i < strings.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(strings.get(i));
            cell.setCellStyle(titleCell);
        }
        List mapList = list;
        for (int i = 0; i < mapList.size(); ++i) {
            Row row1 = sheet0.createRow(i + 1);
            ReportAgingStatisticVO info = (ReportAgingStatisticVO)mapList.get(i);
            row1.createCell(0).setCellValue(info.getPeriod());
            row1.createCell(1).setCellValue(info.getPostingDate());
            row1.createCell(2).setCellValue(info.getCertificateNo());
            row1.createCell(3).setCellValue(info.getBlueInvoiceNo());
            row1.createCell(4).setCellValue(info.getAggrementNo());
            row1.createCell(5).setCellValue(info.getSupplierNo());
            row1.createCell(6).setCellValue(info.getIsRedInvoiceGroup());
            row1.createCell(7).setCellValue(info.getSupplierName());
            row1.createCell(8).setCellValue(info.getUnsettledTaxAmount());
            row1.createCell(9).setCellValue(info.getPendingRemark());
            row1.createCell(10).setCellValue(info.getAging());
            row1.createCell(11).setCellValue(info.getAging0To30());
            row1.createCell(12).setCellValue(info.getAging31To60());
            row1.createCell(13).setCellValue(info.getAging61To90());
            row1.createCell(14).setCellValue(info.getAging91To120());
            row1.createCell(15).setCellValue(info.getAging121To180());
            row1.createCell(16).setCellValue(info.getAging181To360());
            row1.createCell(17).setCellValue(info.getAgingGt360());
        }
    }

    private static void reportMTRJvInterInvoice(Sheet sheet0, List list, CellStyle titleCell) {
        Row row = sheet0.createRow(0);
        List<String> strings = Arrays.asList(ExcelTypeConfig.REPORT_MTR_JV_INTER_INVOICE_TITLE);
        for (int i = 0; i < strings.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(strings.get(i));
            cell.setCellStyle(titleCell);
        }
        List mapList = list;
        for (int i = 0; i < mapList.size(); ++i) {
            Row row1 = sheet0.createRow(i + 1);
            ReportMTRJvInterInvoiceVO info = (ReportMTRJvInterInvoiceVO)mapList.get(i);
            row1.createCell(0).setCellValue(info.getInvoiceType());
            row1.createCell(1).setCellValue(info.getSettlementNo());
            row1.createCell(2).setCellValue(info.getSellerJv());
            row1.createCell(3).setCellValue(info.getSellerStoreNo());
            row1.createCell(4).setCellValue(info.getSellerTaxNo());
            row1.createCell(5).setCellValue(info.getSellerName());
            row1.createCell(6).setCellValue(info.getPurchaserJv());
            row1.createCell(7).setCellValue(info.getPurchaserStoreNo());
            row1.createCell(8).setCellValue(info.getPurchaserTaxNo());
            row1.createCell(9).setCellValue(info.getPurchaserName());
            row1.createCell(10).setCellValue(info.getInvoiceCode());
            row1.createCell(11).setCellValue(info.getInvoiceNo());
            row1.createCell(12).setCellValue(info.getInvoiceDate());
            row1.createCell(13).setCellValue(info.getTaxRate());
            row1.createCell(14).setCellValue(info.getTaxAmount());
            row1.createCell(15).setCellValue(info.getAmountWithoutTax());
            row1.createCell(16).setCellValue(info.getAmountWithTax());
            row1.createCell(17).setCellValue(info.getTaxCode());
            row1.createCell(18).setCellValue(info.getExt1());
            row1.createCell(19).setCellValue(info.getRemark());
            row1.createCell(21).setCellValue(info.getQsStatus());
            row1.createCell(22).setCellValue(info.getQsDate());
            row1.createCell(23).setCellValue(info.getAuthStatus());
            row1.createCell(24).setCellValue(info.getAuthDate());
            row1.createCell(25).setCellValue(info.getInvoiceStatus());
        }
    }
}

