package com.xforececlound.message.api;

import com.xforececlound.message.model.AuthCodeResp;
import com.xforececlound.message.model.EmailAuthCodeReq;
import com.xforececlound.message.model.EmailValidateReq;
import com.xforececlound.message.model.SmsValidateResp;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping("/{tenantId}/message/v1")
@Api(tags = "邮件验证码API")
public interface EmailAuthCodeApi {


    @RequestMapping(value = "/email/auth-code", method = RequestMethod.POST)
    @ApiOperation(value = "发送验证码")
    AuthCodeResp sendAuthCode(@ApiParam(value = "tenantId", required = true) @PathVariable("tenantId") String tenantId, @ApiParam(required = true, value = "发送验证码参数") @RequestBody EmailAuthCodeReq emailAuthCodeReq);

    @RequestMapping(value = "/email/auth-code/verification", method = RequestMethod.POST)
    @ApiOperation(value = "校验验证码")
    SmsValidateResp validate(@ApiParam(value = "tenantId", required = true) @PathVariable("tenantId") String tenantId, @ApiParam(required = true, value = "校验验证码参数") @RequestBody EmailValidateReq emailValidateReq);

}
