package com.xforececlound.message.api;

import com.xforececlound.message.model.AuthCodeResp;
import com.xforececlound.message.model.BaseStatus;
import com.xforececlound.message.model.DefaultResponse;
import com.xforececlound.message.model.EmailContentReq;
import io.swagger.annotations.*;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

import static org.springframework.http.MediaType.APPLICATION_JSON_UTF8_VALUE;

@RequestMapping("/{tenantId}/message/v1")
@Api(tags = "邮件发送API")
@Validated
public interface EmailContentApi {

    @RequestMapping(value = "/email", method = RequestMethod.POST)
    @ApiOperation(value = "发送邮件")
    BaseStatus send(@ApiParam(value = "tenantId", required = true) @PathVariable("tenantId") String tenantId,
                    @ApiParam(required = false, value = "发送邮件参数") @Valid @RequestBody EmailContentReq emailContentReq
    );


    }
