package com.xforececlound.message.api;

import com.xforececlound.message.model.BaseStatus;
import com.xforececlound.message.model.DefaultResponse;
import io.swagger.annotations.*;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

import static org.springframework.http.MediaType.APPLICATION_JSON_UTF8_VALUE;

/**
 * @ClassName EmailManagementApi
 * @Description TODO
 * @Author zhangxiaolong
 * @Date 2019/9/27
 * @Version 1.0
 **/
@RequestMapping("/{tenantId}/message-management/v1")
@Api(tags = "邮件管理API")
@Validated
public interface EmailManagementApi {

    @RequestMapping(value = "/email/again", method = RequestMethod.POST)
    @ApiOperation(value = "重发邮件")
    BaseStatus reSend(@ApiParam(value = "tenantId", required = true) @PathVariable("tenantId") String tenantId, @ApiParam(value = "重发ID", required = false) @RequestParam(value = "id", required = false) Long id
    );
    @ApiOperation(value = "查询邮件发送结果列表", notes = "返回邮件发送结果列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tenantId", value = "租户id", required = true),
            @ApiImplicitParam(name = "account", value = "邮箱账号", required = false),
            @ApiImplicitParam(name = "id", value = "ID", required = false),
            @ApiImplicitParam(name = "page", value = "页码，从1开始", required = true),
            @ApiImplicitParam(name = "size", value = "每页数量，不能超过200", required = true)
    })
    @RequestMapping(value = "/email", method = RequestMethod.GET, produces = APPLICATION_JSON_UTF8_VALUE)
    DefaultResponse querySendResult(@PathVariable("tenantId") String tenantId,
                                    @RequestParam(value = "account", required = false) String account,
                                    @RequestParam(value = "id", required = false) Long id,
                                    @RequestParam(value = "page", required = false) @Min(1) Integer page,
                                    @RequestParam(value = "size", required = false) @Min(1) @Max(200) Integer size);

    @ApiOperation(value = "根据id查询邮件", notes = "返回邮件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tenantId", value = "租户id", required = true),
            @ApiImplicitParam(name = "id", value = "ID", required = false),
    })
    @RequestMapping(value = "/email/one", method = RequestMethod.GET, produces = APPLICATION_JSON_UTF8_VALUE)
    DefaultResponse queryEmailById(@PathVariable("tenantId") String tenantId, @RequestParam(value = "id", required = false) Long id);
}
