package com.xforececlound.message.api;

import com.xforececlound.message.model.*;
import io.swagger.annotations.*;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

@RequestMapping("/{tenantId}/message-management/v1")
@Api(tags = "邮件模板API")
@Validated
public interface EmailTemplateApi {

    @RequestMapping(value = "/email/template", method = RequestMethod.POST)
    @ApiOperation(value = "保存邮件模板")
    DefaultResponse saveTemplate(@PathVariable("tenantId") String tenantId, @ApiParam(required = true, value = "邮件模板") @Valid @RequestBody EmailTemplateReq emailTemplateReq);


    @RequestMapping(value = "/email/template", method = RequestMethod.DELETE)
    @ApiOperation(value = "根据Id删除邮件模板")
    DefaultResponse deleteTemplateById(@PathVariable("tenantId") String tenantId, @ApiParam(required = true, value = "邮件模板id") @RequestParam(value = "id", required = false) Long id);


    @RequestMapping(value = "/email/template/page-list", method = RequestMethod.GET)
    @ApiOperation(value = "分页查询邮件模板列表")
    DefaultResponse pageQueryTemplateListByAppId(@PathVariable("tenantId") String tenantId,
                                                                         @ApiParam(required = true, value = "产品线Id") @RequestParam(value = "appId", required = false) Long appId,
                                                                         @ApiParam(required = false, value = "模板代码") @RequestParam(value = "templateCode", required = false) String templateCode,
                                                                         @ApiParam(required = false, value = "模板名称") @RequestParam(value = "templateName", required = false) String templateName,
                                                                         @ApiParam(required = false, value = "模板类型") @RequestParam(value = "templateType", required = false) Integer templateType,
                                                                         @ApiParam(required = true, value = "页码，从1开始") @RequestParam(value = "page", required = false) @Min(1) Integer page,
                                                                         @ApiParam(required = true, value = "每页数量，不能超过200") @RequestParam(value = "size", required = false) @Min(1) @Max(200) Integer size);

    @GetMapping("/email/templates")
    PageResult<EmailTemplateDTO> find(@ApiParam(value = "租户ID", required = true) @PathVariable("tenantId") String tenantId,
                                      @ApiParam(value = "应用ID", required = true) @RequestParam("appId") Long appId,
                                      @ApiParam(value = "模板代码") @RequestParam(value = "templateCode", required = false) String templateCode,
                                      @ApiParam(value = "模板名称") @RequestParam(value = "templateName", required = false) String templateName,
                                      @ApiParam(value = "模板类型") @RequestParam(value = "templateType", required = false) Integer templateType,
                                      @ApiParam(required = true, value = "页码，从1开始") @RequestParam(value = "page", required = false) @Min(1) Integer page,
                                      @ApiParam(required = true, value = "每页数量，不能超过200") @RequestParam(value = "size", required = false) @Min(1) @Max(200) Integer size);

    @RequestMapping(value = "/email/template", method = RequestMethod.GET)
    @ApiOperation(value = "根据Id查询邮件模板")
    DefaultResponse<EmailTemplateDTO> queryTemplateById(@PathVariable("tenantId") String tenantId,
                                      @ApiParam(required = true, value = "模板id") @RequestParam(value = "id", required = false) Long id);
}
