package com.xforececlound.message.api;

import com.xforececlound.message.model.AuthCodeResp;
import com.xforececlound.message.model.SmsCodeReq;
import com.xforececlound.message.model.SmsValidateReq;
import com.xforececlound.message.model.SmsValidateResp;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

@RequestMapping("/{tenantId}/message/v1")
@Api(tags = "短信验证码API")
public interface SmsAuthCodeApi {
    @RequestMapping(value = "/sms/auth-code", method = RequestMethod.POST)
    @ApiOperation(value = "发送短信验证码")
    AuthCodeResp sendAuthCode(@ApiParam(value = "tenantId", required = true) @PathVariable("tenantId") String tenantId, @Valid @RequestBody SmsCodeReq smsCodeReq);

    @RequestMapping(value = "/sms/auth-code/verification", method = RequestMethod.POST)
    @ApiOperation(value = "校验短信验证码")
    SmsValidateResp validate(@ApiParam(value = "tenantId", required = true) @PathVariable("tenantId") String tenantId, @Valid @RequestBody SmsValidateReq smsValidReq);
}
