package com.xforececlound.message.api;

import com.xforececlound.message.model.AuthCodeResp;
import com.xforececlound.message.model.DefaultResponse;
import com.xforececlound.message.model.SmsSendRecordDTO;
import io.swagger.annotations.*;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

import static org.springframework.http.MediaType.APPLICATION_JSON_UTF8_VALUE;

/**
 * @ClassName EmailManagementApi
 * @Description TODO
 * @Author zhangxiaolong
 * @Date 2019/9/27
 * @Version 1.0
 **/
@RequestMapping("/{tenantId}/message-management/v1")
@Api(tags = "短信管理API")
@Validated
public interface SmsManagementApi {
    @ApiOperation(value = "查询短信发送结果列表", notes = "返回短信发送结果列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tenantId", value = "租户id", required = true),
            @ApiImplicitParam(name = "phoneNo", value = "手机号", required = false),
            @ApiImplicitParam(name = "id", value = "ID", required = false),
            @ApiImplicitParam(name = "page", value = "页码，从1开始", required = true),
            @ApiImplicitParam(name = "size", value = "每页数量，不能超过200", required = true)

    })
    @RequestMapping(value = "/sms", method = RequestMethod.GET, produces = APPLICATION_JSON_UTF8_VALUE)
    DefaultResponse querySendResults(@PathVariable("tenantId") String tenantId,
                                     @RequestParam(name = "phoneNo", required = false) String phoneNo,
                                     @RequestParam(name = "id", required = false) Long id,
                                     @RequestParam(name = "page", required = true) @Min(1) Integer page,
                                     @RequestParam(name = "size", required = true) @Min(1) @Max(200) Integer size);

    @ApiOperation("根据外部系统ID检索短信发送记录")
    @GetMapping("/sms-record/{outId}")
    SmsSendRecordDTO findSmsSendRecord(@ApiParam(value = "租户ID", required = true) @PathVariable String tenantId,
                                                       @ApiParam(value = "外部系统ID", required = true) @PathVariable String outId);

    @RequestMapping(value = "/sms/again", method = RequestMethod.POST, produces = APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "重新发送短信")
    AuthCodeResp resend(@ApiParam(value = "tenantId", required = true) @PathVariable("tenantId") String tenantId,
                        @ApiParam(value = "消息ID", required = true) @RequestParam(value = "id", required = true) Long id);

}
