package com.xforececlound.message.api;

import com.xforececlound.message.model.BaseStatus;
import com.xforececlound.message.model.SmsMessageReq;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

@Validated
@RequestMapping("/{tenantId}/message/v1")
@Api(tags = "短信消息API")
public interface SmsMessageApi {
    @RequestMapping(value = "/sms", method = RequestMethod.POST)
    @ApiOperation(value = "发送短信")
    BaseStatus send(@ApiParam(value = "tenantId", required = true) @PathVariable(value = "tenantId") String tenantId,
                    @Valid @RequestBody SmsMessageReq smsMessageReq);
}
