package com.xforececlound.message.model;


import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xforececlound.message.constant.ResponseCodeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import static com.xforececlound.message.constant.ResponseCodeEnum.SUCCESS;


@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class DefaultResponse<T> {

    @ApiModelProperty(value = "状态码", dataType = "String", name = "code", example = "MSGCZZ0200")
    private String code;

    @ApiModelProperty(value = "状态描述", dataType = "String", name = "message", example = "请求成功")
    private String message;

    @ApiModelProperty(value = "返回数据", dataType = "String", name = "result")
    private T result;

    public static final DefaultResponse<String> OK = new DefaultResponse<String>(SUCCESS, "");

    public DefaultResponse(ResponseCodeEnum responseCode, T result) {
        this.code = responseCode.getCode();
        this.message = responseCode.getMessage();
        this.result = result;
    }

    /**
     * 验证返回码是否是成功状态
     *
     * @return
     */
    @JsonIgnore
    public boolean isSuccess() {
        return SUCCESS.getCode().equals(this.getCode());
    }
}
