package com.xforececlound.message.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Email;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;

@Data
public class EmailAuthCodeReq implements Serializable {
    public final static String EXCHANGE_NAME = "email-auth-code-exchange";
    public final static String QUEUE_NAME = "email-auth-code-queue";
    public final static String ROUTING_KEY = "email.auth.code.*";

    @ApiModelProperty(value = "租户ID",dataType = "Long", name="tenantId", example = "11112222")
    @NotNull(message = "租户ID不能为空。")
    private Long tenantId;
    @ApiModelProperty(value = "邮箱账号",dataType = "String", name="email", example = "lengmingzh@sina.com")
    @NotNull(message = "邮箱账号不能为空。")
    @Email(message = "邮箱账号格式有误。")
    private String email;
    @ApiModelProperty(value = "模板code",dataType = "String", name="templateCode", example = "")
    private String templateCode;
    @ApiModelProperty(value = "过期时间(分)，传值范围是1-30",dataType = "Integer", name="expireTime", example = "3")
    @Min(value=1,message = "过期时间范围1-30。")
    @Max(value=30,message = "过期时间范围1-30。")
    private Integer expireTime;
    @ApiModelProperty(value = "扩展参数",dataType = "String", name="extno", example = "extno")
    private String extno;
    @ApiModelProperty(value = "产品线Id", dataType = "Long", name = "appId")
    private Long  appId;
    @ApiModelProperty(value = "主题", dataType = "String", name = "subject")
    private String subject;
}
