package com.xforececlound.message.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

@Data
@ApiModel
public class EmailContentReq implements Serializable {
    public final static String EXCHANGE_NAME = "email-content-exchange";
    public final static String QUEUE_NAME = "email-content-queue";
    public final static String ROUTING_KEY = "email.content.*";

    @ApiModelProperty(value = "邮件主题", dataType = "String", name = "subject", example = "票易通验证码")
    private String subject;
    @ApiModelProperty(value = "邮箱账号", dataType = "String", name = "email", example = "yours@sina.com")
    private String email;
    @ApiModelProperty(value = "邮件内容", dataType = "String", name = "content", example = "测试内容")
    private String content;
    @ApiModelProperty(value = "附件列表", dataType = "List", name = "attachment")
    private List<EmailAttachment> attachments;
    @ApiModelProperty(value = "模板code", dataType = "String", name = "templateCode")
    private String templateCode;
    @ApiModelProperty(value = "模板参数键值对", dataType = "map", name = "props")
    private Map<String,String> props;
    @ApiModelProperty(value = "发件人名称", dataType = "String", name = "senderName")
    private String  senderName;
    @ApiModelProperty(value = "产品线Id", dataType = "Long", name = "appId")
    private Long  appId;
    @ApiModelProperty(value = "租户id", dataType = "Long", name = "tenantId")
    private Long  tenantId;
    @ApiModelProperty(value = "地址列表(当receiverType为user时，根据userId到用户中心查询真实邮箱)", dataType = "String", name = "addressList")
    private List<ReceiveObj> receiverList;

}