package com.xforececlound.message.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
public class EmailValidateReq implements Serializable{
    @ApiModelProperty(value = "消息ID",dataType = "String", name="msgId", example = "a1111111111")
    @NotNull(message = "消息ID不能为空。")
    private String msgId;
    @ApiModelProperty(value = "邮箱账号",dataType = "String", name="email", example = "1831716675")
    @NotNull(message = "邮箱账号不能为空。")
    private String email;
    @ApiModelProperty(value = "验证码",dataType = "String", name="code", example = "123456")
    @NotNull(message = "验证码不能为空。")
    private String code;
}
