package com.xforececlound.message.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
public class SmsCodeReq implements Serializable {
    public final static String EXCHANGE_NAME = "sms-auth-code-exchange";
    public final static String QUEUE_NAME    = "sms-auth-code-queue";
    public final static String ROUTING_KEY   = "sms.auth.code.*";

    @ApiModelProperty(value = "应用ID", required = false, example = "20")
    private Long    appId;
    @ApiModelProperty(value = "租户ID", required = false, name = "tenantId", example = "11112222")
    @NotNull(message = "租户ID不能为空。")
    private Long    tenantId;
    @ApiModelProperty(value = "接收者手机号(只支持一个手机号)", name = "account",  example = "1831716675")
    @NotNull(message = "手机号码不能为空。")
    private String  mobile;
    @ApiModelProperty(value = "模板code", name = "templateCode", example = "123456")
    private String  templateCode;
    @ApiModelProperty(value = "过期时间(分)，传值范围是1-30", name = "expireTime", example = "3")
    private Integer expireTime;
    @ApiModelProperty(value = "扩展参数", name = "extno", example = "extno")
    private String  extno;
    @ApiModelProperty(value = "签名", name = "signName", example = "票易通")
    private String  signName;
    @ApiModelProperty(value = "外部系统ID，外部系统可以根据该ID进行跟踪记录", required = false, example = "MB672323342232")
    private String  outId;
}
