package com.xforececlound.message.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;
import java.io.Serializable;

@Data
public class SmsMessageReq implements Serializable {
    public final static String EXCHANGE_NAME = "sms-com.xforcecloud.message-exchange";
    public final static String QUEUE_NAME    = "sms-com.xforcecloud.message-queue";
    public final static String ROUTING_KEY   = "sms.com.xforcecloud.message.*";

    @ApiModelProperty(value = "应用ID", required = false, example = "20")
    private Long   appId;
    @ApiModelProperty(value = "租户ID", required = false, example = "11112222")
    private Long   tenantId;
    @ApiModelProperty(value = "接收者手机号(只支持一个手机号)", required = true, example = "1831716675")
    @NotEmpty(message = "接收者手机号不能为空")
    private String mobile;
    @ApiModelProperty(value = "模板代码(使用内部或外部代码都可以，建议使用内部代码)", required = false, example = "PYT_000010001")
    private String templateCode;
    @ApiModelProperty(value = "JSON格式的模板参数值，参数值只支持字符串类型，参数值顺序必须保持与模版内出现的顺序一致", required = false, example = "{\"code\": \"12345\"}")
    private String templateParamJson;
    @ApiModelProperty(value = "扩展参数", example = "extno")
    private String extno;
    @ApiModelProperty(value = "签名(不为空时使用该签名，为空时根据模版代码查找关联的签名)", required = false, example = "票易通")
    private String signName;
    @ApiModelProperty(value = "短信内容(针对特定的appId和tenantId通过内容而非模版代码发送短信，需要将templateCode设置为空)", required = false, example = "4月15-17日狂欢吃货节！你加购的爆品立享活动价，全店满399减50元")
    @Size(max = 255)
    private String content;
    @ApiModelProperty(value = "外部系统ID，外部系统可以根据该ID进行跟踪记录", required = false, example = "MB672323342232")
    private String outId;
}
