package com.xforececlound.message.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author liuyao@xforceplus.com
 * @version 1.0
 * @date 2021/5/19 10:17
 */
@Data
public class SmsSendRecordDTO implements Serializable {
    private Long    id;
    private Long    appId;
    private Long    tenantId;
    private String  phone;
    private String  templateCode;
    private String  content;
    private String  sendCode;
    private String  message;
    private String  sendRequestId;
    private String  sendBizId;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    private Date    sendTime;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    private Date    reportTime;
    private boolean success;
    private String  errCode;
    private String  errMsg;
    private String  smsSize;
    /**
     * 外部系统ID，外部系统可以根据该ID进行跟踪记录
     */
    private String  outId;
    private int     status;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    private Date    createTime;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    private Date    updateTime;
}
