package com.xforececlound.message.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.time.Instant;

@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmsTemplateDTO implements Serializable {
    public static final String SMS_TEMPLATE_CODE_PREFIX = "PYT_";

    @ApiModelProperty(value = "ID", example = "1")
    protected Long    id;
    @ApiModelProperty(value = "应用ID(appId和tenantId等于0代表使用全局默认账号时，appId非0但tenantId等于0代表使用应用级别的默认账号)", required = true, example = "20")
    @NotNull(message = "应用ID不能为空")
    private   Long    appId;
    @ApiModelProperty(value = "租户ID(appId和tenantId等于0代表使用全局默认账号时，appId非0但tenantId等于0代表使用应用级别的默认账号)", required = true, example = "1157130714379710464")
    @NotNull(message = "租户ID不能为空")
    private   Long    tenantId;
    @ApiModelProperty(value = "内部模版代码(由票易通创建，前端需要控制创建后无法修改)", required = false, example = "PYT_4122268888")
    private   String  code;
    @ApiModelProperty(value = "模版名称", required = true, example = "消费通知模板")
    @NotEmpty(message = "模版名称不能为空")
    @Size(min = 1, max = 20, message = "模版名称长度必须在1到20之间")
    private   String  name;
    @ApiModelProperty(value = "模版内容", required = true, example = "您正在申请手机注册，验证码为：${code}，5分钟内有效！")
    @NotEmpty(message = "模版内容不能为空")
    @Size(min = 1, max = 500, message = "模版内容长度必须在1到500之间")
    private   String  content;
    @ApiModelProperty(value = "模版类型(以阿里云的类型为准，使用错误会导致审核不通过，0:验证码，1:短信通知)", required = true, example = "0", allowableValues = "0,1")
    private   String  type;
    @ApiModelProperty(value = "短信签名", required = true, example = "票易通")
    @NotEmpty(message = "短信签名不能为空")
    private   String  signature;
    @ApiModelProperty(value = "模版备注", required = false, example = "星巴克会员消费通知2019-01-01添加")
    private   String  remark;
    @ApiModelProperty(value = "是否审核成功", required = false)
    private   Boolean audited;
    @ApiModelProperty(value = "是否可用", required = false)
    private   Boolean enabled;
    @ApiModelProperty(value = "创建时间", required = false)
    protected Instant createTime;
    @ApiModelProperty(value = "更新时间", required = false)
    protected Instant updateTime;
}