/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.pscc.common.exception;

import com.xforceplus.pscc.common.exception.ErrorCode;
import org.apache.commons.lang3.StringUtils;

public class BusinessException
extends RuntimeException {
    protected Integer code;
    protected String message;
    protected ErrorCode errorCode;
    protected Object data;

    public BusinessException(String message) {
        this.message = message;
    }

    public BusinessException(String format, Object ... objects) {
        this.message = BusinessException.formatMessage(format, objects);
    }

    private static String formatMessage(String format, Object[] objects) {
        String formatStr = StringUtils.replace((String)format, (String)"{}", (String)"%s");
        return String.format(formatStr, objects);
    }

    public BusinessException(Throwable throwable, String format, Object ... objects) {
        super(BusinessException.formatMessage(format, objects), throwable);
        this.message = BusinessException.formatMessage(format, objects);
    }

    public BusinessException(ErrorCode code) {
        this.errorCode = code;
        this.message = code.getErrDesc();
        this.code = code.getErrCode();
    }

    public BusinessException(ErrorCode code, Object data) {
        this.errorCode = code;
        this.message = code.getErrDesc();
        this.code = code.getErrCode();
        this.data = data;
    }

    public BusinessException(Throwable throwable) {
        super(throwable);
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public Object getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessException)) {
            return false;
        }
        BusinessException other = (BusinessException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        ErrorCode this$errorCode = this.getErrorCode();
        ErrorCode other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusinessException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        ErrorCode $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BusinessException(code=" + this.getCode() + ", message=" + this.getMessage() + ", errorCode=" + this.getErrorCode() + ", data=" + this.getData() + ")";
    }
}

