/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.pscc.common.intercept;

import com.alibaba.fastjson2.JSON;
import com.google.common.collect.Maps;
import com.xforceplus.pscc.common.intercept.TraceContext;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class WebLogHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(WebLogHandlerInterceptor.class);
    ThreadLocal<Long> startTime = new ThreadLocal();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        try {
            this.startTime.set(System.currentTimeMillis());
            String traceId = TraceContext.getContextTraceId();
            HashMap logEntity = Maps.newHashMap();
            logEntity.put("Title", "\u8bf7\u6c42\u62a5\u6587-" + request.getMethod());
            logEntity.put("traceId", traceId);
            logEntity.put("Name", request.getRequestURI().substring(request.getRequestURI().lastIndexOf("/") + 1));
            logEntity.put("Url", request.getRequestURL().toString());
            logEntity.put("Ip", request.getRemoteAddr());
            logEntity.put("RequestStr", request.getParameterMap());
            log.info(JSON.toJSONString((Object)logEntity));
        }
        catch (Exception e) {
            log.error("preHandle", (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
        try {
            Long time = System.currentTimeMillis() - this.startTime.get();
            this.startTime.remove();
            HashMap logEntity = Maps.newHashMap();
            logEntity.put("Title", "\u8fd4\u56de\u62a5\u6587");
            logEntity.put("traceId", TraceContext.getContextTraceId());
            logEntity.put("Time", time);
            log.info(JSON.toJSONString((Object)logEntity));
        }
        catch (Exception e) {
            log.error("postHandle", (Throwable)e);
        }
        finally {
            TraceContext.removeContextTraceId();
        }
    }
}

