/*
 * Decompiled with CFR 0.152.
 */
package com.xforcecloud.open.client.auth;

import com.xforcecloud.open.client.StringUtil;
import com.xforcecloud.open.client.auth.OAuthFlow;
import feign.Client;
import feign.Request;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.Response;
import feign.RetryableException;
import feign.Util;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthClientResponse;
import org.apache.oltu.oauth2.client.response.OAuthClientResponseFactory;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.apache.oltu.oauth2.common.token.BasicOAuthToken;

public class OAuth
implements RequestInterceptor {
    static final int MILLIS_PER_SECOND = 1000;
    private volatile String accessToken;
    private Long expirationTimeMillis;
    private OAuthClient oauthClient;
    private OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder;
    private OAuthClientRequest.AuthenticationRequestBuilder authenticationRequestBuilder;
    private AccessTokenListener accessTokenListener;

    public OAuth(Client client, OAuthClientRequest.TokenRequestBuilder requestBuilder) {
        this.oauthClient = new OAuthClient((HttpClient)new OAuthFeignClient(client));
        this.tokenRequestBuilder = requestBuilder;
    }

    public OAuth(Client client, OAuthFlow flow, String authorizationUrl, String tokenUrl, String scopes) {
        this(client, OAuthClientRequest.tokenLocation((String)tokenUrl).setScope(scopes));
        switch (flow) {
            case accessCode: 
            case implicit: {
                this.tokenRequestBuilder.setGrantType(GrantType.AUTHORIZATION_CODE);
                break;
            }
            case password: {
                this.tokenRequestBuilder.setGrantType(GrantType.PASSWORD);
                break;
            }
            case application: {
                this.tokenRequestBuilder.setGrantType(GrantType.CLIENT_CREDENTIALS);
                break;
            }
        }
        this.authenticationRequestBuilder = OAuthClientRequest.authorizationLocation((String)authorizationUrl);
    }

    public OAuth(OAuthFlow flow, String authorizationUrl, String tokenUrl, String scopes) {
        this((Client)new Client.Default(null, null), flow, authorizationUrl, tokenUrl, scopes);
    }

    public void apply(RequestTemplate template) {
        if (template.headers().containsKey("Authorization")) {
            return;
        }
        if (this.expirationTimeMillis == null || System.currentTimeMillis() >= this.expirationTimeMillis) {
            this.updateAccessToken();
        }
        if (this.getAccessToken() != null) {
            template.header("Authorization", new String[]{"Bearer " + this.getAccessToken()});
        }
    }

    public synchronized void updateAccessToken() {
        OAuthJSONAccessTokenResponse accessTokenResponse;
        try {
            accessTokenResponse = this.oauthClient.accessToken(this.tokenRequestBuilder.buildBodyMessage());
        }
        catch (Exception e) {
            throw new RetryableException(e.getMessage(), (Throwable)e, null);
        }
        if (accessTokenResponse != null && accessTokenResponse.getAccessToken() != null) {
            this.setAccessToken(accessTokenResponse.getAccessToken(), accessTokenResponse.getExpiresIn());
            if (this.accessTokenListener != null) {
                this.accessTokenListener.notify((BasicOAuthToken)accessTokenResponse.getOAuthToken());
            }
        }
    }

    public synchronized void registerAccessTokenListener(AccessTokenListener accessTokenListener) {
        this.accessTokenListener = accessTokenListener;
    }

    public synchronized String getAccessToken() {
        return this.accessToken;
    }

    public synchronized void setAccessToken(String accessToken, Long expiresIn) {
        this.accessToken = accessToken;
        this.expirationTimeMillis = System.currentTimeMillis() + expiresIn * 1000L;
    }

    public OAuthClientRequest.TokenRequestBuilder getTokenRequestBuilder() {
        return this.tokenRequestBuilder;
    }

    public void setTokenRequestBuilder(OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder) {
        this.tokenRequestBuilder = tokenRequestBuilder;
    }

    public OAuthClientRequest.AuthenticationRequestBuilder getAuthenticationRequestBuilder() {
        return this.authenticationRequestBuilder;
    }

    public void setAuthenticationRequestBuilder(OAuthClientRequest.AuthenticationRequestBuilder authenticationRequestBuilder) {
        this.authenticationRequestBuilder = authenticationRequestBuilder;
    }

    public OAuthClient getOauthClient() {
        return this.oauthClient;
    }

    public void setOauthClient(OAuthClient oauthClient) {
        this.oauthClient = oauthClient;
    }

    public void setOauthClient(Client client) {
        this.oauthClient = new OAuthClient((HttpClient)new OAuthFeignClient(client));
    }

    public static class OAuthFeignClient
    implements HttpClient {
        private Client client;

        public OAuthFeignClient() {
            this.client = new Client.Default(null, null);
        }

        public OAuthFeignClient(Client client) {
            this.client = client;
        }

        public <T extends OAuthClientResponse> T execute(OAuthClientRequest request, Map<String, String> headers, String requestMethod, Class<T> responseClass) throws OAuthSystemException, OAuthProblemException {
            Response feignResponse;
            RequestTemplate req = new RequestTemplate().append((CharSequence)request.getLocationUri()).method(requestMethod).body(request.getBody());
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                req.header(entry.getKey(), new String[]{entry.getValue()});
            }
            String body = "";
            try {
                feignResponse = this.client.execute(req.request(), new Request.Options());
                body = Util.toString((Reader)feignResponse.body().asReader());
            }
            catch (IOException e) {
                throw new OAuthSystemException((Throwable)e);
            }
            String contentType = null;
            Collection contentTypeHeader = (Collection)feignResponse.headers().get("Content-Type");
            if (contentTypeHeader != null) {
                contentType = StringUtil.join(contentTypeHeader.toArray(new String[0]), ";");
            }
            return (T)OAuthClientResponseFactory.createCustomResponse((String)body, contentType, (int)feignResponse.status(), responseClass);
        }

        public void shutdown() {
        }
    }

    public static interface AccessTokenListener {
        public void notify(BasicOAuthToken var1);
    }
}

