/*
 * Decompiled with CFR 0.152.
 */
package com.xforcecloud.open.client.helper;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ClassUtil {
    private static final Logger log = LoggerFactory.getLogger(ClassUtil.class);
    public static final String DOT = ".";
    public static final String SLASH = "/";
    public static final String EMPTY = "";
    private static final String CLASS_EXT = ".class";
    private static final String JAR_FILE_EXT = ".jar";
    private static final String JAR_PATH_EXT = ".jar!";
    private static final String PATH_FILE_PRE = "file:";
    private static final ClassFilter NULL_CLASS_FILTER = null;
    private static FileFilter fileFilter = pathname -> ClassUtil.isClass(pathname.getName()) || pathname.isDirectory() || ClassUtil.isJarFile(pathname);

    private ClassUtil() {
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        log.debug("Scan classes from package [{}]...", (Object)packageName);
        return ClassUtil.scanPackage(packageName, NULL_CLASS_FILTER);
    }

    public static Set<Class<?>> scanPackage(String packageName, ClassFilter classFilter) {
        if (!StringUtils.hasText((String)packageName)) {
            throw new NullPointerException("packageName can't be blank!");
        }
        packageName = ClassUtil.getWellFormedPackageName(packageName);
        HashSet classes = new HashSet();
        for (String classPath : ClassUtil.getClassPaths(packageName)) {
            log.debug("Scan classpath: [{}]", (Object)classPath);
            ClassUtil.fillClasses(classPath, packageName, classFilter, classes);
        }
        if (classes.isEmpty()) {
            for (String classPath : ClassUtil.getJavaClassPaths()) {
                log.debug("Scan java classpath: [{}]", (Object)classPath);
                ClassUtil.fillClasses(new File(classPath), packageName, classFilter, classes);
            }
        }
        return classes;
    }

    public static Set<String> getClassPaths(String packageName) {
        Enumeration<URL> resources;
        String packagePath = packageName.replace(DOT, SLASH);
        try {
            resources = Thread.currentThread().getContextClassLoader().getResources(packagePath);
        }
        catch (IOException e) {
            log.error("Error when load classPath!", (Throwable)e);
            return null;
        }
        HashSet<String> paths = new HashSet<String>();
        while (resources.hasMoreElements()) {
            paths.add(resources.nextElement().getPath());
        }
        return paths;
    }

    public static String[] getJavaClassPaths() {
        String[] classPaths = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        return classPaths;
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static String getWellFormedPackageName(String packageName) {
        return packageName.lastIndexOf(DOT) != packageName.length() - 1 ? packageName + DOT : packageName;
    }

    private static void fillClasses(String path, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        int index = path.lastIndexOf(JAR_PATH_EXT);
        if (index != -1) {
            path = path.substring(0, index + JAR_FILE_EXT.length());
            path = ClassUtil.removePrefix(path, PATH_FILE_PRE);
            ClassUtil.processJarFile(new File(path), packageName, classFilter, classes);
        } else {
            ClassUtil.fillClasses(new File(path), packageName, classFilter, classes);
        }
    }

    public static String removePrefix(String str, String prefix) {
        if (str != null && str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    private static void fillClasses(File file, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        if (file.isDirectory()) {
            ClassUtil.processDirectory(file, packageName, classFilter, classes);
        } else if (ClassUtil.isClassFile(file)) {
            ClassUtil.processClassFile(file, packageName, classFilter, classes);
        } else if (ClassUtil.isJarFile(file)) {
            ClassUtil.processJarFile(file, packageName, classFilter, classes);
        }
    }

    private static void processDirectory(File directory, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        for (File file : directory.listFiles(fileFilter)) {
            ClassUtil.fillClasses(file, packageName, classFilter, classes);
        }
    }

    private static void processClassFile(File file, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        String filePathWithDot = file.getAbsolutePath().replace(File.separator, DOT);
        int subIndex = -1;
        subIndex = filePathWithDot.indexOf(packageName);
        if (subIndex != -1) {
            String className = filePathWithDot.substring(subIndex).replace(CLASS_EXT, EMPTY);
            ClassUtil.fillClass(className, packageName, classes, classFilter);
        }
    }

    private static void processJarFile(File file, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        try {
            for (JarEntry entry : Collections.list(new JarFile(file).entries())) {
                if (!ClassUtil.isClass(entry.getName())) continue;
                String className = entry.getName().replace(SLASH, DOT).replace(CLASS_EXT, EMPTY);
                ClassUtil.fillClass(className, packageName, classes, classFilter);
            }
        }
        catch (Throwable ex) {
            log.error(ex.getMessage(), ex);
        }
    }

    private static void fillClass(String className, String packageName, Set<Class<?>> classes, ClassFilter classFilter) {
        if (className.startsWith(packageName)) {
            try {
                Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                if (classFilter == NULL_CLASS_FILTER || classFilter.accept(clazz)) {
                    classes.add(clazz);
                }
            }
            catch (Throwable ex) {
                log.error(EMPTY, ex);
            }
        }
    }

    private static boolean isClassFile(File file) {
        return ClassUtil.isClass(file.getName());
    }

    private static boolean isClass(String fileName) {
        return fileName.endsWith(CLASS_EXT);
    }

    private static boolean isJarFile(File file) {
        return file.getName().contains(JAR_FILE_EXT);
    }

    public static interface ClassFilter {
        public boolean accept(Class<?> var1);
    }
}

