/*
 * Decompiled with CFR 0.152.
 */
package com.xforcecloud.open.client.helper;

import com.xforcecloud.open.client.ApiClient;
import com.xforcecloud.open.client.api.SecurityApi;
import com.xforcecloud.open.client.helper.ClassUtil;
import com.xforcecloud.open.client.helper.XforceCloudOpenApiSettings;
import com.xforcecloud.open.client.model.OpenApiResponse;
import feign.Client;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.beans.Introspector;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ClassUtils;

@EnableConfigurationProperties(value={XforceCloudOpenApiSettings.class})
@ConditionalOnProperty(prefix="xforcecloud.api", name={"app-id"})
public class XforceCloudOpenApiAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XforceCloudOpenApiAutoConfiguration.class);

    @Bean
    public ApiClient apiClient(XforceCloudOpenApiSettings xforceCloudOpenApiSettings, AccessTokenInterceptor accessTokenInterceptor, Client client, ConfigurableApplicationContext context) {
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath(xforceCloudOpenApiSettings.getApiAddress());
        apiClient.addAuthorization("XAccessToken", accessTokenInterceptor);
        apiClient.getFeignBuilder().client(client);
        this.createApiInstances(apiClient, context);
        return apiClient;
    }

    @Bean
    public SecurityApi securityApi(XforceCloudOpenApiSettings xforcecloudOpenApiSettings, Client client) {
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath(xforcecloudOpenApiSettings.getApiAddress());
        apiClient.getFeignBuilder().client(client);
        return apiClient.buildClient(SecurityApi.class);
    }

    public void createApiInstances(ApiClient apiClient, ConfigurableApplicationContext context) {
        this.scannerApiClasses().stream().filter(c -> !SecurityApi.class.equals(c)).forEach(apiClass -> {
            String shortClassName = ClassUtils.getShortName((Class)apiClass);
            String beanName = Introspector.decapitalize(shortClassName);
            log.info("api class: {}", (Object)apiClass.getName());
            log.info("build api instance: {}", (Object)beanName);
            context.getBeanFactory().registerSingleton(beanName, (Object)apiClient.buildClient(apiClass.asSubclass(ApiClient.Api.class)));
        });
    }

    private Set<Class<?>> scannerApiClasses() {
        return ClassUtil.scanPackage("com.xforcecloud.open.client.api", clazz -> ApiClient.Api.class.isAssignableFrom(clazz));
    }

    @Bean
    public Client client() throws NoSuchAlgorithmException, KeyManagementException {
        return new Client.Default((SSLSocketFactory)new NaiveSSLSocketFactory(), (host, session) -> true);
    }

    @Bean
    public AccessTokenInterceptor accessTokenInterceptor(XforceCloudOpenApiSettings xforceCloudOpenApiSettings, SecurityApi securityApi) {
        return new AccessTokenInterceptor(xforceCloudOpenApiSettings, securityApi, 7200L);
    }

    public static class AccessTokenInterceptor
    implements RequestInterceptor {
        private static final Logger logger = LoggerFactory.getLogger(AccessTokenInterceptor.class);
        private final SecurityApi securityApi;
        private final long period;
        private final XforceCloudOpenApiSettings xforceCloudOpenApiSettings;
        private String accessToken;
        private long lastRefreshTime = 0L;
        private ReentrantLock lock = new ReentrantLock();

        public AccessTokenInterceptor(XforceCloudOpenApiSettings xforceCloudOpenApiSettings, SecurityApi securityApi, long period) {
            this.xforceCloudOpenApiSettings = xforceCloudOpenApiSettings;
            this.securityApi = securityApi;
            this.period = period;
        }

        public void refreshToken() {
            OpenApiResponse token = this.securityApi.getToken(this.xforceCloudOpenApiSettings.getAppId(), this.xforceCloudOpenApiSettings.getAppSecret());
            this.accessToken = (String)token.getResult();
            this.lastRefreshTime = System.currentTimeMillis();
        }

        public void refreshTokenIfNecessary(int retryCount) {
            block7: {
                if (this.needRefresh()) {
                    this.lock.lock();
                    try {
                        if (!this.needRefresh()) break block7;
                        try {
                            this.refreshToken();
                        }
                        catch (Exception e) {
                            if (retryCount <= 0) {
                                logger.error(e.getMessage(), (Throwable)e);
                                break block7;
                            }
                            this.refreshTokenIfNecessary(--retryCount);
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            }
        }

        private boolean needRefresh() {
            return this.accessToken == null || this.lastRefreshTime == 0L || System.currentTimeMillis() - this.lastRefreshTime > (this.period - 60L) * 1000L;
        }

        public void apply(RequestTemplate requestTemplate) {
            this.refreshTokenIfNecessary(1);
            requestTemplate.header("x-access-token", new String[]{this.accessToken});
        }
    }

    public static class NaiveSSLSocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        private final SSLContext alwaysAllowSslContext = SSLContext.getInstance("TLS");

        public NaiveSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            this.alwaysAllowSslContext.init(null, new TrustManager[]{tm}, null);
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.sslSocketFactory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.sslSocketFactory.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
            return this.alwaysAllowSslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.alwaysAllowSslContext.getSocketFactory().createSocket(host, port);
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
            return this.alwaysAllowSslContext.getSocketFactory().createSocket(host, port, localAddress, localPort);
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.alwaysAllowSslContext.getSocketFactory().createSocket(host, port);
        }

        @Override
        public Socket createSocket(InetAddress host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.alwaysAllowSslContext.getSocketFactory().createSocket(host, port, localHost, localPort);
        }
    }
}

