package com.xforcecloud.open.client.api;

import com.xforcecloud.open.client.ApiClient;
import com.xforcecloud.open.client.EncodingUtils;

import com.xforcecloud.open.client.model.CallbackEventMessage;
import com.xforcecloud.open.client.model.RegisterQuery;
import com.xforcecloud.open.client.model.Response;
import com.xforcecloud.open.client.model.Sign;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
public interface DistributeApi extends ApiClient.Api {


  /**
   * 删除注册信息
   * 
    * @param id id (required)
   * @return Response
   */
  @RequestLine("POST /open/api/distribute/v1/register/delete?id={id}")
  @Headers({
    "Content-Type: application/json",
    "Accept: application/json",
  })
  Response deleteDistributionUsingPOST(@Param("id") Long id);

  /**
   * 删除注册信息
   * 
   * Note, this is equivalent to the other <code>deleteDistributionUsingPOST</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteDistributionUsingPOSTQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>id - id (required)</li>
   *   </ul>
   * @return Response
   */
  @RequestLine("POST /open/api/distribute/v1/register/delete?id={id}")
  @Headers({
  "Content-Type: application/json",
  "Accept: application/json",
  })
  Response deleteDistributionUsingPOST(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteDistributionUsingPOST</code> method in a fluent style.
   */
  public static class DeleteDistributionUsingPOSTQueryParams extends HashMap<String, Object> {
    public DeleteDistributionUsingPOSTQueryParams id(final Long value) {
      put("id", EncodingUtils.encode(value));
      return this;
    }
  }

  /**
   * 下发数据
   * 
    * @param data data (required)
   * @return Response
   */
  @RequestLine("POST /open/api/distribute/v1/event")
  @Headers({
    "Content-Type: application/json",
    "Accept: application/json",
  })
  Response doDistributeUsingPOST(CallbackEventMessage data);

  /**
   * 查询注册信息
   * 
    * @param param param (required)
   * @return Response
   */
  @RequestLine("POST /open/api/distribute/v1/register/query")
  @Headers({
    "Content-Type: application/json",
    "Accept: application/json",
  })
  Response queryDistributionUsingPOST(RegisterQuery param);

  /**
   * 注册服务
   * 
    * @param sign sign (required)
   * @return Response
   */
  @RequestLine("POST /open/api/distribute/v1/register/save")
  @Headers({
    "Content-Type: application/json",
    "Accept: application/json",
  })
  Response registerDistributionUsingPOST(Sign sign);
}
