package com.xforcecloud.open.client.api;

import com.xforcecloud.open.client.ApiClient;
import com.xforcecloud.open.client.EncodingUtils;

import com.xforcecloud.open.client.model.LogistOrderVo;
import com.xforcecloud.open.client.model.Resp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
public interface LogistControllerApi extends ApiClient.Api {


  /**
   * getExpressList
   * 
   * @return Resp
   */
  @RequestLine("GET /enterprise/v1/logistics/expressList")
  @Headers({
    "Content-Type: application/json",
    "Accept: */*",
  })
  Resp getExpressListUsingGET();

  /**
   * getLogistDetail
   * 
    * @param appId appId (required)
    * @param timestamp timestamp (required)
    * @param expressCode expressCode (optional)
    * @param parcelNo parcelNo (optional)
   * @return Resp
   */
  @RequestLine("GET /enterprise/v1/logistics/logistDetail?expressCode={expressCode}&parcelNo={parcelNo}")
  @Headers({
    "Content-Type: application/json",
    "Accept: */*",
    "appId: {appId}",
    
    "timestamp: {timestamp}"
  })
  Resp getLogistDetailUsingGET(@Param("appId") String appId, @Param("timestamp") String timestamp, @Param("expressCode") String expressCode, @Param("parcelNo") String parcelNo);

  /**
   * getLogistDetail
   * 
   * Note, this is equivalent to the other <code>getLogistDetailUsingGET</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetLogistDetailUsingGETQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param appId appId (required)
   * @param timestamp timestamp (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>expressCode - expressCode (optional)</li>
   *   <li>parcelNo - parcelNo (optional)</li>
   *   </ul>
   * @return Resp
   */
  @RequestLine("GET /enterprise/v1/logistics/logistDetail?expressCode={expressCode}&parcelNo={parcelNo}")
  @Headers({
  "Content-Type: application/json",
  "Accept: */*",
      "appId: {appId}",
      
      "timestamp: {timestamp}"
  })
  Resp getLogistDetailUsingGET(@Param("appId") String appId, @Param("timestamp") String timestamp, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getLogistDetailUsingGET</code> method in a fluent style.
   */
  public static class GetLogistDetailUsingGETQueryParams extends HashMap<String, Object> {
    public GetLogistDetailUsingGETQueryParams expressCode(final String value) {
      put("expressCode", EncodingUtils.encode(value));
      return this;
    }
    public GetLogistDetailUsingGETQueryParams parcelNo(final String value) {
      put("parcelNo", EncodingUtils.encode(value));
      return this;
    }
  }

  /**
   * orderLogist
   * 
    * @param appId appId (required)
    * @param orderVO orderVO (required)
    * @param timestamp timestamp (required)
   * @return Resp
   */
  @RequestLine("POST /enterprise/v1/logistics/order")
  @Headers({
    "Content-Type: application/json",
    "Accept: */*",
    "appId: {appId}",
    
    "timestamp: {timestamp}"
  })
  Resp orderLogistUsingPOST(@Param("appId") String appId, LogistOrderVo orderVO, @Param("timestamp") String timestamp);
}
