package com.xforcecloud.open.client.api;

import com.xforcecloud.open.client.ApiClient;
import com.xforcecloud.open.client.EncodingUtils;

import com.xforcecloud.open.client.model.OpenApiResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
public interface SecurityApi extends ApiClient.Api {


  /**
   * 3.5 获取AccessToken
   * AccessToken是应用访问票易通开放平台接口的全局唯一凭据，调用接口时需携带AccessToken。
    * @param corpId 合作方企业ID (required)
    * @param corpSecret 合作方企业的凭证密钥 (required)
   * @return OpenApiResponse
   */
  @RequestLine("POST /security/access-token?corp_id={corpId}&corp_secret={corpSecret}")
  @Headers({
    "Content-Type: application/json",
    "Accept: application/json",
  })
  OpenApiResponse getAccessToken(@Param("corpId") String corpId, @Param("corpSecret") String corpSecret);

  /**
   * 3.5 获取AccessToken
   * AccessToken是应用访问票易通开放平台接口的全局唯一凭据，调用接口时需携带AccessToken。
   * Note, this is equivalent to the other <code>getAccessToken</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetAccessTokenQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>corpId - 合作方企业ID (required)</li>
   *   <li>corpSecret - 合作方企业的凭证密钥 (required)</li>
   *   </ul>
   * @return OpenApiResponse
   */
  @RequestLine("POST /security/access-token?corp_id={corpId}&corp_secret={corpSecret}")
  @Headers({
  "Content-Type: application/json",
  "Accept: application/json",
  })
  OpenApiResponse getAccessToken(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getAccessToken</code> method in a fluent style.
   */
  public static class GetAccessTokenQueryParams extends HashMap<String, Object> {
    public GetAccessTokenQueryParams corpId(final String value) {
      put("corp_id", EncodingUtils.encode(value));
      return this;
    }
    public GetAccessTokenQueryParams corpSecret(final String value) {
      put("corp_secret", EncodingUtils.encode(value));
      return this;
    }
  }

  /**
   * 获取token
   * AccessToken是应用访问票易通开放平台接口的全局唯一凭据，调用接口时需携带AccessToken。
    * @param clientId 应用ID (required)
    * @param clientSecret 应用 secret (required)
   * @return OpenApiResponse
   */
  @RequestLine("POST /security/token?clientId={clientId}&clientSecret={clientSecret}")
  @Headers({
    "Content-Type: application/json",
    "Accept: application/json",
  })
  OpenApiResponse getToken(@Param("clientId") String clientId, @Param("clientSecret") String clientSecret);

  /**
   * 获取token
   * AccessToken是应用访问票易通开放平台接口的全局唯一凭据，调用接口时需携带AccessToken。
   * Note, this is equivalent to the other <code>getToken</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetTokenQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>clientId - 应用ID (required)</li>
   *   <li>clientSecret - 应用 secret (required)</li>
   *   </ul>
   * @return OpenApiResponse
   */
  @RequestLine("POST /security/token?clientId={clientId}&clientSecret={clientSecret}")
  @Headers({
  "Content-Type: application/json",
  "Accept: application/json",
  })
  OpenApiResponse getToken(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getToken</code> method in a fluent style.
   */
  public static class GetTokenQueryParams extends HashMap<String, Object> {
    public GetTokenQueryParams clientId(final String value) {
      put("clientId", EncodingUtils.encode(value));
      return this;
    }
    public GetTokenQueryParams clientSecret(final String value) {
      put("clientSecret", EncodingUtils.encode(value));
      return this;
    }
  }
}
