package com.xforcecloud.open.client.api;

import com.xforcecloud.open.client.ApiClient;
import com.xforcecloud.open.client.EncodingUtils;

import com.xforcecloud.open.client.model.GetTaskByIDResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
public interface TasksApi extends ApiClient.Api {


  /**
   * get task info by taskID
   * Returns a task info
    * @param tenantId  (required)
    * @param batch ID of task to return (required)
   * @return GetTaskByIDResponse
   */
  @RequestLine("GET /{tenant-id}/cognition/v1/tasks?batch={batch}")
  @Headers({
    "Content-Type: application/json",
    "Accept: application/json",
  })
  GetTaskByIDResponse getTaskByIdList(@Param("tenantId") String tenantId, @Param("batch") List<String> batch);

  /**
   * get task info by taskID
   * Returns a task info
   * Note, this is equivalent to the other <code>getTaskByIdList</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetTaskByIdListQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param tenantId  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>batch - ID of task to return (required)</li>
   *   </ul>
   * @return GetTaskByIDResponse
   */
  @RequestLine("GET /{tenant-id}/cognition/v1/tasks?batch={batch}")
  @Headers({
  "Content-Type: application/json",
  "Accept: application/json",
  })
  GetTaskByIDResponse getTaskByIdList(@Param("tenantId") String tenantId, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getTaskByIdList</code> method in a fluent style.
   */
  public static class GetTaskByIdListQueryParams extends HashMap<String, Object> {
    public GetTaskByIdListQueryParams batch(final List<String> value) {
      put("batch", EncodingUtils.encodeCollection(value, "csv"));
      return this;
    }
  }
}
