package com.xforcecloud.open.client.api;

import com.xforcecloud.open.client.ApiClient;
import com.xforcecloud.open.client.EncodingUtils;

import com.xforcecloud.open.client.model.CustomPrintRequest;
import com.xforcecloud.open.client.model.CustomPrintResponse;
import com.xforcecloud.open.client.model.InvalidInvoiceRequest;
import com.xforcecloud.open.client.model.InvalidInvoiceResponse;
import com.xforcecloud.open.client.model.InvalidInvoiceResultResponse;
import com.xforcecloud.open.client.model.InvoicesDeviceRequest;
import com.xforcecloud.open.client.model.InvoicesDeviceResponse;
import com.xforcecloud.open.client.model.InvoicesPrintRequest;
import com.xforcecloud.open.client.model.InvoicesPrintResponse;
import com.xforcecloud.open.client.model.InvoicesPrintResultResponse;
import com.xforcecloud.open.client.model.InvoicesRequest;
import com.xforcecloud.open.client.model.InvoicesResponse;
import com.xforcecloud.open.client.model.InvoicesResultResponse;
import com.xforcecloud.open.client.model.NextInvoiceNoRequest;
import com.xforcecloud.open.client.model.NextInvoiceNoResponse;
import com.xforcecloud.open.client.model.NextInvoiceNoResultResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
public interface TwOutputInvoiceApi extends ApiClient.Api {


  /**
   * 订制打印
   * 
    * @param tenantId  (required)
    * @param customPrintRequest 订制打印请求 (optional)
   * @return CustomPrintResponse
   */
  @RequestLine("POST /{tenantId}/taxware/v1/output/invoices/custom/print")
  @Headers({
    "Content-Type: application/json",
    "Accept: application/json",
  })
  CustomPrintResponse customPrint(@Param("tenantId") String tenantId, CustomPrintRequest customPrintRequest);

  /**
   * 发票作废
   * 
    * @param tenantId  (required)
    * @param invalidInvoiceRequest 发票作废 (optional)
   * @return InvalidInvoiceResponse
   */
  @RequestLine("PUT /{tenantId}/taxware/v1/output/invoices/invalid_status")
  @Headers({
    "Content-Type: application/json",
    "Accept: application/json",
  })
  InvalidInvoiceResponse invalidInvoice(@Param("tenantId") String tenantId, InvalidInvoiceRequest invalidInvoiceRequest);

  /**
   * 发票作废
   * 
    * @param tenantId  (required)
    * @param serialNo 请求流水号 (required)
   * @return InvalidInvoiceResultResponse
   */
  @RequestLine("GET /{tenantId}/taxware/v1/output/invoices/invalid_status?serialNo={serialNo}")
  @Headers({
    "Content-Type: *",
    "Accept: application/json",
  })
  InvalidInvoiceResultResponse invalidInvoiceResult(@Param("tenantId") String tenantId, @Param("serialNo") String serialNo);

  /**
   * 发票作废
   * 
   * Note, this is equivalent to the other <code>invalidInvoiceResult</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link InvalidInvoiceResultQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param tenantId  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>serialNo - 请求流水号 (required)</li>
   *   </ul>
   * @return InvalidInvoiceResultResponse
   */
  @RequestLine("GET /{tenantId}/taxware/v1/output/invoices/invalid_status?serialNo={serialNo}")
  @Headers({
  "Content-Type: *",
  "Accept: application/json",
  })
  InvalidInvoiceResultResponse invalidInvoiceResult(@Param("tenantId") String tenantId, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>invalidInvoiceResult</code> method in a fluent style.
   */
  public static class InvalidInvoiceResultQueryParams extends HashMap<String, Object> {
    public InvalidInvoiceResultQueryParams serialNo(final String value) {
      put("serialNo", EncodingUtils.encode(value));
      return this;
    }
  }

  /**
   * 发票开具
   * 
    * @param tenantId  (required)
    * @param invoicesRequest 发票开具请求 (optional)
   * @return InvoicesResponse
   */
  @RequestLine("POST /{tenantId}/taxware/v1/output/invoices")
  @Headers({
    "Content-Type: application/json",
    "Accept: application/json",
  })
  InvoicesResponse invoices(@Param("tenantId") String tenantId, InvoicesRequest invoicesRequest);

  /**
   * 设备状态
   * 
    * @param tenantId  (required)
    * @param invoicesDeviceRequest 设备状态请求 (optional)
   * @return InvoicesDeviceResponse
   */
  @RequestLine("GET /{tenantId}/taxware/v1/output/invoices/device")
  @Headers({
    "Content-Type: application/json",
    "Accept: application/json",
  })
  InvoicesDeviceResponse invoicesDevice(@Param("tenantId") String tenantId, InvoicesDeviceRequest invoicesDeviceRequest);

  /**
   * 发票打印
   * 税控打印只需要传发票号码代码，订制打印不支持销货清单，全量打印与税控打印不支持版式设置
    * @param tenantId  (required)
    * @param invoicesPrintRequest 订制打印请求 (optional)
   * @return InvoicesPrintResponse
   */
  @RequestLine("POST /{tenantId}/taxware/v1/output/invoices/print")
  @Headers({
    "Content-Type: application/json",
    "Accept: application/json",
  })
  InvoicesPrintResponse invoicesPrint(@Param("tenantId") String tenantId, InvoicesPrintRequest invoicesPrintRequest);

  /**
   * 获取发票打印结果
   * 
    * @param tenantId  (required)
    * @param serialNo 请求流水号 (required)
   * @return InvoicesPrintResultResponse
   */
  @RequestLine("GET /{tenantId}/taxware/v1/output/invoices/print?serialNo={serialNo}")
  @Headers({
    "Content-Type: *",
    "Accept: application/json",
  })
  InvoicesPrintResultResponse invoicesPrintResult(@Param("tenantId") String tenantId, @Param("serialNo") String serialNo);

  /**
   * 获取发票打印结果
   * 
   * Note, this is equivalent to the other <code>invoicesPrintResult</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link InvoicesPrintResultQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param tenantId  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>serialNo - 请求流水号 (required)</li>
   *   </ul>
   * @return InvoicesPrintResultResponse
   */
  @RequestLine("GET /{tenantId}/taxware/v1/output/invoices/print?serialNo={serialNo}")
  @Headers({
  "Content-Type: *",
  "Accept: application/json",
  })
  InvoicesPrintResultResponse invoicesPrintResult(@Param("tenantId") String tenantId, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>invoicesPrintResult</code> method in a fluent style.
   */
  public static class InvoicesPrintResultQueryParams extends HashMap<String, Object> {
    public InvoicesPrintResultQueryParams serialNo(final String value) {
      put("serialNo", EncodingUtils.encode(value));
      return this;
    }
  }

  /**
   * 发票开具结果
   * 
    * @param tenantId  (required)
    * @param serialNo 请求流水号 (required)
   * @return InvoicesResultResponse
   */
  @RequestLine("GET /{tenantId}/taxware/v1/output/invoices?serialNo={serialNo}")
  @Headers({
    "Content-Type: *",
    "Accept: application/json",
  })
  InvoicesResultResponse invoicesResult(@Param("tenantId") String tenantId, @Param("serialNo") String serialNo);

  /**
   * 发票开具结果
   * 
   * Note, this is equivalent to the other <code>invoicesResult</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link InvoicesResultQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param tenantId  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>serialNo - 请求流水号 (required)</li>
   *   </ul>
   * @return InvoicesResultResponse
   */
  @RequestLine("GET /{tenantId}/taxware/v1/output/invoices?serialNo={serialNo}")
  @Headers({
  "Content-Type: *",
  "Accept: application/json",
  })
  InvoicesResultResponse invoicesResult(@Param("tenantId") String tenantId, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>invoicesResult</code> method in a fluent style.
   */
  public static class InvoicesResultQueryParams extends HashMap<String, Object> {
    public InvoicesResultQueryParams serialNo(final String value) {
      put("serialNo", EncodingUtils.encode(value));
      return this;
    }
  }

  /**
   * 下一张发票号码
   * 
    * @param tenantId  (required)
    * @param nextInvoiceNoRequest 获取下一张发票号码请求 (optional)
   * @return NextInvoiceNoResponse
   */
  @RequestLine("POST /{tenantId}/taxware/v1/output/invoices/nextInvoiceNo")
  @Headers({
    "Content-Type: application/json",
    "Accept: application/json",
  })
  NextInvoiceNoResponse nextInvoiceNo(@Param("tenantId") String tenantId, NextInvoiceNoRequest nextInvoiceNoRequest);

  /**
   * 下一张发票号码
   * 
    * @param tenantId  (required)
    * @param serialNo 请求流水号 (required)
   * @return NextInvoiceNoResultResponse
   */
  @RequestLine("GET /{tenantId}/taxware/v1/output/invoices/nextInvoiceNo?serialNo={serialNo}")
  @Headers({
    "Content-Type: *",
    "Accept: application/json",
  })
  NextInvoiceNoResultResponse nextInvoiceNoResult(@Param("tenantId") String tenantId, @Param("serialNo") String serialNo);

  /**
   * 下一张发票号码
   * 
   * Note, this is equivalent to the other <code>nextInvoiceNoResult</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link NextInvoiceNoResultQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param tenantId  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>serialNo - 请求流水号 (required)</li>
   *   </ul>
   * @return NextInvoiceNoResultResponse
   */
  @RequestLine("GET /{tenantId}/taxware/v1/output/invoices/nextInvoiceNo?serialNo={serialNo}")
  @Headers({
  "Content-Type: *",
  "Accept: application/json",
  })
  NextInvoiceNoResultResponse nextInvoiceNoResult(@Param("tenantId") String tenantId, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>nextInvoiceNoResult</code> method in a fluent style.
   */
  public static class NextInvoiceNoResultQueryParams extends HashMap<String, Object> {
    public NextInvoiceNoResultQueryParams serialNo(final String value) {
      put("serialNo", EncodingUtils.encode(value));
      return this;
    }
  }
}
