package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 单据请求条件，仅限主信息的操作
 */
@ApiModel(description = "单据请求条件，仅限主信息的操作")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class AbandonBillByParamRequest {
  @JsonProperty("businessBillType")
  private String businessBillType = null;

  @JsonProperty("purchaserCode")
  private String purchaserCode = null;

  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("sellerGroupCode")
  private String sellerGroupCode = null;

  @JsonProperty("sellerNo")
  private String sellerNo = null;

  @JsonIgnore
  public AbandonBillByParamRequest businessBillType (String businessBillType) {
    this.businessBillType = businessBillType;
    return this;
  }

   /**
   * ap：购方  ar-销方
   * @return businessBillType
  **/
  @ApiModelProperty(value = "ap：购方  ar-销方")
  public String getBusinessBillType() {
    return businessBillType;
  }

  public void setBusinessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
  }

  @JsonIgnore
  public AbandonBillByParamRequest purchaserCode (String purchaserCode) {
    this.purchaserCode = purchaserCode;
    return this;
  }

   /**
   * 购方租户code
   * @return purchaserCode
  **/
  @ApiModelProperty(value = "购方租户code")
  public String getPurchaserCode() {
    return purchaserCode;
  }

  public void setPurchaserCode(String purchaserCode) {
    this.purchaserCode = purchaserCode;
  }

  @JsonIgnore
  public AbandonBillByParamRequest salesbillNo (String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 单据编号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "单据编号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public AbandonBillByParamRequest sellerGroupCode (String sellerGroupCode) {
    this.sellerGroupCode = sellerGroupCode;
    return this;
  }

   /**
   * 销方租户code
   * @return sellerGroupCode
  **/
  @ApiModelProperty(value = "销方租户code")
  public String getSellerGroupCode() {
    return sellerGroupCode;
  }

  public void setSellerGroupCode(String sellerGroupCode) {
    this.sellerGroupCode = sellerGroupCode;
  }

  @JsonIgnore
  public AbandonBillByParamRequest sellerNo (String sellerNo) {
    this.sellerNo = sellerNo;
    return this;
  }

   /**
   * 销方编号
   * @return sellerNo
  **/
  @ApiModelProperty(value = "销方编号")
  public String getSellerNo() {
    return sellerNo;
  }

  public void setSellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AbandonBillByParamRequest abandonBillByParamRequest = (AbandonBillByParamRequest) o;
    return Objects.equals(this.businessBillType, abandonBillByParamRequest.businessBillType) &&
        Objects.equals(this.purchaserCode, abandonBillByParamRequest.purchaserCode) &&
        Objects.equals(this.salesbillNo, abandonBillByParamRequest.salesbillNo) &&
        Objects.equals(this.sellerGroupCode, abandonBillByParamRequest.sellerGroupCode) &&
        Objects.equals(this.sellerNo, abandonBillByParamRequest.sellerNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessBillType, purchaserCode, salesbillNo, sellerGroupCode, sellerNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AbandonBillByParamRequest {\n");
    
    sb.append("    businessBillType: ").append(toIndentedString(businessBillType)).append("\n");
    sb.append("    purchaserCode: ").append(toIndentedString(purchaserCode)).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    sellerGroupCode: ").append(toIndentedString(sellerGroupCode)).append("\n");
    sb.append("    sellerNo: ").append(toIndentedString(sellerNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
