package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.AuthRequestParamsDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * AuthRequestParams
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class AuthRequestParams {
  @JsonProperty("customerNo")
  private String customerNo = null;

  @JsonProperty("xcode")
  private String xcode = null;

  @JsonProperty("serialNo")
  private String serialNo = null;

  @JsonProperty("tenantNo")
  private String tenantNo = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("taxPeriod")
  private String taxPeriod = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("paperDrewDate")
  private String paperDrewDate = null;

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("cipherText")
  private String cipherText = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("twoCodeFlag")
  private String twoCodeFlag = null;

  @JsonProperty("cipherTextQrCode")
  private String cipherTextQrCode = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("debug")
  private String debug = null;

  @JsonProperty("bb")
  private String bb = null;

  @JsonProperty("details")
  private List<AuthRequestParamsDetails> details = new ArrayList<AuthRequestParamsDetails>();

  @JsonIgnore
  public AuthRequestParams customerNo (String customerNo) {
    this.customerNo = customerNo;
    return this;
  }

   /**
   * 回调编码
   * @return customerNo
  **/
  @ApiModelProperty(value = "回调编码")
  public String getCustomerNo() {
    return customerNo;
  }

  public void setCustomerNo(String customerNo) {
    this.customerNo = customerNo;
  }

  @JsonIgnore
  public AuthRequestParams xcode (String xcode) {
    this.xcode = xcode;
    return this;
  }

   /**
   * 配置码
   * @return xcode
  **/
  @ApiModelProperty(value = "配置码")
  public String getXcode() {
    return xcode;
  }

  public void setXcode(String xcode) {
    this.xcode = xcode;
  }

  @JsonIgnore
  public AuthRequestParams serialNo (String serialNo) {
    this.serialNo = serialNo;
    return this;
  }

   /**
   * 流水号
   * @return serialNo
  **/
  @ApiModelProperty(value = "流水号")
  public String getSerialNo() {
    return serialNo;
  }

  public void setSerialNo(String serialNo) {
    this.serialNo = serialNo;
  }

  @JsonIgnore
  public AuthRequestParams tenantNo (String tenantNo) {
    this.tenantNo = tenantNo;
    return this;
  }

   /**
   * 租户号
   * @return tenantNo
  **/
  @ApiModelProperty(value = "租户号")
  public String getTenantNo() {
    return tenantNo;
  }

  public void setTenantNo(String tenantNo) {
    this.tenantNo = tenantNo;
  }

  @JsonIgnore
  public AuthRequestParams taxNo (String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 请求公司税号
   * @return taxNo
  **/
  @ApiModelProperty(value = "请求公司税号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public AuthRequestParams taxPeriod (String taxPeriod) {
    this.taxPeriod = taxPeriod;
    return this;
  }

   /**
   * 认证请求所属期
   * @return taxPeriod
  **/
  @ApiModelProperty(value = "认证请求所属期")
  public String getTaxPeriod() {
    return taxPeriod;
  }

  public void setTaxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
  }

  @JsonIgnore
  public AuthRequestParams purchaserTaxNo (String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public AuthRequestParams invoiceCode (String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public AuthRequestParams invoiceNo (String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public AuthRequestParams sellerTaxNo (String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public AuthRequestParams paperDrewDate (String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

   /**
   * 开票日期
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "开票日期")
  public String getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public AuthRequestParams amountWithoutTax (String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public String getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public AuthRequestParams taxAmount (String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public AuthRequestParams taxRate (String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public AuthRequestParams cipherText (String cipherText) {
    this.cipherText = cipherText;
    return this;
  }

   /**
   * 密文
   * @return cipherText
  **/
  @ApiModelProperty(value = "密文")
  public String getCipherText() {
    return cipherText;
  }

  public void setCipherText(String cipherText) {
    this.cipherText = cipherText;
  }

  @JsonIgnore
  public AuthRequestParams invoiceType (String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public AuthRequestParams machineCode (String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 机器码
   * @return machineCode
  **/
  @ApiModelProperty(value = "机器码")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public AuthRequestParams twoCodeFlag (String twoCodeFlag) {
    this.twoCodeFlag = twoCodeFlag;
    return this;
  }

   /**
   * 二维码标志
   * @return twoCodeFlag
  **/
  @ApiModelProperty(value = "二维码标志")
  public String getTwoCodeFlag() {
    return twoCodeFlag;
  }

  public void setTwoCodeFlag(String twoCodeFlag) {
    this.twoCodeFlag = twoCodeFlag;
  }

  @JsonIgnore
  public AuthRequestParams cipherTextQrCode (String cipherTextQrCode) {
    this.cipherTextQrCode = cipherTextQrCode;
    return this;
  }

   /**
   * 二维码密文
   * @return cipherTextQrCode
  **/
  @ApiModelProperty(value = "二维码密文")
  public String getCipherTextQrCode() {
    return cipherTextQrCode;
  }

  public void setCipherTextQrCode(String cipherTextQrCode) {
    this.cipherTextQrCode = cipherTextQrCode;
  }

  @JsonIgnore
  public AuthRequestParams sellerName (String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public AuthRequestParams purchaserName (String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public AuthRequestParams debug (String debug) {
    this.debug = debug;
    return this;
  }

   /**
   * 是否debug，1-认证成功 2-认证失败
   * @return debug
  **/
  @ApiModelProperty(value = "是否debug，1-认证成功 2-认证失败")
  public String getDebug() {
    return debug;
  }

  public void setDebug(String debug) {
    this.debug = debug;
  }

  @JsonIgnore
  public AuthRequestParams bb (String bb) {
    this.bb = bb;
    return this;
  }

   /**
   * 2-2.0模式 ，4-4.0模式
   * @return bb
  **/
  @ApiModelProperty(value = "2-2.0模式 ，4-4.0模式")
  public String getBb() {
    return bb;
  }

  public void setBb(String bb) {
    this.bb = bb;
  }

  @JsonIgnore
  public AuthRequestParams details (List<AuthRequestParamsDetails> details) {
    this.details = details;
    return this;
  }

  public AuthRequestParams addDetailsItem(AuthRequestParamsDetails detailsItem) {
    this.details.add(detailsItem);
    return this;
  }

   /**
   * 发票明细
   * @return details
  **/
  @ApiModelProperty(value = "发票明细")
  public List<AuthRequestParamsDetails> getDetails() {
    return details;
  }

  public void setDetails(List<AuthRequestParamsDetails> details) {
    this.details = details;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthRequestParams authRequestParams = (AuthRequestParams) o;
    return Objects.equals(this.customerNo, authRequestParams.customerNo) &&
        Objects.equals(this.xcode, authRequestParams.xcode) &&
        Objects.equals(this.serialNo, authRequestParams.serialNo) &&
        Objects.equals(this.tenantNo, authRequestParams.tenantNo) &&
        Objects.equals(this.taxNo, authRequestParams.taxNo) &&
        Objects.equals(this.taxPeriod, authRequestParams.taxPeriod) &&
        Objects.equals(this.purchaserTaxNo, authRequestParams.purchaserTaxNo) &&
        Objects.equals(this.invoiceCode, authRequestParams.invoiceCode) &&
        Objects.equals(this.invoiceNo, authRequestParams.invoiceNo) &&
        Objects.equals(this.sellerTaxNo, authRequestParams.sellerTaxNo) &&
        Objects.equals(this.paperDrewDate, authRequestParams.paperDrewDate) &&
        Objects.equals(this.amountWithoutTax, authRequestParams.amountWithoutTax) &&
        Objects.equals(this.taxAmount, authRequestParams.taxAmount) &&
        Objects.equals(this.taxRate, authRequestParams.taxRate) &&
        Objects.equals(this.cipherText, authRequestParams.cipherText) &&
        Objects.equals(this.invoiceType, authRequestParams.invoiceType) &&
        Objects.equals(this.machineCode, authRequestParams.machineCode) &&
        Objects.equals(this.twoCodeFlag, authRequestParams.twoCodeFlag) &&
        Objects.equals(this.cipherTextQrCode, authRequestParams.cipherTextQrCode) &&
        Objects.equals(this.sellerName, authRequestParams.sellerName) &&
        Objects.equals(this.purchaserName, authRequestParams.purchaserName) &&
        Objects.equals(this.debug, authRequestParams.debug) &&
        Objects.equals(this.bb, authRequestParams.bb) &&
        Objects.equals(this.details, authRequestParams.details);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerNo, xcode, serialNo, tenantNo, taxNo, taxPeriod, purchaserTaxNo, invoiceCode, invoiceNo, sellerTaxNo, paperDrewDate, amountWithoutTax, taxAmount, taxRate, cipherText, invoiceType, machineCode, twoCodeFlag, cipherTextQrCode, sellerName, purchaserName, debug, bb, details);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthRequestParams {\n");
    
    sb.append("    customerNo: ").append(toIndentedString(customerNo)).append("\n");
    sb.append("    xcode: ").append(toIndentedString(xcode)).append("\n");
    sb.append("    serialNo: ").append(toIndentedString(serialNo)).append("\n");
    sb.append("    tenantNo: ").append(toIndentedString(tenantNo)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    taxPeriod: ").append(toIndentedString(taxPeriod)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    cipherText: ").append(toIndentedString(cipherText)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    twoCodeFlag: ").append(toIndentedString(twoCodeFlag)).append("\n");
    sb.append("    cipherTextQrCode: ").append(toIndentedString(cipherTextQrCode)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    debug: ").append(toIndentedString(debug)).append("\n");
    sb.append("    bb: ").append(toIndentedString(bb)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
