package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.Message;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 接口抛单据的头信息
 */
@ApiModel(description = "接口抛单据的头信息")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class BillUploadRequest {
  @JsonProperty("businessBillType")
  private String businessBillType = null;

  @JsonProperty("customNo")
  private String customNo = null;

  @JsonProperty("message")
  private List<Message> message = new ArrayList<Message>();

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("systemOrig")
  private String systemOrig = null;

  @JsonProperty("versionNo")
  private String versionNo = null;

  @JsonIgnore
  public BillUploadRequest businessBillType (String businessBillType) {
    this.businessBillType = businessBillType;
    return this;
  }

   /**
   * AR：销方,AP:购方
   * @return businessBillType
  **/
  @ApiModelProperty(value = "AR：销方,AP:购方")
  public String getBusinessBillType() {
    return businessBillType;
  }

  public void setBusinessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
  }

  @JsonIgnore
  public BillUploadRequest customNo (String customNo) {
    this.customNo = customNo;
    return this;
  }

   /**
   * null
   * @return customNo
  **/
  @ApiModelProperty(value = "null")
  public String getCustomNo() {
    return customNo;
  }

  public void setCustomNo(String customNo) {
    this.customNo = customNo;
  }

  @JsonIgnore
  public BillUploadRequest message (List<Message> message) {
    this.message = message;
    return this;
  }

  public BillUploadRequest addMessageItem(Message messageItem) {
    this.message.add(messageItem);
    return this;
  }

   /**
   * 消息体
   * @return message
  **/
  @ApiModelProperty(value = "消息体")
  public List<Message> getMessage() {
    return message;
  }

  public void setMessage(List<Message> message) {
    this.message = message;
  }

  @JsonIgnore
  public BillUploadRequest status (String status) {
    this.status = status;
    return this;
  }

   /**
   * 状态
   * @return status
  **/
  @ApiModelProperty(value = "状态")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  @JsonIgnore
  public BillUploadRequest systemOrig (String systemOrig) {
    this.systemOrig = systemOrig;
    return this;
  }

   /**
   * 系统了来源
   * @return systemOrig
  **/
  @ApiModelProperty(value = "系统了来源")
  public String getSystemOrig() {
    return systemOrig;
  }

  public void setSystemOrig(String systemOrig) {
    this.systemOrig = systemOrig;
  }

  @JsonIgnore
  public BillUploadRequest versionNo (String versionNo) {
    this.versionNo = versionNo;
    return this;
  }

   /**
   * 版本号
   * @return versionNo
  **/
  @ApiModelProperty(value = "版本号")
  public String getVersionNo() {
    return versionNo;
  }

  public void setVersionNo(String versionNo) {
    this.versionNo = versionNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BillUploadRequest billUploadRequest = (BillUploadRequest) o;
    return Objects.equals(this.businessBillType, billUploadRequest.businessBillType) &&
        Objects.equals(this.customNo, billUploadRequest.customNo) &&
        Objects.equals(this.message, billUploadRequest.message) &&
        Objects.equals(this.status, billUploadRequest.status) &&
        Objects.equals(this.systemOrig, billUploadRequest.systemOrig) &&
        Objects.equals(this.versionNo, billUploadRequest.versionNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessBillType, customNo, message, status, systemOrig, versionNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BillUploadRequest {\n");
    
    sb.append("    businessBillType: ").append(toIndentedString(businessBillType)).append("\n");
    sb.append("    customNo: ").append(toIndentedString(customNo)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    systemOrig: ").append(toIndentedString(systemOrig)).append("\n");
    sb.append("    versionNo: ").append(toIndentedString(versionNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
